/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.smile;

import java.math.BigDecimal;
import java.math.BigInteger;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.StreamReadCapability;
import tools.jackson.core.StreamReadFeature;
import tools.jackson.core.TokenStreamLocation;
import tools.jackson.core.Version;
import tools.jackson.core.base.ParserMinimalBase;
import tools.jackson.core.exc.StreamReadException;
import tools.jackson.core.io.ContentReference;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.json.DupDetector;
import tools.jackson.core.sym.ByteQuadsCanonicalizer;
import tools.jackson.core.util.JacksonFeature;
import tools.jackson.core.util.JacksonFeatureSet;
import tools.jackson.core.util.SimpleStreamReadContext;
import tools.jackson.core.util.TextBuffer;
import tools.jackson.dataformat.smile.PackageVersion;

public abstract class SmileParserBase
extends ParserMinimalBase {
    protected static final String[] NO_STRINGS = new String[0];
    protected static final int LONGEST_NON_CHUNKED_BINARY = 250000;
    protected static final int DEFAULT_NAME_BUFFER_LENGTH = 64;
    protected static final int DEFAULT_STRING_VALUE_BUFFER_LENGTH = 64;
    protected static final JacksonFeatureSet<StreamReadCapability> SMILE_READ_CAPABILITIES = DEFAULT_READ_CAPABILITIES.with((JacksonFeature)StreamReadCapability.EXACT_FLOATS);
    protected int _formatFeatures;
    protected boolean _mayContainRawBinary;
    protected int _inputPtr = 0;
    protected int _inputEnd = 0;
    protected long _currInputProcessed;
    protected int _tokenOffsetForTotal;
    protected SimpleStreamReadContext _streamReadContext;
    protected final TextBuffer _textBuffer;
    protected byte[] _binaryValue;
    protected JsonParser.NumberType _numberType;
    protected int _numTypesValid = 0;
    protected BigInteger _numberBigInt;
    protected BigDecimal _numberBigDecimal;
    protected int _numberInt;
    protected long _numberLong;
    protected float _numberFloat;
    protected double _numberDouble;
    protected final ByteQuadsCanonicalizer _symbols;
    protected int[] _quadBuffer = NO_INTS;
    protected int _quad1;
    protected int _quad2;
    protected int _quad3;
    protected final boolean _symbolsCanonical;
    protected String[] _seenNames = NO_STRINGS;
    protected int _seenNameCount = 0;
    protected String[] _seenStringValues = null;
    protected int _seenStringValueCount = -1;

    public SmileParserBase(ObjectReadContext readCtxt, IOContext ioCtxt, int parserFeatures, int formatFeatures, ByteQuadsCanonicalizer sym) {
        super(readCtxt, ioCtxt, parserFeatures);
        this._formatFeatures = formatFeatures;
        this._symbols = sym;
        this._symbolsCanonical = sym.isCanonicalizing();
        DupDetector dups = StreamReadFeature.STRICT_DUPLICATE_DETECTION.enabledIn(parserFeatures) ? DupDetector.rootDetector((JsonParser)this) : null;
        this._streamReadContext = SimpleStreamReadContext.createRootContext((DupDetector)dups);
        this._textBuffer = ioCtxt.constructReadConstrainedTextBuffer();
    }

    public final Version version() {
        return PackageVersion.VERSION;
    }

    public JacksonFeatureSet<StreamReadCapability> streamReadCapabilities() {
        return SMILE_READ_CAPABILITIES;
    }

    public final boolean mayContainRawBinary() {
        return this._mayContainRawBinary;
    }

    protected abstract void _closeInput() throws JacksonException;

    protected abstract void _parseNumericValue() throws JacksonException;

    public final SimpleStreamReadContext streamReadContext() {
        return this._streamReadContext;
    }

    public void assignCurrentValue(Object v) {
        this._streamReadContext.assignCurrentValue(v);
    }

    public Object currentValue() {
        return this._streamReadContext.currentValue();
    }

    public final boolean isClosed() {
        return this._closed;
    }

    public final TokenStreamLocation currentTokenLocation() {
        long total = this._currInputProcessed + (long)this._tokenOffsetForTotal;
        return new TokenStreamLocation(this._ioContext.contentReference(), total, -1L, -1, (int)total);
    }

    public final TokenStreamLocation currentLocation() {
        long offset = this._currInputProcessed + (long)this._inputPtr;
        return new TokenStreamLocation(this._ioContext.contentReference(), offset, -1L, -1, (int)offset);
    }

    public final String currentName() {
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            return this._streamReadContext.getParent().currentName();
        }
        return this._streamReadContext.currentName();
    }

    public final void close() throws JacksonException {
        super.close();
        this._inputEnd = 0;
        this._symbols.release();
    }

    protected final void _releaseBuffers() {
        this._textBuffer.releaseBuffers();
        this._releaseBuffers2();
    }

    protected abstract void _releaseBuffers2();

    public final boolean isNaN() throws JacksonException {
        if (this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue();
            }
            if ((this._numTypesValid & 8) != 0) {
                return !Double.isFinite(this._numberDouble);
            }
            if ((this._numTypesValid & 0x20) != 0) {
                return !Float.isFinite(this._numberFloat);
            }
        }
        return false;
    }

    public final Number getNumberValue() throws JacksonException {
        if (this._numTypesValid == 0) {
            this._parseNumericValue();
        }
        switch (this._numberType) {
            case INT: {
                return this._numberInt;
            }
            case LONG: {
                return this._numberLong;
            }
            case BIG_INTEGER: {
                return this._numberBigInt;
            }
            case FLOAT: {
                return Float.valueOf(this._numberFloat);
            }
            case DOUBLE: {
                return this._numberDouble;
            }
        }
        return this._numberBigDecimal;
    }

    public final Number getNumberValueExact() throws JacksonException {
        return this.getNumberValue();
    }

    public final JsonParser.NumberType getNumberType() throws JacksonException {
        if (this._numTypesValid == 0) {
            this._parseNumericValue();
        }
        return this._numberType;
    }

    public JsonParser.NumberTypeFP getNumberTypeFP() throws JacksonException {
        if (this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue();
            }
            if (this._numberType == JsonParser.NumberType.BIG_DECIMAL) {
                return JsonParser.NumberTypeFP.BIG_DECIMAL;
            }
            if (this._numberType == JsonParser.NumberType.DOUBLE) {
                return JsonParser.NumberTypeFP.DOUBLE64;
            }
            if (this._numberType == JsonParser.NumberType.FLOAT) {
                return JsonParser.NumberTypeFP.FLOAT32;
            }
        }
        return JsonParser.NumberTypeFP.UNKNOWN;
    }

    public final int getIntValue() throws JacksonException {
        if ((this._numTypesValid & 1) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue();
            }
            if ((this._numTypesValid & 1) == 0) {
                this.convertNumberToInt();
            }
        }
        return this._numberInt;
    }

    public final long getLongValue() throws JacksonException {
        if ((this._numTypesValid & 2) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue();
            }
            if ((this._numTypesValid & 2) == 0) {
                this.convertNumberToLong();
            }
        }
        return this._numberLong;
    }

    public final BigInteger getBigIntegerValue() throws JacksonException {
        if ((this._numTypesValid & 4) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue();
            }
            if ((this._numTypesValid & 4) == 0) {
                this.convertNumberToBigInteger();
            }
        }
        return this._numberBigInt;
    }

    public final float getFloatValue() throws JacksonException {
        if ((this._numTypesValid & 0x20) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue();
            }
            if ((this._numTypesValid & 0x20) == 0) {
                this.convertNumberToFloat();
            }
        }
        return this._numberFloat;
    }

    public final double getDoubleValue() throws JacksonException {
        if ((this._numTypesValid & 8) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue();
            }
            if ((this._numTypesValid & 8) == 0) {
                this.convertNumberToDouble();
            }
        }
        return this._numberDouble;
    }

    public final BigDecimal getDecimalValue() throws JacksonException {
        if ((this._numTypesValid & 0x10) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue();
            }
            if ((this._numTypesValid & 0x10) == 0) {
                this.convertNumberToBigDecimal();
            }
        }
        return this._numberBigDecimal;
    }

    protected final void convertNumberToInt() throws JacksonException {
        if ((this._numTypesValid & 2) != 0) {
            int result = (int)this._numberLong;
            if ((long)result != this._numberLong) {
                this._reportOverflowInt(String.valueOf(this._numberLong));
            }
            this._numberInt = result;
        } else if ((this._numTypesValid & 4) != 0) {
            if (BI_MIN_INT.compareTo(this._numberBigInt) > 0 || BI_MAX_INT.compareTo(this._numberBigInt) < 0) {
                this._reportOverflowInt(String.valueOf(this._numberBigInt));
            }
            this._numberInt = this._numberBigInt.intValue();
        } else if ((this._numTypesValid & 8) != 0) {
            if (this._numberDouble < -2.147483648E9 || this._numberDouble > 2.147483647E9) {
                this._reportOverflowInt(String.valueOf(this._numberDouble));
            }
            this._numberInt = (int)this._numberDouble;
        } else if ((this._numTypesValid & 0x20) != 0) {
            if ((double)this._numberFloat < -2.147483648E9 || (double)this._numberFloat > 2.147483647E9) {
                this._reportOverflowInt(String.valueOf(this._numberFloat));
            }
            this._numberInt = (int)this._numberFloat;
        } else if ((this._numTypesValid & 0x10) != 0) {
            if (BD_MIN_INT.compareTo(this._numberBigDecimal) > 0 || BD_MAX_INT.compareTo(this._numberBigDecimal) < 0) {
                this._reportOverflowInt(String.valueOf(this._numberBigDecimal));
            }
            this._numberInt = this._numberBigDecimal.intValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 1;
    }

    protected final void convertNumberToLong() throws JacksonException {
        int v = this._numTypesValid;
        if ((v & 1) != 0) {
            this._numberLong = this._numberInt;
        } else if ((v & 4) != 0) {
            if (BI_MIN_LONG.compareTo(this._numberBigInt) > 0 || BI_MAX_LONG.compareTo(this._numberBigInt) < 0) {
                this._reportOverflowLong(String.valueOf(this._numberBigInt));
            }
            this._numberLong = this._numberBigInt.longValue();
        } else if ((v & 8) != 0) {
            if (this._numberDouble < -9.223372036854776E18 || this._numberDouble > 9.223372036854776E18) {
                this._reportOverflowLong(String.valueOf(this._numberDouble));
            }
            this._numberLong = (long)this._numberDouble;
        } else if ((v & 0x20) != 0) {
            if ((double)this._numberFloat < -9.223372036854776E18 || (double)this._numberFloat > 9.223372036854776E18) {
                this._reportOverflowLong(String.valueOf(this._numberFloat));
            }
            this._numberLong = (long)this._numberFloat;
        } else if ((v & 0x10) != 0) {
            if (BD_MIN_LONG.compareTo(this._numberBigDecimal) > 0 || BD_MAX_LONG.compareTo(this._numberBigDecimal) < 0) {
                this._reportOverflowLong(String.valueOf(this._numberBigDecimal));
            }
            this._numberLong = this._numberBigDecimal.longValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 2;
    }

    protected final void convertNumberToBigInteger() throws JacksonException {
        if ((this._numTypesValid & 0x10) != 0) {
            this._streamReadConstraints.validateBigIntegerScale(this._numberBigDecimal.scale());
            this._numberBigInt = this._numberBigDecimal.toBigInteger();
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberLong);
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberInt);
        } else if ((this._numTypesValid & 8) != 0) {
            this._numberBigInt = BigDecimal.valueOf(this._numberDouble).toBigInteger();
        } else if ((this._numTypesValid & 0x20) != 0) {
            this._numberBigInt = BigDecimal.valueOf(this._numberFloat).toBigInteger();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 4;
    }

    protected final void convertNumberToFloat() throws JacksonException {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberFloat = this._numberBigDecimal.floatValue();
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberFloat = this._numberBigInt.floatValue();
        } else if ((this._numTypesValid & 8) != 0) {
            this._numberFloat = (float)this._numberDouble;
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberFloat = this._numberLong;
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberFloat = this._numberInt;
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 0x20;
    }

    protected final void convertNumberToDouble() throws JacksonException {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberDouble = this._numberBigDecimal.doubleValue();
        } else if ((this._numTypesValid & 0x20) != 0) {
            this._numberDouble = this._numberFloat;
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberDouble = this._numberBigInt.doubleValue();
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberDouble = this._numberLong;
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberDouble = this._numberInt;
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 8;
    }

    protected final void convertNumberToBigDecimal() throws JacksonException {
        if ((this._numTypesValid & 8) != 0) {
            this._numberBigDecimal = new BigDecimal(this._numberDouble);
        } else if ((this._numTypesValid & 0x20) != 0) {
            this._numberBigDecimal = new BigDecimal(this._numberFloat);
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberBigDecimal = new BigDecimal(this._numberBigInt);
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberBigDecimal = BigDecimal.valueOf(this._numberLong);
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberBigDecimal = BigDecimal.valueOf(this._numberInt);
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 0x10;
    }

    protected void _handleEOF() throws StreamReadException {
        if (!this._streamReadContext.inRoot()) {
            String marker = this._streamReadContext.inArray() ? "Array" : "Object";
            this._reportInvalidEOF(String.format(": expected close marker for %s (start marker at %s)", marker, this._streamReadContext.startLocation(this._sourceReference())), null);
        }
    }

    protected void _reportMismatchedEndMarker(int actCh, char expCh) throws StreamReadException {
        SimpleStreamReadContext ctxt = this.streamReadContext();
        this._reportError(String.format("Unexpected close marker '%s': expected '%c' (for %s starting at %s)", Character.valueOf((char)actCh), Character.valueOf(expCh), ctxt.typeDesc(), ctxt.startLocation(this._sourceReference())));
    }

    protected ContentReference _sourceReference() {
        if (this.isEnabled(StreamReadFeature.INCLUDE_SOURCE_IN_LOCATION)) {
            return this._ioContext.contentReference();
        }
        return ContentReference.unknown();
    }
}

