/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.smile;

import java.io.DataInput;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import tools.jackson.core.ErrorReportConfiguration;
import tools.jackson.core.FormatSchema;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.StreamReadConstraints;
import tools.jackson.core.StreamWriteConstraints;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.core.Version;
import tools.jackson.core.base.BinaryTSFactory;
import tools.jackson.core.base.DecorableTSFactory;
import tools.jackson.core.exc.StreamWriteException;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.sym.BinaryNameMatcher;
import tools.jackson.core.sym.ByteQuadsCanonicalizer;
import tools.jackson.core.sym.PropertyNameMatcher;
import tools.jackson.core.util.Named;
import tools.jackson.dataformat.smile.PackageVersion;
import tools.jackson.dataformat.smile.SmileFactoryBuilder;
import tools.jackson.dataformat.smile.SmileGenerator;
import tools.jackson.dataformat.smile.SmileParserBootstrapper;
import tools.jackson.dataformat.smile.SmileReadFeature;
import tools.jackson.dataformat.smile.SmileWriteFeature;
import tools.jackson.dataformat.smile.async.NonBlockingByteArrayParser;

public class SmileFactory
extends BinaryTSFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT_NAME_SMILE = "Smile";
    static final int DEFAULT_SMILE_PARSER_FEATURE_FLAGS = SmileReadFeature.collectDefaults();
    static final int DEFAULT_SMILE_GENERATOR_FEATURE_FLAGS = SmileWriteFeature.collectDefaults();
    protected final transient ByteQuadsCanonicalizer _byteSymbolCanonicalizer = ByteQuadsCanonicalizer.createRoot();

    public SmileFactory() {
        super(StreamReadConstraints.defaults(), StreamWriteConstraints.defaults(), ErrorReportConfiguration.defaults(), DEFAULT_SMILE_PARSER_FEATURE_FLAGS, DEFAULT_SMILE_GENERATOR_FEATURE_FLAGS);
    }

    public SmileFactory(SmileFactory src) {
        super((BinaryTSFactory)src);
    }

    protected SmileFactory(SmileFactoryBuilder b) {
        super((DecorableTSFactory.DecorableTSFBuilder)b);
    }

    public SmileFactoryBuilder rebuild() {
        return new SmileFactoryBuilder(this);
    }

    public static SmileFactoryBuilder builder() {
        return new SmileFactoryBuilder();
    }

    public SmileFactory copy() {
        return new SmileFactory(this);
    }

    public TokenStreamFactory snapshot() {
        return this;
    }

    protected Object readResolve() {
        return new SmileFactory(this);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public boolean canParseAsync() {
        return true;
    }

    public final boolean isEnabled(SmileReadFeature f) {
        return f.enabledIn(this._formatReadFeatures);
    }

    public final boolean isEnabled(SmileWriteFeature f) {
        return f.enabledIn(this._formatWriteFeatures);
    }

    public String getFormatName() {
        return FORMAT_NAME_SMILE;
    }

    public boolean canUseSchema(FormatSchema schema) {
        return false;
    }

    public Class<SmileReadFeature> getFormatReadFeatureType() {
        return SmileReadFeature.class;
    }

    public Class<SmileWriteFeature> getFormatWriteFeatureType() {
        return SmileWriteFeature.class;
    }

    public NonBlockingByteArrayParser createNonBlockingByteArrayParser(ObjectReadContext readCtxt) {
        ByteQuadsCanonicalizer can = this._byteSymbolCanonicalizer.makeChildOrPlaceholder(this._factoryFeatures);
        return new NonBlockingByteArrayParser(readCtxt, this._createContext(null, false), readCtxt.getStreamReadFeatures(this._streamReadFeatures), readCtxt.getFormatReadFeatures(this._formatReadFeatures), can);
    }

    protected JsonParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, InputStream in) {
        return new SmileParserBootstrapper(ioCtxt, in).constructParser(readCtxt, this._factoryFeatures, readCtxt.getStreamReadFeatures(this._streamReadFeatures), readCtxt.getFormatReadFeatures(this._formatReadFeatures), this._byteSymbolCanonicalizer);
    }

    protected JsonParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, byte[] data, int offset, int len) {
        return new SmileParserBootstrapper(ioCtxt, data, offset, len).constructParser(readCtxt, this._factoryFeatures, readCtxt.getStreamReadFeatures(this._streamReadFeatures), readCtxt.getFormatReadFeatures(this._formatReadFeatures), this._byteSymbolCanonicalizer);
    }

    protected JsonParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, DataInput input) {
        return (JsonParser)this._unsupported();
    }

    protected JsonGenerator _createGenerator(ObjectWriteContext writeCtxt, IOContext ioCtxt, OutputStream out) {
        int smileFeatures = writeCtxt.getFormatWriteFeatures(this._formatWriteFeatures);
        SmileGenerator gen = new SmileGenerator(writeCtxt, ioCtxt, writeCtxt.getStreamWriteFeatures(this._streamWriteFeatures), smileFeatures, out);
        if (SmileWriteFeature.WRITE_HEADER.enabledIn(smileFeatures)) {
            gen.writeHeader();
        } else {
            if (SmileWriteFeature.CHECK_SHARED_STRING_VALUES.enabledIn(smileFeatures)) {
                throw new StreamWriteException((JsonGenerator)gen, "Inconsistent settings: WRITE_HEADER disabled, but CHECK_SHARED_STRING_VALUES enabled; can not construct generator due to possible data loss (either enable WRITE_HEADER, or disable CHECK_SHARED_STRING_VALUES to resolve)");
            }
            if (!SmileWriteFeature.ENCODE_BINARY_AS_7BIT.enabledIn(smileFeatures)) {
                throw new StreamWriteException((JsonGenerator)gen, "Inconsistent settings: WRITE_HEADER disabled, but ENCODE_BINARY_AS_7BIT disabled; can not construct generator due to possible data loss (either enable WRITE_HEADER, or ENCODE_BINARY_AS_7BIT to resolve)");
            }
        }
        return gen;
    }

    public PropertyNameMatcher constructNameMatcher(List<Named> matches, boolean alreadyInterned) {
        return BinaryNameMatcher.constructFrom(matches, (boolean)alreadyInterned);
    }

    public PropertyNameMatcher constructCINameMatcher(List<Named> matches, boolean alreadyInterned, Locale locale) {
        return BinaryNameMatcher.constructCaseInsensitive((Locale)locale, matches, (boolean)alreadyInterned);
    }
}

