/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.protobuf.schemagen;

import com.squareup.protoparser.DataType;
import com.squareup.protoparser.FieldElement;
import com.squareup.protoparser.MessageElement;
import com.squareup.protoparser.TypeElement;
import java.util.HashSet;
import java.util.Set;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import tools.jackson.dataformat.protobuf.schemagen.AnnotationBasedTagGenerator;
import tools.jackson.dataformat.protobuf.schemagen.DefaultTagGenerator;
import tools.jackson.dataformat.protobuf.schemagen.DefinedTypeElementBuilders;
import tools.jackson.dataformat.protobuf.schemagen.ProtoBufSchemaVisitor;
import tools.jackson.dataformat.protobuf.schemagen.ProtobufSchemaHelper;
import tools.jackson.dataformat.protobuf.schemagen.TagGenerator;
import tools.jackson.dataformat.protobuf.schemagen.TypeElementBuilder;

public class MessageElementVisitor
extends JsonObjectFormatVisitor.Base
implements TypeElementBuilder {
    protected MessageElement.Builder _builder;
    protected TagGenerator _tagGenerator;
    protected JavaType _type;
    protected Set<JavaType> _nestedTypes = new HashSet<JavaType>();
    protected DefinedTypeElementBuilders _definedTypeElementBuilders;

    public MessageElementVisitor(SerializationContext provider, JavaType type, DefinedTypeElementBuilders definedTypeElementBuilders, boolean isNested) {
        super(provider);
        this._definedTypeElementBuilders = definedTypeElementBuilders;
        this._type = type;
        this._builder = MessageElement.builder();
        this._builder.name(type.getRawClass().getSimpleName());
        this._builder.documentation("Message for " + type.toCanonical());
    }

    @Override
    public TypeElement build() {
        return this._builder.build();
    }

    public void property(BeanProperty writer) {
        this._builder.addField(this.buildFieldElement(writer, FieldElement.Label.REQUIRED));
    }

    public void property(String name, JsonFormatVisitable handler, JavaType propertyTypeHint) {
        throw new UnsupportedOperationException();
    }

    public void optionalProperty(BeanProperty writer) {
        this._builder.addField(this.buildFieldElement(writer, FieldElement.Label.OPTIONAL));
    }

    public void optionalProperty(String name, JsonFormatVisitable handler, JavaType propertyTypeHint) {
        throw new UnsupportedOperationException();
    }

    protected FieldElement buildFieldElement(BeanProperty writer, FieldElement.Label label) {
        FieldElement.Builder fBuilder = FieldElement.builder();
        fBuilder.name(writer.getName());
        fBuilder.tag(this.nextTag(writer));
        JavaType type = writer.getType();
        if (type.isArrayType() || type.isCollectionLikeType()) {
            if (ProtobufSchemaHelper.isBinaryType(type)) {
                fBuilder.label(label);
                fBuilder.type((DataType)DataType.ScalarType.BYTES);
            } else {
                fBuilder.label(FieldElement.Label.REPEATED);
                fBuilder.type(this.getDataType(type.getContentType()));
            }
        } else {
            fBuilder.label(label);
            fBuilder.type(this.getDataType(type));
        }
        return fBuilder.build();
    }

    protected int nextTag(BeanProperty writer) {
        this.getTagGenerator(writer);
        return this._tagGenerator.nextTag(writer);
    }

    protected void getTagGenerator(BeanProperty writer) {
        if (this._tagGenerator == null) {
            this._tagGenerator = ProtobufSchemaHelper.hasIndex(writer) ? new AnnotationBasedTagGenerator() : new DefaultTagGenerator();
        }
    }

    protected DataType getDataType(JavaType type) {
        if (!this._definedTypeElementBuilders.containsBuilderFor(type)) {
            if (this.isNested(type)) {
                if (!this._nestedTypes.contains(type)) {
                    this._nestedTypes.add(type);
                    ProtoBufSchemaVisitor builder = this.acceptTypeElement(this._provider, type, this._definedTypeElementBuilders, true);
                    DataType scalarType = builder.getSimpleType();
                    if (scalarType != null) {
                        return scalarType;
                    }
                    this._builder.addType(builder.build());
                }
            } else {
                ProtoBufSchemaVisitor builder = this.acceptTypeElement(this._provider, type, this._definedTypeElementBuilders, false);
                DataType scalarType = builder.getSimpleType();
                if (scalarType != null) {
                    return scalarType;
                }
            }
        }
        return DataType.NamedType.create((String)type.getRawClass().getSimpleName());
    }

    private ProtoBufSchemaVisitor acceptTypeElement(SerializationContext provider, JavaType type, DefinedTypeElementBuilders definedTypeElementBuilders, boolean isNested) {
        ValueSerializer serializer = provider.findRootValueSerializer(type);
        ProtoBufSchemaVisitor visitor = new ProtoBufSchemaVisitor(provider, definedTypeElementBuilders, isNested);
        serializer.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)visitor, type);
        return visitor;
    }

    private boolean isNested(JavaType type) {
        Class match = type.getRawClass();
        for (Class<?> cls : this._type.getRawClass().getDeclaredClasses()) {
            if (cls != match) continue;
            return true;
        }
        return false;
    }
}

