/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.protobuf.schema;

import com.squareup.protoparser.DataType;
import com.squareup.protoparser.EnumConstantElement;
import com.squareup.protoparser.EnumElement;
import com.squareup.protoparser.FieldElement;
import com.squareup.protoparser.MessageElement;
import com.squareup.protoparser.TypeElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import tools.jackson.core.util.InternCache;
import tools.jackson.dataformat.protobuf.schema.FieldType;
import tools.jackson.dataformat.protobuf.schema.FieldTypes;
import tools.jackson.dataformat.protobuf.schema.ProtobufEnum;
import tools.jackson.dataformat.protobuf.schema.ProtobufField;
import tools.jackson.dataformat.protobuf.schema.ProtobufMessage;

public class TypeResolver {
    private final TypeResolver _parent;
    private final String _contextName;
    private Map<String, MessageElement> _declaredMessageTypes;
    private Map<String, ProtobufEnum> _enumTypes;
    private Map<String, ProtobufMessage> _resolvedMessageTypes;

    protected TypeResolver(TypeResolver p, String name, Map<String, MessageElement> declaredMsgs, Map<String, ProtobufEnum> enums) {
        this._parent = p;
        this._contextName = name;
        this._enumTypes = enums;
        if (declaredMsgs == null) {
            declaredMsgs = Collections.emptyMap();
        }
        this._declaredMessageTypes = declaredMsgs;
        this._resolvedMessageTypes = Collections.emptyMap();
    }

    public static ProtobufMessage resolve(Collection<TypeElement> nativeTypes, MessageElement rawType) {
        TypeResolver rootR = TypeResolver.construct(null, null, nativeTypes);
        return TypeResolver.construct(rootR, rawType.name(), rawType.nestedElements())._resolve(rawType);
    }

    protected ProtobufMessage resolve(TypeResolver parent, MessageElement rawType) {
        return TypeResolver.construct(this, rawType.name(), rawType.nestedElements())._resolve(rawType);
    }

    protected static TypeResolver construct(TypeResolver parent, String localName, Collection<TypeElement> nativeTypes) {
        LinkedHashMap<String, MessageElement> declaredMsgs = null;
        LinkedHashMap<String, ProtobufEnum> declaredEnums = new LinkedHashMap<String, ProtobufEnum>();
        for (TypeElement nt : nativeTypes) {
            if (nt instanceof MessageElement) {
                if (declaredMsgs == null) {
                    declaredMsgs = new LinkedHashMap<String, MessageElement>();
                }
                declaredMsgs.put(nt.name(), (MessageElement)nt);
                continue;
            }
            if (!(nt instanceof EnumElement)) continue;
            ProtobufEnum enumType = TypeResolver.constructEnum((EnumElement)nt);
            declaredEnums.put(nt.name(), enumType);
            if (parent == null) continue;
            parent.addEnumType(TypeResolver._scopedName(localName, nt.name()), enumType);
        }
        return new TypeResolver(parent, localName, declaredMsgs, declaredEnums);
    }

    protected void addEnumType(String name, ProtobufEnum enumType) {
        this._enumTypes.put(name, enumType);
        if (this._parent != null) {
            this._parent.addEnumType(this._scopedName(name), enumType);
        }
    }

    protected static ProtobufEnum constructEnum(EnumElement nativeEnum) {
        LinkedHashMap<String, Integer> valuesByName = new LinkedHashMap<String, Integer>();
        boolean standard = true;
        int exp = 0;
        for (EnumConstantElement v : nativeEnum.constants()) {
            int id = v.tag();
            if (standard && id != exp) {
                standard = false;
            }
            valuesByName.put(v.name(), id);
            ++exp;
        }
        String name = InternCache.instance.intern(nativeEnum.name());
        return new ProtobufEnum(name, valuesByName, standard);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ProtobufMessage _resolve(MessageElement rawType) {
        List rawFields = rawType.fields();
        Object[] resolvedFields = new ProtobufField[rawFields.size()];
        ProtobufMessage message = new ProtobufMessage(rawType.name(), (ProtobufField[])resolvedFields);
        if (this._parent != null) {
            this._parent.addResolvedMessageType(rawType.name(), message);
        }
        int ix = 0;
        for (FieldElement f : rawFields) {
            ProtobufField pbf;
            DataType fieldType = f.type();
            FieldType type = FieldTypes.findType(fieldType);
            if (type != null) {
                pbf = new ProtobufField(f, type);
            } else {
                if (!(fieldType instanceof DataType.NamedType)) throw new IllegalArgumentException(String.format("Unrecognized DataType '%s' for field '%s'", fieldType.getClass().getName(), f.name()));
                String typeStr = ((DataType.NamedType)fieldType).name();
                ProtobufField resolvedF = this._findLocalResolved(f, typeStr);
                if (resolvedF != null) {
                    pbf = resolvedF;
                } else {
                    MessageElement nativeMt = this._declaredMessageTypes.get(typeStr);
                    if (nativeMt != null) {
                        pbf = new ProtobufField(f, this.resolve(this, nativeMt));
                    } else {
                        ProtobufField protobufField = resolvedF = this._parent == null ? null : this._parent._findAnyResolved(f, typeStr);
                        if (resolvedF != null) {
                            pbf = resolvedF;
                        } else {
                            StringBuilder enumStr = this._knownEnums(new StringBuilder());
                            StringBuilder msgStr = this._knownMsgs(new StringBuilder());
                            throw new IllegalArgumentException(String.format("Unknown protobuf field type '%s' for field '%s' of MessageType '%s' (known enum types: %s; known message types: %s)", typeStr, f.name(), rawType.name(), enumStr, msgStr));
                        }
                    }
                }
            }
            resolvedFields[ix++] = pbf;
        }
        ProtobufField first = resolvedFields.length == 0 ? null : resolvedFields[0];
        Arrays.sort(resolvedFields);
        int end = resolvedFields.length - 1;
        for (int i = 0; i < end; ++i) {
            ((ProtobufField)resolvedFields[i]).assignNext((ProtobufField)resolvedFields[i + 1]);
        }
        message.init(first);
        return message;
    }

    protected void addResolvedMessageType(String name, ProtobufMessage toResolve) {
        if (this._resolvedMessageTypes.isEmpty()) {
            this._resolvedMessageTypes = new HashMap<String, ProtobufMessage>();
        }
        this._resolvedMessageTypes.put(name, toResolve);
        if (this._parent != null) {
            this._parent.addResolvedMessageType(this._scopedName(name), toResolve);
        }
    }

    private ProtobufField _findAnyResolved(FieldElement nativeField, String typeStr) {
        TypeResolver r = this;
        while (r != null) {
            ProtobufField f = r._findLocalResolved(nativeField, typeStr);
            if (f != null) {
                return f;
            }
            f = r._findAndResolve(nativeField, typeStr);
            if (f != null) {
                return f;
            }
            r = r._parent;
        }
        return null;
    }

    private ProtobufField _findAndResolve(FieldElement nativeField, String typeStr) {
        MessageElement nativeMt = this._declaredMessageTypes.get(typeStr);
        if (nativeMt != null) {
            return new ProtobufField(nativeField, this.resolve(this, nativeMt));
        }
        return null;
    }

    private StringBuilder _knownEnums(StringBuilder sb) {
        if (this._parent != null) {
            sb = this._parent._knownEnums(sb);
        }
        for (String name : this._enumTypes.keySet()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(name);
        }
        return sb;
    }

    private StringBuilder _knownMsgs(StringBuilder sb) {
        if (this._parent != null) {
            sb = this._parent._knownMsgs(sb);
        }
        for (String name : this._declaredMessageTypes.keySet()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(name);
        }
        return sb;
    }

    private ProtobufField _findLocalResolved(FieldElement nativeField, String typeStr) {
        ProtobufMessage msg = this._resolvedMessageTypes.get(typeStr);
        if (msg != null) {
            return new ProtobufField(nativeField, msg);
        }
        ProtobufEnum et = this._enumTypes.get(typeStr);
        if (et != null) {
            return new ProtobufField(nativeField, et);
        }
        return null;
    }

    private final String _scopedName(String localName) {
        return TypeResolver._scopedName(this._contextName, localName);
    }

    private static final String _scopedName(String contextName, String localName) {
        return contextName + '.' + localName;
    }
}

