/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.protobuf.schemagen;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import tools.jackson.databind.jsonFormatVisitors.JsonBooleanFormatVisitor;
import tools.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import tools.jackson.databind.jsonFormatVisitors.JsonMapFormatVisitor;
import tools.jackson.databind.jsonFormatVisitors.JsonNumberFormatVisitor;
import tools.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import tools.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import tools.jackson.dataformat.protobuf.schema.NativeProtobufSchema;
import tools.jackson.dataformat.protobuf.schema.ProtobufSchema;
import tools.jackson.dataformat.protobuf.schemagen.ProtoBufSchemaVisitor;

public class ProtobufSchemaGenerator
extends ProtoBufSchemaVisitor {
    protected HashSet<JavaType> _generated;
    protected JavaType _rootType;

    public ProtobufSchema getGeneratedSchema() {
        return this.getGeneratedSchema(true);
    }

    public ProtobufSchema getGeneratedSchema(boolean appendDependencies) {
        Collection<Object> types;
        if (this._rootType == null || this._builder == null) {
            throw new IllegalStateException("No visit methods called on " + this.getClass().getName() + ": no schema generated");
        }
        if (appendDependencies) {
            types = this.buildWithDependencies();
        } else {
            types = new LinkedList();
            types.add(this.build());
        }
        return NativeProtobufSchema.construct(this._rootType.getRawClass().getName(), types).forFirstType();
    }

    @Override
    public JsonObjectFormatVisitor expectObjectFormat(JavaType type) {
        this._rootType = type;
        return super.expectObjectFormat(type);
    }

    @Override
    public JsonMapFormatVisitor expectMapFormat(JavaType mapType) {
        return (JsonMapFormatVisitor)this._throwUnsupported("'Map' type not supported as root type by protobuf");
    }

    @Override
    public JsonArrayFormatVisitor expectArrayFormat(JavaType convertedType) {
        return (JsonArrayFormatVisitor)this._throwUnsupported("'Array' type not supported as root type by protobuf");
    }

    @Override
    public JsonStringFormatVisitor expectStringFormat(JavaType type) {
        if (type.isEnumType()) {
            return super.expectStringFormat(type);
        }
        return (JsonStringFormatVisitor)this._throwUnsupported("'String' type not supported as root type by protobuf");
    }

    @Override
    public JsonNumberFormatVisitor expectNumberFormat(JavaType convertedType) {
        return (JsonNumberFormatVisitor)this._throwUnsupported("'Number' type not supported as root type by protobuf");
    }

    @Override
    public JsonIntegerFormatVisitor expectIntegerFormat(JavaType type) {
        return (JsonIntegerFormatVisitor)this._throwUnsupported("'Integer' type not supported as root type by protobuf");
    }

    @Override
    public JsonBooleanFormatVisitor expectBooleanFormat(JavaType convertedType) {
        return (JsonBooleanFormatVisitor)this._throwUnsupported("'Boolean' type not supported as root type by protobuf");
    }
}

