/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.protobuf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.core.Version;
import tools.jackson.core.type.TypeReference;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.cfg.MapperBuilder;
import tools.jackson.databind.cfg.MapperBuilderState;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.dataformat.protobuf.PackageVersion;
import tools.jackson.dataformat.protobuf.ProtobufFactory;
import tools.jackson.dataformat.protobuf.schema.DescriptorLoader;
import tools.jackson.dataformat.protobuf.schema.FileDescriptorSet;
import tools.jackson.dataformat.protobuf.schema.ProtobufSchema;
import tools.jackson.dataformat.protobuf.schema.ProtobufSchemaLoader;
import tools.jackson.dataformat.protobuf.schemagen.ProtobufSchemaGenerator;

public class ProtobufMapper
extends ObjectMapper {
    private static final long serialVersionUID = 3L;
    protected ProtobufSchemaLoader _schemaLoader = ProtobufSchemaLoader.std;
    protected volatile DescriptorLoader _descriptorLoader;
    private final ReentrantLock _descriptorLock = new ReentrantLock();

    public ProtobufMapper() {
        this(new ProtobufFactory());
    }

    public ProtobufMapper(ProtobufFactory f) {
        this(new Builder(f));
    }

    public ProtobufMapper(Builder b) {
        super((MapperBuilder)b);
    }

    public static Builder builder() {
        return new Builder(new ProtobufFactory());
    }

    public static Builder builder(ProtobufFactory streamFactory) {
        return new Builder(streamFactory);
    }

    public Builder rebuild() {
        return new Builder((Builder.StateImpl)this._savedBuilderState);
    }

    public static ProtobufMapper shared() {
        return SharedWrapper.wrapped();
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public ProtobufFactory tokenStreamFactory() {
        return (ProtobufFactory)this._streamFactory;
    }

    public ProtobufSchemaLoader schemaLoader() {
        return this._schemaLoader;
    }

    public void setSchemaLoader(ProtobufSchemaLoader l) {
        this._schemaLoader = l;
    }

    public ProtobufSchema generateSchemaFor(JavaType type) {
        ProtobufSchemaGenerator gen = new ProtobufSchemaGenerator();
        this.acceptJsonFormatVisitor(type, (JsonFormatVisitorWrapper)gen);
        return gen.getGeneratedSchema();
    }

    public ProtobufSchema generateSchemaFor(Class<?> type) {
        ProtobufSchemaGenerator gen = new ProtobufSchemaGenerator();
        this.acceptJsonFormatVisitor(type, (JsonFormatVisitorWrapper)gen);
        return gen.getGeneratedSchema();
    }

    public ProtobufSchema generateSchemaFor(TypeReference<?> type) {
        return this.generateSchemaFor(this._typeFactory.constructType(type));
    }

    public FileDescriptorSet loadDescriptorSet(URL src) throws IOException {
        return this.descriptorLoader().load(Objects.requireNonNull(src));
    }

    public FileDescriptorSet loadDescriptorSet(File src) throws IOException {
        return this.descriptorLoader().load(Objects.requireNonNull(src));
    }

    public FileDescriptorSet loadDescriptorSet(InputStream src) throws IOException {
        return this.descriptorLoader().load(Objects.requireNonNull(src));
    }

    public DescriptorLoader descriptorLoader() throws IOException {
        DescriptorLoader l = this._descriptorLoader;
        if (l == null) {
            this._descriptorLock.lock();
            try {
                l = this._descriptorLoader;
                if (l == null) {
                    this._descriptorLoader = l = DescriptorLoader.construct(this);
                }
            }
            finally {
                this._descriptorLock.unlock();
            }
        }
        return l;
    }

    public static class Builder
    extends MapperBuilder<ProtobufMapper, Builder> {
        public Builder(ProtobufFactory f) {
            super((TokenStreamFactory)f);
        }

        public Builder(StateImpl state) {
            super((MapperBuilderState)state);
        }

        public ProtobufMapper build() {
            return new ProtobufMapper(this);
        }

        protected MapperBuilderState _saveState() {
            return new StateImpl(this);
        }

        protected static class StateImpl
        extends MapperBuilderState
        implements Serializable {
            private static final long serialVersionUID = 3L;

            public StateImpl(Builder src) {
                super((MapperBuilder)src);
            }

            protected Object readResolve() {
                return new Builder(this).build();
            }
        }
    }

    private static final class SharedWrapper {
        private static final ProtobufMapper MAPPER = ProtobufMapper.builder().build();

        private SharedWrapper() {
        }

        public static ProtobufMapper wrapped() {
            return MAPPER;
        }
    }
}

