/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.protobuf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import tools.jackson.core.Base64Variant;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.SerializableString;
import tools.jackson.core.StreamReadCapability;
import tools.jackson.core.StreamReadFeature;
import tools.jackson.core.TokenStreamLocation;
import tools.jackson.core.Version;
import tools.jackson.core.base.ParserMinimalBase;
import tools.jackson.core.exc.StreamReadException;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.io.NumberInput;
import tools.jackson.core.sym.PropertyNameMatcher;
import tools.jackson.core.util.ByteArrayBuilder;
import tools.jackson.core.util.JacksonFeature;
import tools.jackson.core.util.JacksonFeatureSet;
import tools.jackson.core.util.TextBuffer;
import tools.jackson.core.util.VersionUtil;
import tools.jackson.dataformat.protobuf.PackageVersion;
import tools.jackson.dataformat.protobuf.ProtobufReadContext;
import tools.jackson.dataformat.protobuf.ProtobufUtil;
import tools.jackson.dataformat.protobuf.schema.FieldType;
import tools.jackson.dataformat.protobuf.schema.ProtobufField;
import tools.jackson.dataformat.protobuf.schema.ProtobufMessage;
import tools.jackson.dataformat.protobuf.schema.ProtobufSchema;

public class ProtobufParser
extends ParserMinimalBase {
    private static final int STATE_INITIAL = 0;
    private static final int STATE_ROOT_KEY = 1;
    private static final int STATE_ROOT_VALUE = 2;
    private static final int STATE_NESTED_KEY = 3;
    private static final int STATE_NESTED_VALUE = 4;
    private static final int STATE_ARRAY_START = 5;
    private static final int STATE_ARRAY_START_PACKED = 6;
    private static final int STATE_ARRAY_VALUE_FIRST = 7;
    private static final int STATE_ARRAY_VALUE_OTHER = 8;
    private static final int STATE_ARRAY_VALUE_PACKED = 9;
    private static final int STATE_ARRAY_END = 10;
    private static final int STATE_MESSAGE_END = 11;
    private static final int STATE_CLOSED = 12;
    private static final int[] UTF8_UNIT_CODES = ProtobufUtil.sUtf8UnitLengths;
    protected static final JacksonFeatureSet<StreamReadCapability> PROTOBUF_READ_CAPABILITIES = DEFAULT_READ_CAPABILITIES.with((JacksonFeature)StreamReadCapability.EXACT_FLOATS);
    protected ProtobufSchema _schema;
    protected int _inputPtr = 0;
    protected int _inputEnd = 0;
    protected long _currInputProcessed = 0L;
    protected long _tokenInputTotal = 0L;
    protected int _tokenInputRow = 1;
    protected int _tokenInputCol = 0;
    protected ProtobufReadContext _streamReadContext;
    protected final TextBuffer _textBuffer;
    protected char[] _nameCopyBuffer = null;
    protected boolean _nameCopied = false;
    protected ByteArrayBuilder _byteArrayBuilder = null;
    protected byte[] _binaryValue;
    protected InputStream _inputStream;
    protected byte[] _inputBuffer;
    protected boolean _bufferRecyclable;
    protected ProtobufMessage _currentMessage;
    protected ProtobufField _currentField;
    protected boolean _tokenIncomplete = false;
    protected int _state = 0;
    protected int _nextTag;
    protected int _decodedLength;
    protected int _currentEndOffset = Integer.MAX_VALUE;
    protected int _numTypesValid = 0;
    protected int _numberInt;
    protected float _numberFloat;
    protected long _numberLong;
    protected double _numberDouble;
    protected BigInteger _numberBigInt;
    protected BigDecimal _numberBigDecimal;

    public ProtobufParser(ObjectReadContext readCtxt, IOContext ioCtxt, int parserFeatures, ProtobufSchema schema, InputStream in, byte[] inputBuffer, int start, int end, boolean bufferRecyclable) {
        super(readCtxt, ioCtxt, parserFeatures);
        this._inputStream = in;
        this._inputBuffer = inputBuffer;
        this._inputPtr = start;
        this._inputEnd = end;
        this._bufferRecyclable = bufferRecyclable;
        this._textBuffer = ioCtxt.constructReadConstrainedTextBuffer();
        this._streamReadContext = ProtobufReadContext.createRootContext();
        this._tokenInputRow = -1;
        this._tokenInputCol = -1;
        this.setSchema(schema);
    }

    public void setSchema(ProtobufSchema schema) {
        if (this._schema == schema) {
            return;
        }
        if (this._state != 0) {
            throw new IllegalStateException("Can not change Schema after parsing has started");
        }
        this._schema = schema;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public JacksonFeatureSet<StreamReadCapability> streamReadCapabilities() {
        return PROTOBUF_READ_CAPABILITIES;
    }

    public void close() {
        super.close();
        this._state = 12;
        if (!this._streamReadContext.inRoot()) {
            this._streamReadContext = this._streamReadContext.getParent();
        }
        this._streamReadContext.setCurrentName(null);
    }

    public int releaseBuffered(OutputStream out) {
        int count = this._inputEnd - this._inputPtr;
        if (count < 1) {
            return 0;
        }
        int origPtr = this._inputPtr;
        try {
            out.write(this._inputBuffer, origPtr, count);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return count;
    }

    protected void _closeInput() throws JacksonException {
        if (this._inputStream != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(StreamReadFeature.AUTO_CLOSE_SOURCE)) {
                try {
                    this._inputStream.close();
                }
                catch (IOException e) {
                    throw this._wrapIOFailure(e);
                }
            }
            this._inputStream = null;
        }
    }

    public Object streamReadInputSource() {
        return this._inputStream;
    }

    public TokenStreamLocation currentTokenLocation() {
        return new TokenStreamLocation(this._ioContext.contentReference(), this._tokenInputTotal, -1L, -1, (int)this._tokenInputTotal);
    }

    public TokenStreamLocation currentLocation() {
        long offset = this._currInputProcessed + (long)this._inputPtr;
        return new TokenStreamLocation(this._ioContext.contentReference(), offset, -1L, -1, (int)offset);
    }

    public String currentName() {
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            ProtobufReadContext parent = this._streamReadContext.getParent();
            if (parent == null) {
                return null;
            }
            return parent.currentName();
        }
        return this._streamReadContext.currentName();
    }

    public ProtobufReadContext streamReadContext() {
        return this._streamReadContext;
    }

    public void assignCurrentValue(Object v) {
        this._streamReadContext.assignCurrentValue(v);
    }

    public Object currentValue() {
        return this._streamReadContext.currentValue();
    }

    public ProtobufSchema getSchema() {
        return this._schema;
    }

    public boolean hasStringCharacters() {
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this._textBuffer.hasTextAsCharacters();
        }
        if (this._currToken == JsonToken.PROPERTY_NAME) {
            return this._nameCopied;
        }
        return false;
    }

    protected void _releaseBuffers() {
        Object[] buf;
        if (this._bufferRecyclable && (buf = this._inputBuffer) != null) {
            this._inputBuffer = null;
            this._ioContext.releaseReadIOBuffer(buf);
        }
        this._textBuffer.releaseBuffers();
        buf = this._nameCopyBuffer;
        if (buf != null) {
            this._nameCopyBuffer = null;
            this._ioContext.releaseNameCopyBuffer((char[])buf);
        }
    }

    public JsonToken nextToken() throws JacksonException {
        this._numTypesValid = 0;
        if (this._tokenIncomplete) {
            this._tokenIncomplete = false;
            this._skipBytes(this._decodedLength);
        }
        this._tokenInputTotal = this._currInputProcessed + (long)this._inputPtr;
        this._binaryValue = null;
        switch (this._state) {
            case 0: {
                if (this._schema == null) {
                    this._reportError("No Schema has been assigned: can not decode content");
                    return null;
                }
                this._currentMessage = this._schema.getRootType();
                this._currentField = this._currentMessage.firstField();
                this._state = 1;
                this._streamReadContext.setMessageType(this._currentMessage);
                return this._updateToken(JsonToken.START_OBJECT);
            }
            case 1: {
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                    this.close();
                    return this._updateToken(JsonToken.END_OBJECT);
                }
                return this._handleRootKey(this._decodeVInt());
            }
            case 2: {
                return this._updateToken(this._readNextValue(this._currentField.type, 1));
            }
            case 3: {
                if (this._checkEnd()) {
                    return this._updateToken(JsonToken.END_OBJECT);
                }
                return this._handleNestedKey(this._decodeVInt());
            }
            case 5: {
                this._streamReadContext = this._streamReadContext.createChildArrayContext(this._currentField);
                this.streamReadConstraints().validateNestingDepth(this._streamReadContext.getNestingDepth());
                this._state = 7;
                return this._updateToken(JsonToken.START_ARRAY);
            }
            case 6: {
                int len = this._decodeLength();
                int newEnd = this._inputPtr + len;
                if (!this._streamReadContext.inRoot() && newEnd > this._currentEndOffset) {
                    this._reportErrorF("Packed array for field '%s' (of type %s) extends past end of enclosing message: %d > %d (length: %d)", this._currentField.name, this._currentMessage.getName(), newEnd, this._currentEndOffset, len);
                }
                this._currentEndOffset = newEnd;
                this._streamReadContext = this._streamReadContext.createChildArrayContext(this._currentField, newEnd);
                this.streamReadConstraints().validateNestingDepth(this._streamReadContext.getNestingDepth());
                this._state = 9;
                return this._updateToken(JsonToken.START_ARRAY);
            }
            case 7: {
                return this._updateToken(this._readNextValue(this._currentField.type, 8));
            }
            case 8: {
                ProtobufReadContext parent;
                if (this._checkEnd()) {
                    return this._updateToken(JsonToken.END_ARRAY);
                }
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                    ProtobufReadContext parent2 = this._streamReadContext.getParent();
                    if (!parent2.inRoot()) {
                        this._reportInvalidEOF();
                    }
                    this._streamReadContext = parent2;
                    this._currentField = parent2.getField();
                    this._state = 11;
                    return this._updateToken(JsonToken.END_ARRAY);
                }
                int tag = this._decodeVInt();
                if (this._currentField.id == tag >> 3) {
                    return this._updateToken(this._readNextValue(this._currentField.type, 8));
                }
                this._nextTag = tag;
                this._streamReadContext = parent = this._streamReadContext.getParent();
                this._currentField = parent.getField();
                this._state = 10;
                return this._updateToken(JsonToken.END_ARRAY);
            }
            case 9: {
                if (this._checkEnd()) {
                    return this._updateToken(JsonToken.END_ARRAY);
                }
                return this._updateToken(this._readNextValue(this._currentField.type, 9));
            }
            case 10: {
                if (this._streamReadContext.inRoot()) {
                    return this._handleRootKey(this._nextTag);
                }
                return this._handleNestedKey(this._nextTag);
            }
            case 4: {
                return this._updateToken(this._readNextValue(this._currentField.type, 3));
            }
            case 11: {
                this.close();
                return this._updateToken(JsonToken.END_OBJECT);
            }
            case 12: {
                return null;
            }
        }
        VersionUtil.throwInternal();
        return null;
    }

    private boolean _checkEnd() throws JacksonException {
        ProtobufReadContext parentCtxt;
        if (this._inputPtr < this._currentEndOffset) {
            return false;
        }
        if (this._inputPtr > this._currentEndOffset) {
            this._reportErrorF("Decoding: current inputPtr (%d) exceeds end offset (%d) (for message of type %s): corrupt content?", this._inputPtr, this._currentEndOffset, this._currentMessage.getName());
        }
        this._streamReadContext = parentCtxt = this._streamReadContext.getParent();
        this._currentMessage = parentCtxt.getMessageType();
        this._currentEndOffset = parentCtxt.getEndOffset();
        this._currentField = parentCtxt.getField();
        this._state = this._streamReadContext.inRoot() ? 1 : (this._streamReadContext.inArray() ? (this._currentField.packed ? 9 : 8) : 3);
        return true;
    }

    private JsonToken _handleRootKey(int tag) throws JacksonException {
        ProtobufField f;
        int wireType = tag & 7;
        int id = tag >> 3;
        if (this._currentField != null ? (f = this._currentField.nextOrThisIf(id)) == null && (f = this._currentMessage.field(id)) == null : (f = this._currentMessage.field(id)) == null) {
            return this._skipUnknownField(id, wireType);
        }
        this._streamReadContext.setCurrentName(f.name);
        if (!f.isValidFor(wireType)) {
            this._reportIncompatibleType(f, wireType);
        }
        this._state = f.repeated ? (f.packed ? 6 : 5) : 2;
        this._currentField = f;
        return this._updateToken(JsonToken.PROPERTY_NAME);
    }

    private JsonToken _handleNestedKey(int tag) throws JacksonException {
        ProtobufField f;
        int wireType = tag & 7;
        int id = tag >> 3;
        if (this._currentField != null ? (f = this._currentField.nextOrThisIf(id)) == null && (f = this._currentMessage.field(id)) == null : (f = this._currentMessage.field(id)) == null) {
            return this._skipUnknownField(id, wireType);
        }
        if (this._currentField == null || (f = this._currentField.nextOrThisIf(id)) == null) {
            f = this._currentMessage.field(id);
        }
        if (f == null) {
            return this._skipUnknownField(id, wireType);
        }
        this._streamReadContext.setCurrentName(f.name);
        if (!f.isValidFor(wireType)) {
            this._reportIncompatibleType(f, wireType);
        }
        this._state = f.repeated ? (f.packed ? 6 : 5) : 4;
        this._currentField = f;
        return this._updateToken(JsonToken.PROPERTY_NAME);
    }

    private JsonToken _readNextValue(FieldType t, int nextState) throws JacksonException {
        JsonToken type;
        switch (this._currentField.type) {
            case DOUBLE: {
                this._numberDouble = Double.longBitsToDouble(this._decode64Bits());
                this._numTypesValid = 8;
                type = JsonToken.VALUE_NUMBER_FLOAT;
                break;
            }
            case FLOAT: {
                this._numberFloat = Float.intBitsToFloat(this._decode32Bits());
                this._numTypesValid = 32;
                type = JsonToken.VALUE_NUMBER_FLOAT;
                break;
            }
            case VINT32_Z: {
                this._numberInt = ProtobufUtil.zigzagDecode(this._decodeVInt());
                this._numTypesValid = 1;
                type = JsonToken.VALUE_NUMBER_INT;
                break;
            }
            case VINT64_Z: {
                this._numberLong = ProtobufUtil.zigzagDecode(this._decodeVLong());
                this._numTypesValid = 2;
                type = JsonToken.VALUE_NUMBER_INT;
                break;
            }
            case VINT32_STD: {
                this._numberInt = this._decodeVInt();
                this._numTypesValid = 1;
                type = JsonToken.VALUE_NUMBER_INT;
                break;
            }
            case VINT64_STD: {
                this._numberLong = this._decodeVLong();
                this._numTypesValid = 2;
                type = JsonToken.VALUE_NUMBER_INT;
                break;
            }
            case FIXINT32: {
                this._numberInt = this._decode32Bits();
                this._numTypesValid = 1;
                type = JsonToken.VALUE_NUMBER_INT;
                break;
            }
            case FIXINT64: {
                this._numberLong = this._decode64Bits();
                this._numTypesValid = 2;
                type = JsonToken.VALUE_NUMBER_INT;
                break;
            }
            case BOOLEAN: {
                byte i;
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((i = this._inputBuffer[this._inputPtr++]) == 1) {
                    type = JsonToken.VALUE_TRUE;
                    break;
                }
                if (i == 0) {
                    type = JsonToken.VALUE_FALSE;
                    break;
                }
                this._reportError(String.format("Invalid byte value for bool field %s: 0x%2x; should be either 0x0 or 0x1", this._currentField.name, (int)i));
                type = null;
                break;
            }
            case STRING: {
                int len;
                this._decodedLength = len = this._decodeLength();
                if (len == 0) {
                    this._textBuffer.resetWithEmpty();
                } else {
                    this._tokenIncomplete = true;
                }
                type = JsonToken.VALUE_STRING;
                break;
            }
            case BYTES: {
                int len;
                this._decodedLength = len = this._decodeLength();
                if (len == 0) {
                    this._binaryValue = ByteArrayBuilder.NO_BYTES;
                } else {
                    this._tokenIncomplete = true;
                }
                type = JsonToken.VALUE_EMBEDDED_OBJECT;
                break;
            }
            case ENUM: {
                int ix = this._decodeLength();
                if (this._currentField.isStdEnum) {
                    this._numberInt = ix;
                    this._numTypesValid = 1;
                    type = JsonToken.VALUE_NUMBER_INT;
                    break;
                }
                String enumStr = this._currentField.findEnumByIndex(ix);
                if (enumStr == null) {
                    this._reportErrorF("Unknown id %d (for enum field %s)", ix, this._currentField.name);
                }
                type = JsonToken.VALUE_STRING;
                this._textBuffer.resetWithString(enumStr);
                break;
            }
            case MESSAGE: {
                ProtobufMessage msg;
                this._currentMessage = msg = this._currentField.getMessageType();
                int len = this._decodeLength();
                int newEnd = this._inputPtr + len;
                if (newEnd > this._currentEndOffset) {
                    this._reportErrorF("Message for field '%s' (of type %s) extends past end of enclosing message: %d > %d (length: %d)", this._currentField.name, msg.getName(), newEnd, this._currentEndOffset, len);
                }
                this._currentEndOffset = newEnd;
                this._state = 3;
                this._streamReadContext = this._streamReadContext.createChildObjectContext(msg, this._currentField, newEnd);
                this.streamReadConstraints().validateNestingDepth(this._streamReadContext.getNestingDepth());
                this._currentField = msg.firstField();
                return JsonToken.START_OBJECT;
            }
            default: {
                throw new UnsupportedOperationException("Type " + String.valueOf((Object)this._currentField.type) + " not yet supported");
            }
        }
        this._state = nextState;
        return type;
    }

    private JsonToken _skipUnknownField(int tag, int wireType) throws JacksonException {
        if (!this.isEnabled(StreamReadFeature.IGNORE_UNDEFINED)) {
            this._reportErrorF("Undefined property (id %d, wire type %d) for message type %s: not allowed to ignore, as `JsonParser.Feature.IGNORE_UNDEFINED` disabled", tag, wireType, this._currentMessage.getName());
        }
        do {
            this._skipUnknownValue(wireType);
            if (this._checkEnd()) {
                return this._updateToken(JsonToken.END_OBJECT);
            }
            if (this._state == 3) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
            } else if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this.close();
                return this._updateToken(JsonToken.END_OBJECT);
            }
            tag = this._decodeVInt();
            wireType = tag & 7;
            this._currentField = this._currentMessage.field(tag >> 3);
        } while (this._currentField == null);
        this._streamReadContext.setCurrentName(this._currentField.name);
        this._state = 2;
        if (!this._currentField.isValidFor(wireType)) {
            this._reportIncompatibleType(this._currentField, wireType);
        }
        return this._updateToken(JsonToken.PROPERTY_NAME);
    }

    private void _skipUnknownValue(int wireType) throws JacksonException {
        switch (wireType) {
            case 0: {
                this._skipVInt();
                break;
            }
            case 5: {
                this._skipBytes(4);
                break;
            }
            case 1: {
                this._skipBytes(8);
                break;
            }
            case 2: {
                int len = this._decodeLength();
                this._skipBytes(len);
                break;
            }
            default: {
                this._reportError(String.format("Unrecognized wire type 0x%x for unknown field within message of type %s)", wireType, this._currentMessage.getName()));
            }
        }
    }

    public String nextName() throws JacksonException {
        if (this._state == 1) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this.close();
                this._updateToken(JsonToken.END_OBJECT);
                return null;
            }
            int tag = this._decodeVInt();
            int wireType = tag & 7;
            int id = tag >> 3;
            ProtobufField f = this._findField(id);
            if (f == null && this._skipUnknownField(id, wireType) != JsonToken.PROPERTY_NAME) {
                return null;
            }
            String name = this._currentField.name;
            this._streamReadContext.setCurrentName(name);
            if (!this._currentField.isValidFor(wireType)) {
                this._reportIncompatibleType(this._currentField, wireType);
            }
            this._state = this._currentField.repeated ? (this._currentField.packed ? 6 : 5) : 2;
            this._updateToken(JsonToken.PROPERTY_NAME);
            return name;
        }
        if (this._state == 3) {
            if (this._checkEnd()) {
                this._updateToken(JsonToken.END_OBJECT);
                return null;
            }
            int tag = this._decodeVInt();
            int wireType = tag & 7;
            int id = tag >> 3;
            ProtobufField f = this._findField(id);
            if (f == null && this._skipUnknownField(id, wireType) != JsonToken.PROPERTY_NAME) {
                return null;
            }
            String name = this._currentField.name;
            this._streamReadContext.setCurrentName(name);
            if (!this._currentField.isValidFor(wireType)) {
                this._reportIncompatibleType(this._currentField, wireType);
            }
            this._state = this._currentField.repeated ? (this._currentField.packed ? 6 : 5) : 4;
            this._updateToken(JsonToken.PROPERTY_NAME);
            return name;
        }
        if (this._state == 11) {
            this.close();
            this._updateToken(JsonToken.END_OBJECT);
            return null;
        }
        return this.nextToken() == JsonToken.PROPERTY_NAME ? this.currentName() : null;
    }

    public boolean nextName(SerializableString sstr) throws JacksonException {
        if (this._state == 1) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this.close();
                this._updateToken(JsonToken.END_OBJECT);
                return false;
            }
            int tag = this._decodeVInt();
            int wireType = tag & 7;
            int id = tag >> 3;
            ProtobufField f = this._findField(id);
            if (f == null) {
                this._skipUnknownField(id, wireType);
                return false;
            }
            String name = this._currentField.name;
            this._streamReadContext.setCurrentName(name);
            if (!this._currentField.isValidFor(wireType)) {
                this._reportIncompatibleType(this._currentField, wireType);
            }
            this._state = this._currentField.repeated ? (this._currentField.packed ? 6 : 5) : 2;
            this._updateToken(JsonToken.PROPERTY_NAME);
            return name.equals(sstr.getValue());
        }
        if (this._state == 3) {
            if (this._checkEnd()) {
                this._updateToken(JsonToken.END_OBJECT);
                return false;
            }
            int tag = this._decodeVInt();
            int wireType = tag & 7;
            int id = tag >> 3;
            ProtobufField f = this._findField(id);
            if (f == null) {
                this._skipUnknownField(id, wireType);
                return false;
            }
            String name = this._currentField.name;
            this._streamReadContext.setCurrentName(name);
            if (!this._currentField.isValidFor(wireType)) {
                this._reportIncompatibleType(this._currentField, wireType);
            }
            this._state = this._currentField.repeated ? (this._currentField.packed ? 6 : 5) : 4;
            this._updateToken(JsonToken.PROPERTY_NAME);
            return name.equals(sstr.getValue());
        }
        if (this._state == 11) {
            this.close();
            this._updateToken(JsonToken.END_OBJECT);
            return false;
        }
        return this.nextToken() == JsonToken.PROPERTY_NAME && sstr.getValue().equals(this.currentName());
    }

    public int nextNameMatch(PropertyNameMatcher matcher) throws JacksonException {
        if (this._state == 1) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this.close();
                this._updateToken(JsonToken.END_OBJECT);
                return -1;
            }
            int tag = this._decodeVInt();
            int wireType = tag & 7;
            int id = tag >> 3;
            ProtobufField f = this._findField(id);
            if (f == null) {
                JsonToken t = this._skipUnknownField(id, wireType);
                if (t != JsonToken.PROPERTY_NAME) {
                    return t == JsonToken.END_OBJECT ? -1 : -3;
                }
                wireType = this._currentField.wireType;
            }
            String name = this._currentField.name;
            this._streamReadContext.setCurrentName(name);
            if (!this._currentField.isValidFor(wireType)) {
                this._reportIncompatibleType(this._currentField, wireType);
            }
            this._state = this._currentField.repeated ? (this._currentField.packed ? 6 : 5) : 2;
            this._updateToken(JsonToken.PROPERTY_NAME);
            return matcher.matchName(name);
        }
        if (this._state == 3) {
            if (this._checkEnd()) {
                this._updateToken(JsonToken.END_OBJECT);
                return -1;
            }
            int tag = this._decodeVInt();
            int wireType = tag & 7;
            int id = tag >> 3;
            ProtobufField f = this._findField(id);
            if (f == null) {
                JsonToken t = this._skipUnknownField(id, wireType);
                if (t != JsonToken.PROPERTY_NAME) {
                    return t == JsonToken.END_OBJECT ? -1 : -3;
                }
                wireType = this._currentField.wireType;
            }
            String name = this._currentField.name;
            this._streamReadContext.setCurrentName(name);
            if (!this._currentField.isValidFor(wireType)) {
                this._reportIncompatibleType(this._currentField, wireType);
            }
            this._state = this._currentField.repeated ? (this._currentField.packed ? 6 : 5) : 4;
            this._updateToken(JsonToken.PROPERTY_NAME);
            return matcher.matchName(name);
        }
        if (this._state == 11) {
            this.close();
            this._updateToken(JsonToken.END_OBJECT);
            return -1;
        }
        return this._nextNameMatch2(matcher);
    }

    private int _nextNameMatch2(PropertyNameMatcher matcher) throws JacksonException {
        JsonToken t = this.nextToken();
        if (t == JsonToken.PROPERTY_NAME) {
            return matcher.matchName(this.currentName());
        }
        if (t == JsonToken.END_OBJECT) {
            return -1;
        }
        return -3;
    }

    public String nextStringValue() throws JacksonException {
        int len;
        this._numTypesValid = 0;
        if (this._tokenIncomplete) {
            this._tokenIncomplete = false;
            this._skipBytes(this._decodedLength);
        }
        this._tokenInputTotal = this._currInputProcessed + (long)this._inputPtr;
        this._binaryValue = null;
        switch (this._state) {
            case 2: {
                JsonToken t = this._updateToken(this._readNextValue(this._currentField.type, 1));
                return t == JsonToken.VALUE_STRING ? this.getString() : null;
            }
            case 4: {
                JsonToken t = this._updateToken(this._readNextValue(this._currentField.type, 3));
                return t == JsonToken.VALUE_STRING ? this.getString() : null;
            }
            case 7: {
                if (this._currentField.type == FieldType.STRING) {
                    this._state = 8;
                    break;
                }
                this._updateToken(this._readNextValue(this._currentField.type, 8));
                return null;
            }
            case 8: {
                ProtobufReadContext parent;
                if (this._checkEnd()) {
                    this._updateToken(JsonToken.END_ARRAY);
                    return null;
                }
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                    ProtobufReadContext parent2 = this._streamReadContext.getParent();
                    if (!parent2.inRoot()) {
                        this._reportInvalidEOF();
                    }
                    this._streamReadContext = parent2;
                    this._currentField = parent2.getField();
                    this._state = 11;
                    this._updateToken(JsonToken.END_ARRAY);
                    return null;
                }
                int tag = this._decodeVInt();
                if (this._currentField.id == tag >> 3) {
                    if (this._currentField.type == FieldType.STRING) break;
                    this._updateToken(this._readNextValue(this._currentField.type, 8));
                    return null;
                }
                this._nextTag = tag;
                this._streamReadContext = parent = this._streamReadContext.getParent();
                this._currentField = parent.getField();
                this._state = 10;
                this._updateToken(JsonToken.END_ARRAY);
                return null;
            }
            case 9: {
                if (this._checkEnd()) {
                    this._updateToken(JsonToken.END_ARRAY);
                    return null;
                }
                if (this._currentField.type == FieldType.STRING) break;
                this._updateToken(this._readNextValue(this._currentField.type, 9));
                return null;
            }
            default: {
                return this.nextToken() == JsonToken.VALUE_STRING ? this.getString() : null;
            }
        }
        this._decodedLength = len = this._decodeLength();
        this._updateToken(JsonToken.VALUE_STRING);
        if (len == 0) {
            this._textBuffer.resetWithEmpty();
            return "";
        }
        if (this._inputPtr + len <= this._inputEnd) {
            return this._finishShortText(len);
        }
        this._finishToken();
        return this._textBuffer.contentsAsString();
    }

    private final ProtobufField _findField(int id) {
        ProtobufField f;
        if (this._currentField == null || (f = this._currentField.nextOrThisIf(id)) == null) {
            f = this._currentMessage.field(id);
        }
        this._currentField = f;
        return f;
    }

    public String getString() throws JacksonException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                int len = this._decodedLength;
                if (this._inputPtr + len <= this._inputEnd) {
                    this._tokenIncomplete = false;
                    return this._finishShortText(len);
                }
                this._finishToken();
            }
            return this._textBuffer.contentsAsString();
        }
        JsonToken t = this._currToken;
        if (t == null) {
            return null;
        }
        if (t == JsonToken.PROPERTY_NAME) {
            return this._streamReadContext.currentName();
        }
        if (t.isNumeric()) {
            return this.getNumberValue().toString();
        }
        return this._currToken.asString();
    }

    public char[] getStringCharacters() throws JacksonException {
        if (this._currToken != null) {
            if (this._tokenIncomplete) {
                this._finishToken();
            }
            switch (this._currToken) {
                case VALUE_STRING: {
                    return this._textBuffer.getTextBuffer();
                }
                case PROPERTY_NAME: {
                    return this._streamReadContext.currentName().toCharArray();
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this.getNumberValue().toString().toCharArray();
                }
            }
            return this._currToken.asCharArray();
        }
        return null;
    }

    public int getStringLength() throws JacksonException {
        if (this._currToken != null) {
            if (this._tokenIncomplete) {
                this._finishToken();
            }
            switch (this._currToken) {
                case VALUE_STRING: {
                    return this._textBuffer.size();
                }
                case PROPERTY_NAME: {
                    return this._streamReadContext.currentName().length();
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this.getNumberValue().toString().length();
                }
            }
            char[] ch = this._currToken.asCharArray();
            if (ch != null) {
                return ch.length;
            }
        }
        return 0;
    }

    public int getStringOffset() throws JacksonException {
        return 0;
    }

    public String getValueAsString() throws JacksonException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                int len = this._decodedLength;
                if (this._inputPtr + len <= this._inputEnd) {
                    this._tokenIncomplete = false;
                    return this._finishShortText(len);
                }
                this._finishToken();
            }
            return this._textBuffer.contentsAsString();
        }
        if (this._currToken == JsonToken.PROPERTY_NAME) {
            return this.currentName();
        }
        if (this._currToken == null || this._currToken == JsonToken.VALUE_NULL || !this._currToken.isScalarValue()) {
            return null;
        }
        return this.getString();
    }

    public String getValueAsString(String defaultValue) throws JacksonException {
        if (this._currToken != JsonToken.VALUE_STRING) {
            if (this._currToken == JsonToken.PROPERTY_NAME) {
                return this.currentName();
            }
            if (this._currToken == null || this._currToken == JsonToken.VALUE_NULL || !this._currToken.isScalarValue()) {
                return defaultValue;
            }
        }
        return this.getString();
    }

    public int getString(Writer writer) throws JacksonException {
        try {
            JsonToken t = this._currToken;
            if (t == JsonToken.VALUE_STRING) {
                if (this._tokenIncomplete) {
                    int len = this._decodedLength;
                    if (this._inputPtr + len <= this._inputEnd) {
                        this._tokenIncomplete = false;
                        this._finishShortText(len);
                    } else {
                        this._finishToken();
                    }
                }
                return this._textBuffer.contentsToWriter(writer);
            }
            if (t == JsonToken.PROPERTY_NAME) {
                String n = this._streamReadContext.currentName();
                writer.write(n);
                return n.length();
            }
            if (t != null) {
                if (t.isNumeric()) {
                    return this._textBuffer.contentsToWriter(writer);
                }
                char[] ch = t.asCharArray();
                writer.write(ch);
                return ch.length;
            }
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return 0;
    }

    public byte[] getBinaryValue(Base64Variant b64variant) throws JacksonException {
        if (this._tokenIncomplete) {
            this._finishToken();
        }
        if (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT) {
            this._reportError("Current token (" + String.valueOf(this._currToken) + ") not VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        return this._binaryValue;
    }

    public Object getEmbeddedObject() throws JacksonException {
        if (this._tokenIncomplete) {
            this._finishToken();
        }
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            return this._binaryValue;
        }
        return null;
    }

    public int readBinaryValue(Base64Variant b64variant, OutputStream out) throws JacksonException {
        if (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT) {
            this._reportError("Current token (" + String.valueOf(this._currToken) + ") not VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        return -1;
    }

    public boolean isNaN() {
        if (this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
            if ((this._numTypesValid & 8) != 0) {
                return !Double.isFinite(this._numberDouble);
            }
            if ((this._numTypesValid & 0x20) != 0) {
                return !Float.isFinite(this._numberFloat);
            }
        }
        return false;
    }

    public Number getNumberValue() throws JacksonException {
        if (this._numTypesValid == 0) {
            this._checkNumericValue(0);
        }
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            if ((this._numTypesValid & 1) != 0) {
                return this._numberInt;
            }
            if ((this._numTypesValid & 2) != 0) {
                return this._numberLong;
            }
            if ((this._numTypesValid & 4) != 0) {
                return this._numberBigInt;
            }
            return this._numberBigDecimal;
        }
        if ((this._numTypesValid & 0x10) != 0) {
            return this._numberBigDecimal;
        }
        if ((this._numTypesValid & 8) != 0) {
            return this._numberDouble;
        }
        if ((this._numTypesValid & 0x20) == 0) {
            this._throwInternal();
        }
        return Float.valueOf(this._numberFloat);
    }

    public final Number getNumberValueExact() throws JacksonException {
        return this.getNumberValue();
    }

    public JsonParser.NumberType getNumberType() throws JacksonException {
        if (this._numTypesValid == 0) {
            this._checkNumericValue(0);
        }
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            if ((this._numTypesValid & 2) != 0) {
                return JsonParser.NumberType.LONG;
            }
            if ((this._numTypesValid & 1) != 0) {
                return JsonParser.NumberType.INT;
            }
            return JsonParser.NumberType.BIG_INTEGER;
        }
        if ((this._numTypesValid & 0x10) != 0) {
            return JsonParser.NumberType.BIG_DECIMAL;
        }
        if ((this._numTypesValid & 8) != 0) {
            return JsonParser.NumberType.DOUBLE;
        }
        return JsonParser.NumberType.FLOAT;
    }

    public JsonParser.NumberTypeFP getNumberTypeFP() throws JacksonException {
        if (this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
            if ((this._numTypesValid & 0x10) != 0) {
                return JsonParser.NumberTypeFP.BIG_DECIMAL;
            }
            if ((this._numTypesValid & 8) != 0) {
                return JsonParser.NumberTypeFP.DOUBLE64;
            }
            if ((this._numTypesValid & 0x20) != 0) {
                return JsonParser.NumberTypeFP.FLOAT32;
            }
        }
        return JsonParser.NumberTypeFP.UNKNOWN;
    }

    public int getIntValue() throws JacksonException {
        if ((this._numTypesValid & 1) == 0) {
            if (this._numTypesValid == 0) {
                this._checkNumericValue(1);
            }
            if ((this._numTypesValid & 1) == 0) {
                this.convertNumberToInt();
            }
        }
        return this._numberInt;
    }

    public long getLongValue() throws JacksonException {
        if ((this._numTypesValid & 2) == 0) {
            if (this._numTypesValid == 0) {
                this._checkNumericValue(2);
            }
            if ((this._numTypesValid & 2) == 0) {
                this.convertNumberToLong();
            }
        }
        return this._numberLong;
    }

    public BigInteger getBigIntegerValue() throws JacksonException {
        if ((this._numTypesValid & 4) == 0) {
            if (this._numTypesValid == 0) {
                this._checkNumericValue(4);
            }
            if ((this._numTypesValid & 4) == 0) {
                this.convertNumberToBigInteger();
            }
        }
        return this._numberBigInt;
    }

    public float getFloatValue() throws JacksonException {
        if ((this._numTypesValid & 0x20) == 0) {
            if (this._numTypesValid == 0) {
                this._checkNumericValue(32);
            }
            if ((this._numTypesValid & 0x20) == 0) {
                this.convertNumberToFloat();
            }
        }
        return this._numberFloat;
    }

    public double getDoubleValue() throws JacksonException {
        if ((this._numTypesValid & 8) == 0) {
            if (this._numTypesValid == 0) {
                this._checkNumericValue(8);
            }
            if ((this._numTypesValid & 8) == 0) {
                this.convertNumberToDouble();
            }
        }
        return this._numberDouble;
    }

    public BigDecimal getDecimalValue() throws JacksonException {
        if ((this._numTypesValid & 0x10) == 0) {
            if (this._numTypesValid == 0) {
                this._checkNumericValue(16);
            }
            if ((this._numTypesValid & 0x10) == 0) {
                this.convertNumberToBigDecimal();
            }
        }
        return this._numberBigDecimal;
    }

    protected void _checkNumericValue(int expType) throws JacksonException {
        if (this._currToken == JsonToken.VALUE_NUMBER_INT || this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return;
        }
        this._reportError("Current token (" + String.valueOf(this._currToken) + ") not numeric, can not use numeric value accessors");
    }

    protected void convertNumberToInt() throws JacksonException {
        if ((this._numTypesValid & 2) != 0) {
            int result = (int)this._numberLong;
            if ((long)result != this._numberLong) {
                this._reportError("Numeric value (" + this.getString() + ") out of range of int");
            }
            this._numberInt = result;
        } else if ((this._numTypesValid & 4) != 0) {
            if (BI_MIN_INT.compareTo(this._numberBigInt) > 0 || BI_MAX_INT.compareTo(this._numberBigInt) < 0) {
                this._reportOverflowInt();
            }
            this._numberInt = this._numberBigInt.intValue();
        } else if ((this._numTypesValid & 8) != 0) {
            if (this._numberDouble < -2.147483648E9 || this._numberDouble > 2.147483647E9) {
                this._reportOverflowInt();
            }
            this._numberInt = (int)this._numberDouble;
        } else if ((this._numTypesValid & 0x20) != 0) {
            if ((double)this._numberFloat < -2.147483648E9 || (double)this._numberFloat > 2.147483647E9) {
                this._reportOverflowInt();
            }
            this._numberInt = (int)this._numberFloat;
        } else if ((this._numTypesValid & 0x10) != 0) {
            if (BD_MIN_INT.compareTo(this._numberBigDecimal) > 0 || BD_MAX_INT.compareTo(this._numberBigDecimal) < 0) {
                this._reportOverflowInt();
            }
            this._numberInt = this._numberBigDecimal.intValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 1;
    }

    protected void convertNumberToLong() throws JacksonException {
        if ((this._numTypesValid & 1) != 0) {
            this._numberLong = this._numberInt;
        } else if ((this._numTypesValid & 4) != 0) {
            if (BI_MIN_LONG.compareTo(this._numberBigInt) > 0 || BI_MAX_LONG.compareTo(this._numberBigInt) < 0) {
                this._reportOverflowLong();
            }
            this._numberLong = this._numberBigInt.longValue();
        } else if ((this._numTypesValid & 8) != 0) {
            if (this._numberDouble < -9.223372036854776E18 || this._numberDouble > 9.223372036854776E18) {
                this._reportOverflowLong();
            }
            this._numberLong = (long)this._numberDouble;
        } else if ((this._numTypesValid & 0x20) != 0) {
            if ((double)this._numberFloat < -9.223372036854776E18 || (double)this._numberFloat > 9.223372036854776E18) {
                this._reportOverflowInt();
            }
            this._numberLong = (long)this._numberFloat;
        } else if ((this._numTypesValid & 0x10) != 0) {
            if (BD_MIN_LONG.compareTo(this._numberBigDecimal) > 0 || BD_MAX_LONG.compareTo(this._numberBigDecimal) < 0) {
                this._reportOverflowLong();
            }
            this._numberLong = this._numberBigDecimal.longValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 2;
    }

    protected void convertNumberToBigInteger() throws JacksonException {
        if ((this._numTypesValid & 0x10) != 0) {
            this.streamReadConstraints().validateBigIntegerScale(this._numberBigDecimal.scale());
            this._numberBigInt = this._numberBigDecimal.toBigInteger();
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberLong);
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberInt);
        } else if ((this._numTypesValid & 8) != 0) {
            this._numberBigInt = BigDecimal.valueOf(this._numberDouble).toBigInteger();
        } else if ((this._numTypesValid & 0x20) != 0) {
            this._numberBigInt = BigDecimal.valueOf(this._numberFloat).toBigInteger();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 4;
    }

    protected void convertNumberToFloat() throws JacksonException {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberFloat = this._numberBigDecimal.floatValue();
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberFloat = this._numberBigInt.floatValue();
        } else if ((this._numTypesValid & 8) != 0) {
            this._numberFloat = (float)this._numberDouble;
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberFloat = this._numberLong;
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberFloat = this._numberInt;
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 0x20;
    }

    protected void convertNumberToDouble() throws JacksonException {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberDouble = this._numberBigDecimal.doubleValue();
        } else if ((this._numTypesValid & 0x20) != 0) {
            this._numberDouble = this._numberFloat;
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberDouble = this._numberBigInt.doubleValue();
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberDouble = this._numberLong;
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberDouble = this._numberInt;
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 8;
    }

    protected void convertNumberToBigDecimal() throws JacksonException {
        if ((this._numTypesValid & 0x28) != 0) {
            String text = this.getString();
            this.streamReadConstraints().validateFPLength(text.length());
            this._numberBigDecimal = NumberInput.parseBigDecimal((String)text, (boolean)this.isEnabled(StreamReadFeature.USE_FAST_BIG_NUMBER_PARSER));
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberBigDecimal = new BigDecimal(this._numberBigInt);
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberBigDecimal = BigDecimal.valueOf(this._numberLong);
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberBigDecimal = BigDecimal.valueOf(this._numberInt);
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 0x10;
    }

    protected void _finishToken() throws JacksonException {
        this._tokenIncomplete = false;
        if (this._currToken == JsonToken.VALUE_STRING) {
            int len = this._decodedLength;
            if (len > this._inputEnd - this._inputPtr) {
                if (len >= this._inputBuffer.length) {
                    this._finishLongText(len);
                    return;
                }
                this._loadToHaveAtLeast(len);
            }
            this._finishShortText(len);
            return;
        }
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            this._binaryValue = this._finishBytes(this._decodedLength);
            return;
        }
        this._throwInternal();
    }

    protected byte[] _finishBytes(int len) throws JacksonException {
        byte[] b = new byte[len];
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        int ptr = 0;
        while (true) {
            int toAdd = Math.min(len, this._inputEnd - this._inputPtr);
            System.arraycopy(this._inputBuffer, this._inputPtr, b, ptr, toAdd);
            this._inputPtr += toAdd;
            ptr += toAdd;
            if ((len -= toAdd) <= 0) {
                return b;
            }
            this.loadMoreGuaranteed();
        }
    }

    private final String _finishShortText(int len) throws JacksonException {
        int i;
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        if (outBuf.length < len) {
            outBuf = this._textBuffer.expandCurrentSegment(len);
        }
        int outPtr = 0;
        int inPtr = this._inputPtr;
        this._inputPtr += len;
        byte[] inputBuf = this._inputBuffer;
        int end = inPtr + len;
        while ((i = inputBuf[inPtr]) >= 0) {
            outBuf[outPtr++] = (char)i;
            if (++inPtr != end) continue;
            return this._textBuffer.setCurrentAndReturn(outPtr);
        }
        int[] codes = UTF8_UNIT_CODES;
        do {
            i = inputBuf[inPtr++] & 0xFF;
            switch (codes[i]) {
                case 0: {
                    break;
                }
                case 1: {
                    i = (i & 0x1F) << 6 | inputBuf[inPtr++] & 0x3F;
                    break;
                }
                case 2: {
                    i = (i & 0xF) << 12 | (inputBuf[inPtr++] & 0x3F) << 6 | inputBuf[inPtr++] & 0x3F;
                    break;
                }
                case 3: {
                    i = (i & 7) << 18 | (inputBuf[inPtr++] & 0x3F) << 12 | (inputBuf[inPtr++] & 0x3F) << 6 | inputBuf[inPtr++] & 0x3F;
                    outBuf[outPtr++] = (char)(0xD800 | (i -= 65536) >> 10);
                    i = 0xDC00 | i & 0x3FF;
                    break;
                }
                default: {
                    this._reportError("Invalid byte " + Integer.toHexString(i) + " in Unicode text block");
                }
            }
            outBuf[outPtr++] = (char)i;
        } while (inPtr < end);
        return this._textBuffer.setCurrentAndReturn(outPtr);
    }

    private final void _finishLongText(int len) throws JacksonException {
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        int outPtr = 0;
        int[] codes = UTF8_UNIT_CODES;
        int outEnd = outBuf.length;
        while (--len >= 0) {
            int c = this._nextByte() & 0xFF;
            int code = codes[c];
            if (code == 0 && outPtr < outEnd) {
                outBuf[outPtr++] = (char)c;
                continue;
            }
            if ((len -= code) < 0) {
                throw this._constructReadException("Malformed UTF-8 character at end of long (non-chunked) text segment");
            }
            switch (code) {
                case 0: {
                    break;
                }
                case 1: {
                    int d = this._nextByte();
                    if ((d & 0xC0) != 128) {
                        this._reportInvalidOther(d & 0xFF, this._inputPtr);
                    }
                    c = (c & 0x1F) << 6 | d & 0x3F;
                    break;
                }
                case 2: {
                    c = this._decodeUTF8_3(c);
                    break;
                }
                case 3: {
                    c = this._decodeUTF8_4(c);
                    outBuf[outPtr++] = (char)(0xD800 | c >> 10);
                    if (outPtr >= outBuf.length) {
                        outBuf = this._textBuffer.finishCurrentSegment();
                        outPtr = 0;
                        outEnd = outBuf.length;
                    }
                    c = 0xDC00 | c & 0x3FF;
                    break;
                }
                default: {
                    this._reportInvalidInitial(c);
                }
            }
            if (outPtr >= outEnd) {
                outBuf = this._textBuffer.finishCurrentSegment();
                outPtr = 0;
                outEnd = outBuf.length;
            }
            outBuf[outPtr++] = (char)c;
        }
        this._textBuffer.setCurrentLength(outPtr);
    }

    private final int _decodeUTF8_3(int c1) throws JacksonException {
        c1 &= 0xF;
        int d = this._nextByte();
        if ((d & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        int c = c1 << 6 | d & 0x3F;
        d = this._nextByte();
        if ((d & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = c << 6 | d & 0x3F;
        return c;
    }

    private final int _decodeUTF8_4(int c) throws JacksonException {
        int d = this._nextByte();
        if ((d & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = (c & 7) << 6 | d & 0x3F;
        d = this._nextByte();
        if ((d & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = c << 6 | d & 0x3F;
        d = this._nextByte();
        if ((d & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        return (c << 6 | d & 0x3F) - 65536;
    }

    private final int _nextByte() throws JacksonException {
        int inPtr = this._inputPtr;
        if (inPtr < this._inputEnd) {
            byte ch = this._inputBuffer[inPtr];
            this._inputPtr = inPtr + 1;
            return ch;
        }
        this.loadMoreGuaranteed();
        return this._inputBuffer[this._inputPtr++];
    }

    protected final boolean loadMore() throws JacksonException {
        if (this._inputStream != null) {
            int count;
            this._currInputProcessed += (long)this._inputEnd;
            try {
                count = this._inputStream.read(this._inputBuffer, 0, this._inputBuffer.length);
            }
            catch (IOException e) {
                throw this._wrapIOFailure(e);
            }
            if (count > 0) {
                this._currentEndOffset = this._streamReadContext.adjustEnd(this._inputEnd);
                this._inputPtr = 0;
                this._inputEnd = count;
                return true;
            }
            this._closeInput();
            if (count == 0) {
                this._reportBadInputStream(this._inputBuffer.length);
            }
        }
        return false;
    }

    protected final void loadMoreGuaranteed() throws JacksonException {
        if (!this.loadMore()) {
            this._reportInvalidEOF();
        }
    }

    protected final void _loadToHaveAtLeast(int minAvailable) throws JacksonException {
        if (this._inputStream == null) {
            throw this._constructReadException("Needed to read " + minAvailable + " bytes, reached end-of-input");
        }
        int ptr = this._inputPtr;
        int amount = this._inputEnd - ptr;
        if (ptr > 0) {
            this._currInputProcessed += (long)ptr;
            if (amount > 0) {
                System.arraycopy(this._inputBuffer, ptr, this._inputBuffer, 0, amount);
            }
            this._currentEndOffset = this._streamReadContext.adjustEnd(ptr);
        }
        this._inputPtr = 0;
        this._inputEnd = amount;
        while (this._inputEnd < minAvailable) {
            int count;
            int toRead = this._inputBuffer.length - this._inputEnd;
            try {
                count = this._inputStream.read(this._inputBuffer, this._inputEnd, toRead);
            }
            catch (IOException e) {
                throw this._wrapIOFailure(e);
            }
            if (count < 1) {
                this._closeInput();
                if (count == 0) {
                    this._reportBadInputStream(toRead);
                }
                throw this._constructReadException("Needed to read " + minAvailable + " bytes, missed " + minAvailable + " before end-of-input");
            }
            this._inputEnd += count;
        }
    }

    protected ByteArrayBuilder _getByteArrayBuilder() {
        if (this._byteArrayBuilder == null) {
            this._byteArrayBuilder = new ByteArrayBuilder();
        } else {
            this._byteArrayBuilder.reset();
        }
        return this._byteArrayBuilder;
    }

    protected void _handleEOF() throws StreamReadException {
        if (!this._streamReadContext.inRoot()) {
            String marker = this._streamReadContext.inArray() ? "Array" : "Object";
            this._reportInvalidEOF(String.format(": expected close marker for %s (start marker at %s)", marker, this._streamReadContext.startLocation(this._ioContext.contentReference(), this._currInputProcessed)), null);
        }
    }

    protected void _skipBytes(int len) throws JacksonException {
        while (true) {
            int toAdd = Math.min(len, this._inputEnd - this._inputPtr);
            this._inputPtr += toAdd;
            if ((len -= toAdd) <= 0) {
                return;
            }
            this.loadMoreGuaranteed();
        }
    }

    protected void _skipVInt() throws JacksonException {
        int ptr = this._inputPtr;
        if (ptr + 10 > this._inputEnd) {
            this._skipVIntSlow();
            return;
        }
        byte[] buf = this._inputBuffer;
        if (buf[ptr++] >= 0 || buf[ptr++] >= 0 || buf[ptr++] >= 0 || buf[ptr++] >= 0) {
            this._inputPtr = ptr;
            return;
        }
        int end = ptr + 6;
        while (ptr < end) {
            if (buf[ptr] >= 0) {
                this._inputPtr = ptr + 1;
                return;
            }
            ++ptr;
        }
        this._reportTooLongVInt(buf[ptr - 1]);
    }

    protected void _skipVIntSlow() throws JacksonException {
        for (int i = 0; i < 10; ++i) {
            byte ch;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((ch = this._inputBuffer[this._inputPtr++]) < 0) continue;
            return;
        }
        this._reportTooLongVInt(this._inputBuffer[this._inputPtr - 1]);
    }

    private int _decodeVInt() throws JacksonException {
        int v;
        int ptr = this._inputPtr;
        if (ptr + 5 > this._inputEnd) {
            return this._decodeVIntSlow();
        }
        byte[] buf = this._inputBuffer;
        if ((v = buf[ptr++]) < 0) {
            byte ch;
            v &= 0x7F;
            if ((ch = buf[ptr++]) < 0) {
                v |= (ch & 0x7F) << 7;
                if ((ch = buf[ptr++]) < 0) {
                    v |= (ch & 0x7F) << 14;
                    if ((ch = buf[ptr++]) < 0) {
                        int last;
                        v |= (ch & 0x7F) << 21;
                        if ((last = buf[ptr++] & 0xFF) > 31) {
                            this._inputPtr = ptr;
                            this._reportTooLongVInt(last);
                        }
                        v |= last << 28;
                    } else {
                        v |= ch << 21;
                    }
                } else {
                    v |= ch << 14;
                }
            } else {
                v |= ch << 7;
            }
        }
        this._inputPtr = ptr;
        return v;
    }

    private int _decodeLength() throws JacksonException {
        int v;
        int ptr = this._inputPtr;
        if (ptr + 5 > this._inputEnd) {
            int v2 = this._decodeVIntSlow();
            if (v2 < 0) {
                this._reportInvalidLength(v2);
            }
            return v2;
        }
        byte[] buf = this._inputBuffer;
        if ((v = buf[ptr++]) < 0) {
            byte ch;
            v &= 0x7F;
            if ((ch = buf[ptr++]) < 0) {
                v |= (ch & 0x7F) << 7;
                if ((ch = buf[ptr++]) < 0) {
                    v |= (ch & 0x7F) << 14;
                    if ((ch = buf[ptr++]) < 0) {
                        int last;
                        v |= (ch & 0x7F) << 21;
                        if ((last = buf[ptr++] & 0xFF) > 15) {
                            this._inputPtr = ptr;
                            this._reportTooLongVInt(last);
                        }
                        v |= last << 28;
                    } else {
                        v |= ch << 21;
                    }
                } else {
                    v |= ch << 14;
                }
            } else {
                v |= ch << 7;
            }
        }
        this._inputPtr = ptr;
        if (v < 0) {
            this._reportInvalidLength(v);
        }
        return v;
    }

    protected int _decodeVIntSlow() throws JacksonException {
        int v = 0;
        int shift = 0;
        while (true) {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            int ch = this._inputBuffer[this._inputPtr++];
            if (shift >= 28 && (ch &= 0xFF) > 15) {
                this._reportTooLongVInt(ch);
            }
            if (ch >= 0) {
                return v | ch << shift;
            }
            v |= (ch & 0x7F) << shift;
            shift += 7;
        }
    }

    private long _decodeVLong() throws JacksonException {
        int ch;
        int v;
        if (this._inputPtr + 10 > this._inputEnd) {
            return this._decodeVLongSlow();
        }
        byte[] buf = this._inputBuffer;
        if ((v = buf[this._inputPtr++]) >= 0) {
            return v;
        }
        v &= 0x7F;
        if ((ch = buf[this._inputPtr++]) >= 0) {
            return v | ch << 7;
        }
        v |= (ch & 0x7F) << 7;
        if ((ch = buf[this._inputPtr++]) >= 0) {
            return v | ch << 14;
        }
        v |= (ch & 0x7F) << 14;
        if ((ch = buf[this._inputPtr++]) >= 0) {
            return v | ch << 21;
        }
        long l = v |= (ch & 0x7F) << 21;
        if ((v = buf[this._inputPtr++]) >= 0) {
            return (long)v << 28 | l;
        }
        v &= 0x7F;
        if ((ch = buf[this._inputPtr++]) >= 0) {
            long l2 = v | ch << 7;
            return l2 << 28 | l;
        }
        v |= (ch & 0x7F) << 7;
        if ((ch = buf[this._inputPtr++]) >= 0) {
            long l2 = v | ch << 14;
            return l2 << 28 | l;
        }
        v |= (ch & 0x7F) << 14;
        if ((ch = buf[this._inputPtr++]) >= 0) {
            long l2 = v | ch << 21;
            return l2 << 28 | l;
        }
        l |= (long)(v |= (ch & 0x7F) << 21) << 28;
        if ((v = buf[this._inputPtr++]) >= 0) {
            return (long)v << 56 | l;
        }
        v &= 0x7F;
        if ((ch = buf[this._inputPtr++] & 0xFF) > 1) {
            this._reportTooLongVInt(ch);
        }
        return (long)(v |= (ch & 0x7F) << 7) << 56 | l;
    }

    protected long _decodeVLongSlow() throws JacksonException {
        long v = 0L;
        int shift = 0;
        while (true) {
            long l;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            int ch = this._inputBuffer[this._inputPtr++];
            if (shift >= 63 && (ch &= 0xFF) > 1) {
                this._reportTooLongVLong(ch);
            }
            if (ch >= 0) {
                l = ch;
                return v | l << shift;
            }
            l = ch &= 0x7F;
            v |= l << shift;
            shift += 7;
        }
    }

    protected final int _decode32Bits() throws JacksonException {
        int ptr = this._inputPtr;
        if (ptr + 3 >= this._inputEnd) {
            return this._slow32();
        }
        byte[] b = this._inputBuffer;
        int v = (b[ptr] & 0xFF) + ((b[ptr + 1] & 0xFF) << 8) + ((b[ptr + 2] & 0xFF) << 16) + ((b[ptr + 3] & 0xFF) << 24);
        this._inputPtr = ptr + 4;
        return v;
    }

    protected final int _slow32() throws JacksonException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        int v = this._inputBuffer[this._inputPtr++] & 0xFF;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        v |= (this._inputBuffer[this._inputPtr++] & 0xFF) << 8;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        v |= (this._inputBuffer[this._inputPtr++] & 0xFF) << 16;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        return v | this._inputBuffer[this._inputPtr++] << 24;
    }

    protected final long _decode64Bits() throws JacksonException {
        int ptr = this._inputPtr;
        if (ptr + 7 >= this._inputEnd) {
            return this._slow64();
        }
        byte[] b = this._inputBuffer;
        int i1 = b[ptr++] & 0xFF | (b[ptr++] & 0xFF) << 8 | (b[ptr++] & 0xFF) << 16 | b[ptr++] << 24;
        int i2 = b[ptr++] & 0xFF | (b[ptr++] & 0xFF) << 8 | (b[ptr++] & 0xFF) << 16 | b[ptr++] << 24;
        this._inputPtr = ptr;
        return ProtobufParser._long(i1, i2);
    }

    protected final long _slow64() throws JacksonException {
        return ProtobufParser._long(this._decode32Bits(), this._decode32Bits());
    }

    protected static final long _long(int i1, int i2) {
        long high = i2;
        long low = i1;
        low = low << 32 >>> 32;
        return (high <<= 32) | low;
    }

    private void _reportErrorF(String format, Object ... args) throws StreamReadException {
        throw this._constructReadException(String.format(format, args));
    }

    private void _reportIncompatibleType(ProtobufField field, int wireType) throws StreamReadException {
        throw this._constructReadException(String.format("Incompatible wire type (0x%x) for field '%s': not valid for field of type %s (expected 0x%x)", new Object[]{wireType, field.name, field.type, field.type.getWireType()}));
    }

    private void _reportInvalidLength(int len) throws StreamReadException {
        throw this._constructReadException("Invalid length (%d): must be positive number", len);
    }

    private void _reportTooLongVInt(int fifth) throws StreamReadException {
        throw this._constructReadException("Too long tag VInt: fifth byte 0x%x", fifth);
    }

    private void _reportTooLongVLong(int fifth) throws StreamReadException {
        throw this._constructReadException("Too long tag VLong: tenth byte 0x%x", fifth);
    }

    private void _reportInvalidInitial(int mask) throws StreamReadException {
        throw this._constructReadException("Invalid UTF-8 start byte 0x%x", mask);
    }

    private void _reportInvalidOther(int mask) throws StreamReadException {
        throw this._constructReadException("Invalid UTF-8 middle byte 0x%x", mask);
    }

    private void _reportInvalidOther(int mask, int ptr) throws StreamReadException {
        this._inputPtr = ptr;
        this._reportInvalidOther(mask);
    }
}

