/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.javaprop;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import tools.jackson.core.Base64Variant;
import tools.jackson.core.FormatSchema;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.PrettyPrinter;
import tools.jackson.core.SerializableString;
import tools.jackson.core.StreamWriteCapability;
import tools.jackson.core.StreamWriteFeature;
import tools.jackson.core.TokenStreamContext;
import tools.jackson.core.Version;
import tools.jackson.core.base.GeneratorBase;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.util.JacksonFeatureSet;
import tools.jackson.dataformat.javaprop.JavaPropsSchema;
import tools.jackson.dataformat.javaprop.PackageVersion;
import tools.jackson.dataformat.javaprop.io.JPropWriteContext;
import tools.jackson.dataformat.javaprop.util.Markers;

public abstract class JavaPropsGenerator
extends GeneratorBase {
    protected static final int SHORT_WRITE = 100;
    protected final JavaPropsSchema _schema;
    protected JPropWriteContext _streamWriteContext;
    protected final StringBuilder _basePath = new StringBuilder(50);
    protected boolean _headerChecked;
    protected int _indentLength;

    public JavaPropsGenerator(ObjectWriteContext writeCtxt, IOContext ioCtxt, int stdFeatures, JavaPropsSchema schema) {
        super(writeCtxt, ioCtxt, stdFeatures);
        this._streamWriteContext = JPropWriteContext.createRootContext();
        this._schema = schema;
        if (this._streamWriteContext.inRoot()) {
            String prefix;
            String indent = this._schema.lineIndentation();
            int n = this._indentLength = indent == null ? 0 : indent.length();
            if (this._indentLength > 0) {
                this._basePath.setLength(0);
                this._basePath.append(indent);
                this._streamWriteContext = JPropWriteContext.createRootContext(this._indentLength);
            }
            if ((prefix = this._schema.prefix()) != null) {
                this._basePath.append(prefix);
            }
        }
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public TokenStreamContext streamWriteContext() {
        return this._streamWriteContext;
    }

    public Object currentValue() {
        return this._streamWriteContext.currentValue();
    }

    public void assignCurrentValue(Object v) {
        this._streamWriteContext.assignCurrentValue(v);
    }

    public PrettyPrinter getPrettyPrinter() {
        return null;
    }

    public FormatSchema getSchema() {
        return this._schema;
    }

    public boolean canWriteObjectId() {
        return false;
    }

    public boolean canWriteTypeId() {
        return false;
    }

    public boolean canOmitProperties() {
        return true;
    }

    public JacksonFeatureSet<StreamWriteCapability> streamWriteCapabilities() {
        return DEFAULT_TEXTUAL_WRITE_CAPABILITIES;
    }

    public JsonGenerator writeName(String name) throws JacksonException {
        String sep;
        if (!this._streamWriteContext.writeName(name)) {
            this._reportError("Cannot write a property name, expecting a value");
        }
        if (!this._headerChecked) {
            this._headerChecked = true;
            String header = this._schema.header();
            if (header != null && !header.isEmpty()) {
                this._writeRaw(header);
            }
        }
        this._streamWriteContext.truncatePath(this._basePath);
        if (this._basePath.length() > this._indentLength && !(sep = this._schema.pathSeparator()).isEmpty()) {
            this._basePath.append(sep);
        }
        this._appendPropertyName(this._basePath, name);
        return this;
    }

    public JsonGenerator writePropertyId(long id) throws JacksonException {
        return this.writeName(Long.toString(id));
    }

    protected abstract void _appendPropertyName(StringBuilder var1, String var2);

    public JsonGenerator writeStartArray() throws JacksonException {
        this._verifyValueWrite("start an array");
        this._streamWriteContext = this._streamWriteContext.createChildArrayContext(null, this._basePath.length());
        this.streamWriteConstraints().validateNestingDepth(this._streamWriteContext.getNestingDepth());
        return this;
    }

    public JsonGenerator writeStartArray(Object currValue) throws JacksonException {
        this._verifyValueWrite("start an array");
        this._streamWriteContext = this._streamWriteContext.createChildArrayContext(currValue, this._basePath.length());
        this.streamWriteConstraints().validateNestingDepth(this._streamWriteContext.getNestingDepth());
        return this;
    }

    public JsonGenerator writeEndArray() throws JacksonException {
        if (!this._streamWriteContext.inArray()) {
            this._reportError("Current context not an Array but " + this._streamWriteContext.typeDesc());
        }
        this._streamWriteContext = this._streamWriteContext.getParent();
        return this;
    }

    public JsonGenerator writeStartObject() throws JacksonException {
        this._verifyValueWrite("start an object");
        this._streamWriteContext = this._streamWriteContext.createChildObjectContext(null, this._basePath.length());
        this.streamWriteConstraints().validateNestingDepth(this._streamWriteContext.getNestingDepth());
        return this;
    }

    public JsonGenerator writeStartObject(Object forValue) throws JacksonException {
        this._verifyValueWrite("start an object");
        this._streamWriteContext = this._streamWriteContext.createChildObjectContext(forValue, this._basePath.length());
        this.streamWriteConstraints().validateNestingDepth(this._streamWriteContext.getNestingDepth());
        return this;
    }

    public JsonGenerator writeEndObject() throws JacksonException {
        if (!this._streamWriteContext.inObject()) {
            this._reportError("Current context not an Ibject but " + this._streamWriteContext.typeDesc());
        }
        this._streamWriteContext = this._streamWriteContext.getParent();
        return this;
    }

    public JsonGenerator writeString(String text) throws JacksonException {
        if (text == null) {
            return this.writeNull();
        }
        this._verifyValueWrite("write String value");
        this._writeEscapedEntry(text);
        return this;
    }

    public JsonGenerator writeString(char[] text, int offset, int len) throws JacksonException {
        this._verifyValueWrite("write String value");
        this._writeEscapedEntry(text, offset, len);
        return this;
    }

    public JsonGenerator writeRawUTF8String(byte[] text, int offset, int len) throws JacksonException {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeUTF8String(byte[] text, int offset, int len) throws JacksonException {
        return this.writeString(new String(text, offset, len, StandardCharsets.UTF_8));
    }

    public JsonGenerator writeRaw(String text) throws JacksonException {
        this._writeRaw(text);
        return this;
    }

    public JsonGenerator writeRaw(String text, int offset, int len) throws JacksonException {
        this._writeRaw(text.substring(offset, offset + len));
        return this;
    }

    public JsonGenerator writeRaw(char[] text, int offset, int len) throws JacksonException {
        this._writeRaw(text, offset, len);
        return this;
    }

    public JsonGenerator writeRaw(char c) throws JacksonException {
        this._writeRaw(c);
        return this;
    }

    public JsonGenerator writeRaw(SerializableString text) throws JacksonException {
        this.writeRaw(text.toString());
        return this;
    }

    public JsonGenerator writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) throws JacksonException {
        if (data == null) {
            return this.writeNull();
        }
        this._verifyValueWrite("write Binary value");
        if (offset > 0 || offset + len != data.length) {
            data = Arrays.copyOfRange(data, offset, offset + len);
        }
        String encoded = b64variant.encode(data);
        this._writeEscapedEntry(encoded);
        return this;
    }

    public JsonGenerator writeBoolean(boolean state) throws JacksonException {
        this._verifyValueWrite("write boolean value");
        this._writeUnescapedEntry(state ? "true" : "false");
        return this;
    }

    public JsonGenerator writeNumber(short v) throws JacksonException {
        return this.writeNumber((int)v);
    }

    public JsonGenerator writeNumber(int i) throws JacksonException {
        this._verifyValueWrite("write number");
        this._writeUnescapedEntry(String.valueOf(i));
        return this;
    }

    public JsonGenerator writeNumber(long l) throws JacksonException {
        this._verifyValueWrite("write number");
        this._writeUnescapedEntry(String.valueOf(l));
        return this;
    }

    public JsonGenerator writeNumber(BigInteger v) throws JacksonException {
        if (v == null) {
            return this.writeNull();
        }
        this._verifyValueWrite("write number");
        this._writeUnescapedEntry(String.valueOf(v));
        return this;
    }

    public JsonGenerator writeNumber(double d) throws JacksonException {
        this._verifyValueWrite("write number");
        this._writeUnescapedEntry(String.valueOf(d));
        return this;
    }

    public JsonGenerator writeNumber(float f) throws JacksonException {
        this._verifyValueWrite("write number");
        this._writeUnescapedEntry(String.valueOf(f));
        return this;
    }

    public JsonGenerator writeNumber(BigDecimal dec) throws JacksonException {
        if (dec == null) {
            return this.writeNull();
        }
        this._verifyValueWrite("write number");
        String str = this.isEnabled(StreamWriteFeature.WRITE_BIGDECIMAL_AS_PLAIN) ? dec.toPlainString() : dec.toString();
        this._writeUnescapedEntry(str);
        return this;
    }

    public JsonGenerator writeNumber(String encodedValue) throws JacksonException {
        if (encodedValue == null) {
            return this.writeNull();
        }
        this._verifyValueWrite("write number");
        this._writeUnescapedEntry(encodedValue);
        return this;
    }

    public JsonGenerator writeNull() throws JacksonException {
        this._verifyValueWrite("write null value");
        this._writeUnescapedEntry("");
        return this;
    }

    protected void _verifyValueWrite(String typeMsg) throws JacksonException {
        if (!this._streamWriteContext.writeValue()) {
            this._reportError("Cannot " + typeMsg + ", expecting a property name");
        }
        if (this._streamWriteContext.inArray()) {
            this._streamWriteContext.truncatePath(this._basePath);
            int ix = this._streamWriteContext.getCurrentIndex() + this._schema.firstArrayOffset();
            if (this._schema.writeIndexUsingMarkers()) {
                Markers m = this._schema.indexMarker();
                this._basePath.append(m.getStart());
                this._basePath.append(ix);
                this._basePath.append(m.getEnd());
            } else {
                String sep;
                if (this._basePath.length() > 0 && !(sep = this._schema.pathSeparator()).isEmpty()) {
                    this._basePath.append(sep);
                }
                this._basePath.append(ix);
            }
        }
    }

    protected abstract void _writeEscapedEntry(String var1) throws JacksonException;

    protected abstract void _writeEscapedEntry(char[] var1, int var2, int var3) throws JacksonException;

    protected abstract void _writeUnescapedEntry(String var1) throws JacksonException;

    protected abstract void _writeRaw(char var1) throws JacksonException;

    protected abstract void _writeRaw(String var1) throws JacksonException;

    protected abstract void _writeRaw(StringBuilder var1) throws JacksonException;

    protected abstract void _writeRaw(char[] var1, int var2, int var3) throws JacksonException;
}

