/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.ion.jsr310;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.temporal.Temporal;
import java.util.function.BiFunction;
import java.util.function.Function;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.ser.std.StdScalarSerializer;
import tools.jackson.dataformat.ion.IonGenerator;
import tools.jackson.dataformat.ion.jsr310.TimestampUtils;

public class IonTimestampInstantSerializer<T extends Temporal>
extends StdScalarSerializer<T> {
    public static final IonTimestampInstantSerializer<Instant> INSTANT = new IonTimestampInstantSerializer<Instant>(Instant.class, Function.identity(), instant -> ZoneOffset.UTC, (instant, zoneId) -> instant.atZone((ZoneId)zoneId).getOffset());
    public static final IonTimestampInstantSerializer<OffsetDateTime> OFFSET_DATE_TIME = new IonTimestampInstantSerializer<OffsetDateTime>(OffsetDateTime.class, OffsetDateTime::toInstant, OffsetDateTime::getOffset, (offsetDateTime, zoneId) -> offsetDateTime.atZoneSameInstant((ZoneId)zoneId).getOffset());
    public static final IonTimestampInstantSerializer<ZonedDateTime> ZONED_DATE_TIME = new IonTimestampInstantSerializer<ZonedDateTime>(ZonedDateTime.class, ChronoZonedDateTime::toInstant, ZonedDateTime::getOffset, (zonedDateTime, zoneId) -> zonedDateTime.withZoneSameInstant((ZoneId)zoneId).getOffset());
    private final Function<T, Instant> getInstant;
    private final Function<T, ZoneOffset> getOffset;
    private final BiFunction<T, ZoneId, ZoneOffset> getOffsetAtZoneId;
    private final ZoneId zoneIdOverride;
    private final Boolean writeDateTimestampsAsNanosOverride;

    protected IonTimestampInstantSerializer(Class<T> t, Function<T, Instant> getInstant, Function<T, ZoneOffset> getOffset, BiFunction<T, ZoneId, ZoneOffset> getOffsetAtZoneId) {
        super(t);
        this.getInstant = getInstant;
        this.getOffset = getOffset;
        this.getOffsetAtZoneId = getOffsetAtZoneId;
        this.zoneIdOverride = null;
        this.writeDateTimestampsAsNanosOverride = null;
    }

    protected IonTimestampInstantSerializer(IonTimestampInstantSerializer<T> base, ZoneId zoneIdOverride, Boolean writeDateTimestampsAsNanosOverride) {
        super(base);
        this.getInstant = base.getInstant;
        this.getOffset = base.getOffset;
        this.getOffsetAtZoneId = base.getOffsetAtZoneId;
        this.zoneIdOverride = zoneIdOverride;
        this.writeDateTimestampsAsNanosOverride = writeDateTimestampsAsNanosOverride;
    }

    public void serialize(T value, JsonGenerator gen, SerializationContext provider) throws JacksonException {
        Instant instant = this.getInstant.apply(value);
        if (provider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
            if (this.shouldWriteTimestampsAsNanos(provider)) {
                gen.writeNumber(TimestampUtils.getFractionalSeconds(instant));
            } else {
                gen.writeNumber(instant.toEpochMilli());
            }
        } else {
            ZoneOffset offset = this.getOffset(value);
            ((IonGenerator)gen).writeValue(TimestampUtils.toTimestamp(instant, offset));
        }
    }

    public ValueSerializer<?> createContextual(SerializationContext prov, BeanProperty property) {
        JsonFormat.Value format = this.findFormatOverrides(prov, property, this.handledType());
        if (format != null) {
            return new IonTimestampInstantSerializer<T>(this, format.getTimeZone() == null ? null : format.getTimeZone().toZoneId(), format.getFeature(JsonFormat.Feature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS));
        }
        return this;
    }

    private boolean shouldWriteTimestampsAsNanos(SerializationContext provider) {
        if (Boolean.FALSE.equals(this.writeDateTimestampsAsNanosOverride)) {
            return false;
        }
        return provider.isEnabled(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS) || Boolean.TRUE.equals(this.writeDateTimestampsAsNanosOverride);
    }

    private ZoneOffset getOffset(T value) {
        if (null != this.zoneIdOverride) {
            return this.getOffsetAtZoneId.apply(value, this.zoneIdOverride);
        }
        return this.getOffset.apply(value);
    }
}

