/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.ion;

import tools.jackson.core.JsonGenerator;
import tools.jackson.core.TokenStreamContext;
import tools.jackson.core.exc.StreamWriteException;
import tools.jackson.core.json.DupDetector;

public class IonWriteContext
extends TokenStreamContext {
    protected static final int TYPE_SEXP = 30;
    public static final int STATUS_OK_AFTER_SEXP_SEPARATOR = 60;
    protected final IonWriteContext _parent;
    protected DupDetector _dups;
    protected IonWriteContext _child;
    protected String _currentName;
    protected Object _currentValue;
    protected boolean _gotPropertyId;

    protected IonWriteContext(int type, IonWriteContext parent, int nestingDepth, DupDetector dups, Object currentValue) {
        this._type = type;
        this._parent = parent;
        this._nestingDepth = nestingDepth;
        this._dups = dups;
        this._index = -1;
        this._currentValue = currentValue;
    }

    public Object currentValue() {
        return this._currentValue;
    }

    public void assignCurrentValue(Object v) {
        this._currentValue = v;
    }

    public static IonWriteContext createRootContext(DupDetector dd) {
        return new IonWriteContext(0, null, 0, dd, null);
    }

    private IonWriteContext reset(int type, Object currentValue) {
        this._type = type;
        this._index = -1;
        this._currentName = null;
        this._gotPropertyId = false;
        this._currentValue = currentValue;
        if (this._dups != null) {
            this._dups.reset();
        }
        return this;
    }

    public IonWriteContext createChildSexpContext(Object currentValue) {
        IonWriteContext ctxt = this._child;
        if (ctxt == null) {
            this._child = ctxt = new IonWriteContext(30, this, this._nestingDepth + 1, this._dups == null ? null : this._dups.child(), currentValue);
        }
        return ctxt.reset(30, currentValue);
    }

    public IonWriteContext createChildArrayContext(Object currentValue) {
        IonWriteContext ctxt = this._child;
        if (ctxt == null) {
            this._child = ctxt = new IonWriteContext(1, this, this._nestingDepth + 1, this._dups == null ? null : this._dups.child(), currentValue);
            return ctxt;
        }
        return ctxt.reset(1, currentValue);
    }

    public IonWriteContext createChildObjectContext(Object currentValue) {
        IonWriteContext ctxt = this._child;
        if (ctxt == null) {
            this._child = ctxt = new IonWriteContext(2, this, this._nestingDepth + 1, this._dups == null ? null : this._dups.child(), currentValue);
            return ctxt;
        }
        return ctxt.reset(2, currentValue);
    }

    public final IonWriteContext getParent() {
        return this._parent;
    }

    public final String currentName() {
        return this._currentName;
    }

    public boolean hasCurrentName() {
        return this._gotPropertyId;
    }

    public final boolean inSexp() {
        return this._type == 30;
    }

    public boolean writeName(String name) throws StreamWriteException {
        if (this._type != 2 || this._gotPropertyId) {
            return false;
        }
        this._gotPropertyId = true;
        this._currentName = name;
        if (this._dups != null) {
            this._checkDup(this._dups, name);
        }
        return true;
    }

    private final void _checkDup(DupDetector dd, String name) throws StreamWriteException {
        if (dd.isDup(name)) {
            Object src = dd.getSource();
            throw new StreamWriteException(src instanceof JsonGenerator ? (JsonGenerator)src : null, "Duplicate Object property \"" + name + "\"");
        }
    }

    public boolean writeValue() {
        if (this._type == 2) {
            if (!this._gotPropertyId) {
                return false;
            }
            this._gotPropertyId = false;
        }
        ++this._index;
        return true;
    }
}

