/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.ion;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.ser.std.StdScalarSerializer;
import tools.jackson.dataformat.ion.IonGenerator;

public class IonTimestampSerializers {

    public static class IonTimestampSQLDateSerializer
    extends StdScalarSerializer<java.sql.Date> {
        public IonTimestampSQLDateSerializer() {
            super(java.sql.Date.class);
        }

        public void serialize(java.sql.Date date, JsonGenerator jsonGenerator, SerializationContext ctxt) {
            if (ctxt.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
                jsonGenerator.writeNumber(date.getTime());
            } else {
                Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                cal.setTime(date);
                ((IonGenerator)jsonGenerator).writeDate(cal);
            }
        }
    }

    public static class IonTimestampJavaDateSerializer
    extends StdScalarSerializer<Date> {
        public IonTimestampJavaDateSerializer() {
            super(Date.class);
        }

        public void serialize(Date date, JsonGenerator jsonGenerator, SerializationContext ctxt) {
            if (ctxt.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
                jsonGenerator.writeNumber(date.getTime());
            } else {
                Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                cal.setTime(date);
                ((IonGenerator)jsonGenerator).writeDate(cal);
            }
        }
    }
}

