/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.csv;

import tools.jackson.core.FormatFeature;

public enum CsvReadFeature implements FormatFeature
{
    TRIM_SPACES(false),
    TRIM_HEADER_SPACES(true),
    WRAP_AS_ARRAY(false),
    IGNORE_TRAILING_UNMAPPABLE(false),
    SKIP_EMPTY_LINES(false),
    ALLOW_TRAILING_COMMA(true),
    ALLOW_COMMENTS(false),
    FAIL_ON_MISSING_COLUMNS(false),
    FAIL_ON_MISSING_HEADER_COLUMNS(true),
    INSERT_NULLS_FOR_MISSING_COLUMNS(false),
    EMPTY_STRING_AS_NULL(false),
    EMPTY_UNQUOTED_STRING_AS_NULL(false);

    private final boolean _defaultState;
    private final int _mask;

    public static int collectDefaults() {
        int flags = 0;
        for (CsvReadFeature f : CsvReadFeature.values()) {
            if (!f.enabledByDefault()) continue;
            flags |= f.getMask();
        }
        return flags;
    }

    private CsvReadFeature(boolean defaultState) {
        this._defaultState = defaultState;
        this._mask = 1 << this.ordinal();
    }

    public boolean enabledByDefault() {
        return this._defaultState;
    }

    public boolean enabledIn(int flags) {
        return (flags & this._mask) != 0;
    }

    public int getMask() {
        return this._mask;
    }
}

