/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.csv;

import java.io.CharArrayReader;
import java.io.DataInput;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import tools.jackson.core.ErrorReportConfiguration;
import tools.jackson.core.FormatSchema;
import tools.jackson.core.JsonParser;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.StreamReadConstraints;
import tools.jackson.core.StreamWriteConstraints;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.core.Version;
import tools.jackson.core.base.DecorableTSFactory;
import tools.jackson.core.base.TextualTSFactory;
import tools.jackson.core.io.IOContext;
import tools.jackson.dataformat.csv.CsvCharacterEscapes;
import tools.jackson.dataformat.csv.CsvFactoryBuilder;
import tools.jackson.dataformat.csv.CsvGenerator;
import tools.jackson.dataformat.csv.CsvParser;
import tools.jackson.dataformat.csv.CsvReadFeature;
import tools.jackson.dataformat.csv.CsvSchema;
import tools.jackson.dataformat.csv.CsvWriteFeature;
import tools.jackson.dataformat.csv.PackageVersion;
import tools.jackson.dataformat.csv.impl.CsvParserBootstrapper;
import tools.jackson.dataformat.csv.impl.UTF8Writer;

public class CsvFactory
extends TextualTSFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT_NAME_CSV = "CSV";
    protected static final int DEFAULT_CSV_PARSER_FEATURE_FLAGS = CsvReadFeature.collectDefaults();
    protected static final int DEFAULT_CSV_GENERATOR_FEATURE_FLAGS = CsvWriteFeature.collectDefaults();
    protected static final char[] DEFAULT_LF = new char[]{'\n'};
    protected static final CsvSchema DEFAULT_SCHEMA = CsvSchema.emptySchema();
    protected final CsvCharacterEscapes _characterEscapes;

    public CsvFactory() {
        super(StreamReadConstraints.defaults(), StreamWriteConstraints.defaults(), ErrorReportConfiguration.defaults(), DEFAULT_CSV_PARSER_FEATURE_FLAGS, DEFAULT_CSV_GENERATOR_FEATURE_FLAGS);
        this._characterEscapes = null;
    }

    protected CsvFactory(CsvFactory src) {
        super((TextualTSFactory)src);
        this._characterEscapes = src._characterEscapes;
    }

    protected CsvFactory(CsvFactoryBuilder b) {
        super((DecorableTSFactory.DecorableTSFBuilder)b);
        this._characterEscapes = b.characterEscapes();
    }

    public CsvFactoryBuilder rebuild() {
        return new CsvFactoryBuilder(this);
    }

    public static CsvFactoryBuilder builder() {
        return new CsvFactoryBuilder();
    }

    public CsvFactory copy() {
        return new CsvFactory(this);
    }

    public TokenStreamFactory snapshot() {
        return this;
    }

    protected Object readResolve() {
        return new CsvFactory(this);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public boolean requiresPropertyOrdering() {
        return true;
    }

    public boolean canUseCharArrays() {
        return false;
    }

    public boolean canParseAsync() {
        return false;
    }

    public String getFormatName() {
        return FORMAT_NAME_CSV;
    }

    public boolean canUseSchema(FormatSchema schema) {
        return schema instanceof CsvSchema;
    }

    public Class<CsvReadFeature> getFormatReadFeatureType() {
        return CsvReadFeature.class;
    }

    public Class<CsvWriteFeature> getFormatWriteFeatureType() {
        return CsvWriteFeature.class;
    }

    public int getFormatReadFeatures() {
        return this._formatReadFeatures;
    }

    public int getFormatWriteFeatures() {
        return this._formatWriteFeatures;
    }

    public final boolean isEnabled(CsvReadFeature f) {
        return (this._formatReadFeatures & f.getMask()) != 0;
    }

    public boolean isEnabled(CsvWriteFeature f) {
        return (this._formatWriteFeatures & f.getMask()) != 0;
    }

    protected CsvParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, InputStream in) {
        return new CsvParserBootstrapper(ioCtxt, in).constructParser(readCtxt, readCtxt.getStreamReadFeatures(this._streamReadFeatures), readCtxt.getFormatReadFeatures(this._formatReadFeatures), this._getSchema(readCtxt));
    }

    protected CsvParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, byte[] data, int offset, int len) {
        return new CsvParserBootstrapper(ioCtxt, data, offset, len).constructParser(readCtxt, readCtxt.getStreamReadFeatures(this._streamReadFeatures), readCtxt.getFormatReadFeatures(this._formatReadFeatures), this._getSchema(readCtxt));
    }

    protected CsvParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, Reader r) {
        return new CsvParser(readCtxt, ioCtxt, readCtxt.getStreamReadFeatures(this._streamReadFeatures), readCtxt.getFormatReadFeatures(this._formatReadFeatures), this._getSchema(readCtxt), r);
    }

    protected CsvParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, char[] data, int offset, int len, boolean recyclable) {
        return new CsvParser(readCtxt, ioCtxt, readCtxt.getStreamReadFeatures(this._streamReadFeatures), readCtxt.getFormatReadFeatures(this._formatReadFeatures), this._getSchema(readCtxt), new CharArrayReader(data, offset, len));
    }

    protected JsonParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, DataInput input) {
        return (JsonParser)this._unsupported();
    }

    private final CsvSchema _getSchema(ObjectReadContext readCtxt) {
        FormatSchema sch = readCtxt.getSchema();
        if (sch == null) {
            return DEFAULT_SCHEMA;
        }
        return (CsvSchema)sch;
    }

    protected CsvGenerator _createGenerator(ObjectWriteContext writeCtxt, IOContext ioCtxt, Writer out) {
        return new CsvGenerator(writeCtxt, ioCtxt, writeCtxt.getStreamWriteFeatures(this._streamWriteFeatures), writeCtxt.getFormatWriteFeatures(this._formatWriteFeatures), out, this._getSchema(writeCtxt), this._characterEscapes);
    }

    protected CsvGenerator _createUTF8Generator(ObjectWriteContext writeCtxt, IOContext ioCtxt, OutputStream out) {
        return new CsvGenerator(writeCtxt, ioCtxt, writeCtxt.getStreamWriteFeatures(this._streamWriteFeatures), writeCtxt.getFormatWriteFeatures(this._formatWriteFeatures), new UTF8Writer(ioCtxt, out), this._getSchema(writeCtxt), this._characterEscapes);
    }

    private final CsvSchema _getSchema(ObjectWriteContext writeCtxt) {
        FormatSchema sch = writeCtxt.getSchema();
        if (sch == null) {
            return DEFAULT_SCHEMA;
        }
        return (CsvSchema)sch;
    }
}

