/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.avro.deser;

import java.util.ArrayList;
import java.util.Map;
import tools.jackson.databind.JsonNode;
import tools.jackson.dataformat.avro.deser.AvroFieldReader;
import tools.jackson.dataformat.avro.deser.ScalarDefaults;
import tools.jackson.dataformat.avro.deser.StructDefaults;

public class AvroFieldDefaulters {
    public static AvroFieldReader createDefaulter(String name, JsonNode defaultAsNode) {
        switch (defaultAsNode.asToken()) {
            case VALUE_TRUE: {
                return new ScalarDefaults.BooleanDefaults(name, true);
            }
            case VALUE_FALSE: {
                return new ScalarDefaults.BooleanDefaults(name, false);
            }
            case VALUE_NULL: {
                return new ScalarDefaults.NullDefaults(name);
            }
            case VALUE_NUMBER_FLOAT: {
                switch (defaultAsNode.numberType()) {
                    case FLOAT: {
                        return new ScalarDefaults.FloatDefaults(name, (float)defaultAsNode.asDouble());
                    }
                }
                return new ScalarDefaults.DoubleDefaults(name, defaultAsNode.asDouble());
            }
            case VALUE_NUMBER_INT: {
                switch (defaultAsNode.numberType()) {
                    case INT: {
                        return new ScalarDefaults.FloatDefaults(name, defaultAsNode.asInt());
                    }
                }
                return new ScalarDefaults.FloatDefaults(name, defaultAsNode.asLong());
            }
            case VALUE_STRING: {
                return new ScalarDefaults.StringDefaults(name, defaultAsNode.asString());
            }
            case START_OBJECT: {
                ArrayList<AvroFieldReader> readers = new ArrayList<AvroFieldReader>();
                for (Map.Entry entry : defaultAsNode.properties()) {
                    readers.add(AvroFieldDefaulters.createDefaulter((String)entry.getKey(), (JsonNode)entry.getValue()));
                }
                return StructDefaults.createObjectDefaults(name, readers);
            }
            case START_ARRAY: {
                ArrayList<AvroFieldReader> readers = new ArrayList<AvroFieldReader>();
                for (JsonNode value : defaultAsNode) {
                    readers.add(AvroFieldDefaulters.createDefaulter("", value));
                }
                return StructDefaults.createArrayDefaults(name, readers);
            }
        }
        return null;
    }
}

