/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.avro.apacheimpl;

import java.lang.ref.SoftReference;
import tools.jackson.core.util.RecyclerPool;
import tools.jackson.dataformat.avro.apacheimpl.ApacheCodecRecycler;

public final class AvroRecyclerPools {
    public static RecyclerPool<ApacheCodecRecycler> defaultPool() {
        return AvroRecyclerPools.newConcurrentDequePool();
    }

    public static RecyclerPool<ApacheCodecRecycler> threadLocalPool() {
        return ThreadLocalPool.GLOBAL;
    }

    public static RecyclerPool<ApacheCodecRecycler> nonRecyclingPool() {
        return NonRecyclingPool.GLOBAL;
    }

    public static RecyclerPool<ApacheCodecRecycler> sharedConcurrentDequePool() {
        return ConcurrentDequePool.GLOBAL;
    }

    public static RecyclerPool<ApacheCodecRecycler> newConcurrentDequePool() {
        return ConcurrentDequePool.construct();
    }

    public static RecyclerPool<ApacheCodecRecycler> sharedBoundedPool() {
        return BoundedPool.GLOBAL;
    }

    public static RecyclerPool<ApacheCodecRecycler> newBoundedPool(int size) {
        return BoundedPool.construct(size);
    }

    public static class ThreadLocalPool
    extends RecyclerPool.ThreadLocalPoolBase<ApacheCodecRecycler> {
        private static final long serialVersionUID = 1L;
        protected static final ThreadLocalPool GLOBAL = new ThreadLocalPool();
        protected static final ThreadLocal<SoftReference<ApacheCodecRecycler>> _recycler = new ThreadLocal();

        private ThreadLocalPool() {
        }

        public ApacheCodecRecycler acquirePooled() {
            ApacheCodecRecycler r;
            SoftReference<ApacheCodecRecycler> ref = _recycler.get();
            ApacheCodecRecycler apacheCodecRecycler = r = ref == null ? null : ref.get();
            if (r == null) {
                r = new ApacheCodecRecycler();
                _recycler.set(new SoftReference<ApacheCodecRecycler>(r));
            }
            return r;
        }

        protected Object readResolve() {
            return GLOBAL;
        }
    }

    public static class NonRecyclingPool
    extends RecyclerPool.NonRecyclingPoolBase<ApacheCodecRecycler> {
        private static final long serialVersionUID = 1L;
        protected static final NonRecyclingPool GLOBAL = new NonRecyclingPool();

        protected NonRecyclingPool() {
        }

        public ApacheCodecRecycler acquirePooled() {
            return new ApacheCodecRecycler();
        }

        protected Object readResolve() {
            return GLOBAL;
        }
    }

    public static class ConcurrentDequePool
    extends RecyclerPool.ConcurrentDequePoolBase<ApacheCodecRecycler> {
        private static final long serialVersionUID = 1L;
        protected static final ConcurrentDequePool GLOBAL = new ConcurrentDequePool(-1);

        protected ConcurrentDequePool(int serialization) {
            super(serialization);
        }

        public static ConcurrentDequePool construct() {
            return new ConcurrentDequePool(1);
        }

        public ApacheCodecRecycler createPooled() {
            return new ApacheCodecRecycler();
        }

        protected Object readResolve() {
            return this._resolveToShared((RecyclerPool.StatefulImplBase)GLOBAL).orElseGet(() -> ConcurrentDequePool.construct());
        }
    }

    public static class BoundedPool
    extends RecyclerPool.BoundedPoolBase<ApacheCodecRecycler> {
        private static final long serialVersionUID = 1L;
        protected static final BoundedPool GLOBAL = new BoundedPool(-1);

        protected BoundedPool(int capacityAsId) {
            super(capacityAsId);
        }

        public static BoundedPool construct(int capacity) {
            if (capacity <= 0) {
                throw new IllegalArgumentException("capacity must be > 0, was: " + capacity);
            }
            return new BoundedPool(capacity);
        }

        public ApacheCodecRecycler createPooled() {
            return new ApacheCodecRecycler();
        }

        protected Object readResolve() {
            return this._resolveToShared((RecyclerPool.StatefulImplBase)GLOBAL).orElseGet(() -> BoundedPool.construct(this._serialization));
        }
    }
}

