/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.avro.deser;

import java.io.IOException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.exc.StreamReadException;
import tools.jackson.core.sym.PropertyNameMatcher;
import tools.jackson.dataformat.avro.deser.AvroParserImpl;
import tools.jackson.dataformat.avro.deser.AvroReadContext;
import tools.jackson.dataformat.avro.deser.AvroStructureReader;

final class UnionReader
extends AvroStructureReader {
    private final AvroStructureReader[] _memberReaders;
    private final AvroParserImpl _parser;

    public UnionReader(AvroStructureReader[] memberReaders) {
        this(null, memberReaders, null);
    }

    private UnionReader(AvroReadContext parent, AvroStructureReader[] memberReaders, AvroParserImpl parser) {
        super(parent, 0, null);
        this._memberReaders = memberReaders;
        this._parser = parser;
        if (parser != null) {
            parser.streamReadConstraints().validateNestingDepth(this._nestingDepth);
        }
    }

    @Override
    public UnionReader newReader(AvroReadContext parent, AvroParserImpl parser) {
        return new UnionReader(parent, this._memberReaders, parser);
    }

    @Override
    public JsonToken nextToken() throws IOException {
        int index = this._parser.decodeIndex();
        AvroStructureReader reader = this._memberReaders[index].newReader(this._parent, this._parser);
        this._currToken = reader.nextToken();
        return this._currToken;
    }

    @Override
    public void skipValue(AvroParserImpl parser) throws IOException {
        int index = this._decodeIndex(parser.decodeIndex());
        this._memberReaders[index].skipValue(parser);
    }

    @Override
    public String nextName() throws IOException {
        this.nextToken();
        return null;
    }

    @Override
    public int nextNameMatch(PropertyNameMatcher matcher) throws IOException {
        this.nextToken();
        return -3;
    }

    @Override
    protected void appendDesc(StringBuilder sb) {
        sb.append('?');
    }

    private final int _decodeIndex(int index) throws IOException {
        if (index < 0 || index >= this._memberReaders.length) {
            throw new StreamReadException((JsonParser)this._parser, String.format("Invalid index (%s); union only has %d types", index, this._memberReaders.length));
        }
        return index;
    }
}

