/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.avro.deser;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.DatabindContext;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.KeyDeserializer;
import tools.jackson.databind.deser.jdk.UntypedObjectDeserializer;
import tools.jackson.databind.jsontype.TypeDeserializer;
import tools.jackson.databind.jsontype.TypeIdResolver;
import tools.jackson.databind.type.TypeFactory;

public class AvroUntypedDeserializer
extends UntypedObjectDeserializer {
    protected TypeDeserializer _typeDeserializer;

    public AvroUntypedDeserializer(JavaType listType, JavaType mapType) {
        super(listType, mapType);
    }

    public static AvroUntypedDeserializer construct(TypeFactory f) {
        return new AvroUntypedDeserializer(f.constructType(List.class), f.constructType(Map.class));
    }

    public void resolve(DeserializationContext ctxt) {
        JavaType obType = ctxt.constructType(Object.class);
        this._typeDeserializer = ctxt.findTypeDeserializer(obType);
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        TypeIdResolver resolver;
        Object typeId;
        if (p.canReadTypeId() && (typeId = p.getTypeId()) != null && this._typeDeserializer != null && (resolver = this._typeDeserializer.getTypeIdResolver()) != null && resolver.typeFromId((DatabindContext)ctxt, typeId.toString()) != null) {
            return this._typeDeserializer.deserializeTypedFromAny(p, ctxt);
        }
        return super.deserialize(p, ctxt);
    }

    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws JacksonException {
        TypeIdResolver resolver;
        Object typeId;
        if (typeDeserializer != null && p.canReadTypeId() && (typeId = p.getTypeId()) != null && (resolver = typeDeserializer.getTypeIdResolver()) != null && resolver.typeFromId((DatabindContext)ctxt, p.getTypeId().toString()) != null) {
            return typeDeserializer.deserializeTypedFromAny(p, ctxt);
        }
        return super.deserializeWithType(p, ctxt, typeDeserializer);
    }

    protected Object mapObject(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        TypeIdResolver idResolver;
        JavaType keyType;
        Object key1;
        JsonToken t = p.currentToken();
        if (t == JsonToken.START_OBJECT) {
            key1 = p.nextName();
        } else if (t == JsonToken.PROPERTY_NAME) {
            key1 = p.currentName();
        } else {
            if (t != JsonToken.END_OBJECT) {
                return ctxt.handleUnexpectedToken(this.getValueType(ctxt), p);
            }
            key1 = null;
        }
        if (key1 == null) {
            return new LinkedHashMap(2);
        }
        KeyDeserializer deserializer = null;
        if (p.getTypeId() != null && this._typeDeserializer != null && (keyType = (idResolver = this._typeDeserializer.getTypeIdResolver()).typeFromId((DatabindContext)ctxt, p.getTypeId().toString())) != null) {
            deserializer = ctxt.findKeyDeserializer(keyType, null);
        }
        if (deserializer != null) {
            key1 = deserializer.deserializeKey(key1.toString(), ctxt);
        }
        p.nextToken();
        Object value1 = this.deserialize(p, ctxt);
        Object key2 = p.nextName();
        if (key2 == null) {
            LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>(2);
            result.put(key1, value1);
            return result;
        }
        if (deserializer != null) {
            key2 = deserializer.deserializeKey(key2.toString(), ctxt);
        }
        p.nextToken();
        Object value2 = this.deserialize(p, ctxt);
        Object key = p.nextName();
        if (key == null) {
            LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>(4);
            result.put(key1, value1);
            result.put(key2, value2);
            return result;
        }
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
        result.put(key1, value1);
        result.put(key2, value2);
        do {
            if (deserializer != null) {
                key = deserializer.deserializeKey(key.toString(), ctxt);
            }
            p.nextToken();
            result.put(key, this.deserialize(p, ctxt));
        } while ((key = p.nextName()) != null);
        return result;
    }
}

