/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.avro.deser;

import java.io.IOException;
import tools.jackson.core.JsonToken;
import tools.jackson.core.sym.PropertyNameMatcher;
import tools.jackson.dataformat.avro.deser.AvroParserImpl;
import tools.jackson.dataformat.avro.deser.AvroReadContext;
import tools.jackson.dataformat.avro.deser.AvroStructureReader;
import tools.jackson.dataformat.avro.deser.ScalarDecoder;

public abstract class ArrayReader
extends AvroStructureReader {
    protected static final int STATE_START = 0;
    protected static final int STATE_ELEMENTS = 1;
    protected static final int STATE_END = 2;
    protected static final int STATE_DONE = 3;
    protected final AvroParserImpl _parser;
    protected final String _elementTypeId;
    protected int _state;
    protected long _count;
    protected String _currentName;

    protected ArrayReader(AvroReadContext parent, AvroParserImpl parser, String typeId, String elementTypeId) {
        super(parent, 1, typeId);
        this._parser = parser;
        this._elementTypeId = elementTypeId;
        if (parser != null) {
            parser.streamReadConstraints().validateNestingDepth(this._nestingDepth);
        }
    }

    public static ArrayReader construct(ScalarDecoder reader, String typeId, String elementTypeId) {
        return new Scalar(reader, typeId, elementTypeId);
    }

    public static ArrayReader construct(AvroStructureReader reader, String typeId, String elementTypeId) {
        return new NonScalar(reader, typeId, elementTypeId);
    }

    @Override
    public String nextName() throws IOException {
        this.nextToken();
        return null;
    }

    @Override
    public int nextNameMatch(PropertyNameMatcher matcher) throws IOException {
        this.nextToken();
        return -3;
    }

    @Override
    public String currentName() {
        if (this._currentName == null) {
            this._currentName = this._parent.currentName();
        }
        return this._currentName;
    }

    @Override
    protected void appendDesc(StringBuilder sb) {
        sb.append('[');
        sb.append(this.getCurrentIndex());
        sb.append(']');
    }

    @Override
    public long getRemainingElements() {
        return this._count - (long)this._index;
    }

    @Override
    public String getTypeId() {
        return this._currToken != JsonToken.START_ARRAY && this._currToken != JsonToken.END_ARRAY ? this._elementTypeId : super.getTypeId();
    }

    private static final class Scalar
    extends ArrayReader {
        private final ScalarDecoder _elementReader;

        public Scalar(ScalarDecoder reader, String typeId, String elementTypeId) {
            this(null, reader, null, typeId, elementTypeId != null ? elementTypeId : reader.getTypeId());
        }

        private Scalar(AvroReadContext parent, ScalarDecoder reader, AvroParserImpl parser, String typeId, String elementTypeId) {
            super(parent, parser, typeId, elementTypeId != null ? elementTypeId : reader.getTypeId());
            this._elementReader = reader;
        }

        @Override
        public Scalar newReader(AvroReadContext parent, AvroParserImpl parser) {
            return new Scalar(parent, this._elementReader, parser, this._typeId, this._elementTypeId);
        }

        @Override
        public JsonToken nextToken() throws IOException {
            JsonToken t;
            switch (this._state) {
                case 0: {
                    this._parser.setAvroContext(this);
                    this._index = 0;
                    this._count = this._parser.decodeArrayStart();
                    this._state = this._count > 0L ? 1 : 2;
                    this._currToken = JsonToken.START_ARRAY;
                    return this._currToken;
                }
                case 1: {
                    if ((long)this._index < this._count) break;
                    this._count = this._parser.decodeArrayNext();
                    if (this._count > 0L) {
                        this._index = 0;
                        break;
                    }
                }
                case 2: {
                    this._state = 3;
                    this._parser.setAvroContext(this.getParent());
                    this._currToken = JsonToken.END_ARRAY;
                    return this._currToken;
                }
                default: {
                    this.throwIllegalState(this._state);
                    return null;
                }
            }
            ++this._index;
            this._currToken = t = this._elementReader.decodeValue(this._parser);
            return t;
        }

        @Override
        public void skipValue(AvroParserImpl parser) throws IOException {
            long l;
            while ((l = parser.skipArray()) > 0L) {
                while (--l >= 0L) {
                    this._elementReader.skipValue(parser);
                }
            }
        }
    }

    private static final class NonScalar
    extends ArrayReader {
        private final AvroStructureReader _elementReader;

        public NonScalar(AvroStructureReader reader, String typeId, String elementTypeId) {
            this(null, reader, null, typeId, elementTypeId);
        }

        private NonScalar(AvroReadContext parent, AvroStructureReader reader, AvroParserImpl parser, String typeId, String elementTypeId) {
            super(parent, parser, typeId, elementTypeId);
            this._elementReader = reader;
        }

        @Override
        public NonScalar newReader(AvroReadContext parent, AvroParserImpl parser) {
            return new NonScalar(parent, this._elementReader, parser, this._typeId, this._elementTypeId);
        }

        @Override
        public JsonToken nextToken() throws IOException {
            switch (this._state) {
                case 0: {
                    this._parser.setAvroContext(this);
                    this._count = this._parser.decodeArrayStart();
                    this._state = this._count > 0L ? 1 : 2;
                    this._currToken = JsonToken.START_ARRAY;
                    return this._currToken;
                }
                case 1: {
                    if ((long)this._index < this._count) break;
                    this._count = this._parser.decodeArrayNext();
                    if (this._count > 0L) {
                        this._index = 0;
                        break;
                    }
                }
                case 2: {
                    this._state = 3;
                    this._parser.setAvroContext(this.getParent());
                    this._currToken = JsonToken.END_ARRAY;
                    return this._currToken;
                }
                default: {
                    this.throwIllegalState(this._state);
                }
            }
            ++this._index;
            AvroStructureReader r = this._elementReader.newReader(this, this._parser);
            this._parser.setAvroContext(r);
            this._currToken = r.nextToken();
            return this._currToken;
        }

        @Override
        public void skipValue(AvroParserImpl parser) throws IOException {
            long l;
            while ((l = parser.skipArray()) > 0L) {
                while (--l >= 0L) {
                    this._elementReader.skipValue(parser);
                }
            }
        }
    }
}

