/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.PropertyMetadata;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.cfg.MapperConfig;
import tools.jackson.databind.introspect.AnnotatedField;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.introspect.AnnotatedMethod;
import tools.jackson.databind.introspect.AnnotatedParameter;
import tools.jackson.databind.introspect.BeanPropertyDefinition;
import tools.jackson.databind.type.TypeFactory;
import tools.jackson.databind.util.ClassUtil;

public class SimpleBeanPropertyDefinition
extends BeanPropertyDefinition {
    protected final MapperConfig<?> _config;
    protected final AnnotatedMember _member;
    protected final PropertyMetadata _metadata;
    protected final PropertyName _fullName;
    protected final JsonInclude.Value _inclusion;

    protected SimpleBeanPropertyDefinition(MapperConfig<?> config, AnnotatedMember member, PropertyName fullName, PropertyMetadata metadata, JsonInclude.Value inclusion) {
        this._config = config;
        this._member = member;
        this._fullName = fullName;
        this._metadata = metadata == null ? PropertyMetadata.STD_OPTIONAL : metadata;
        this._inclusion = inclusion;
    }

    public static SimpleBeanPropertyDefinition construct(MapperConfig<?> config, AnnotatedMember member) {
        return new SimpleBeanPropertyDefinition(config, member, PropertyName.construct(member.getName()), null, EMPTY_INCLUDE);
    }

    public static SimpleBeanPropertyDefinition construct(MapperConfig<?> config, AnnotatedMember member, PropertyName name) {
        return SimpleBeanPropertyDefinition.construct(config, member, name, null, EMPTY_INCLUDE);
    }

    public static SimpleBeanPropertyDefinition construct(MapperConfig<?> config, AnnotatedMember member, PropertyName name, PropertyMetadata metadata, JsonInclude.Include inclusion) {
        JsonInclude.Value inclValue = inclusion == null || inclusion == JsonInclude.Include.USE_DEFAULTS ? EMPTY_INCLUDE : JsonInclude.Value.construct((JsonInclude.Include)inclusion, null);
        return new SimpleBeanPropertyDefinition(config, member, name, metadata, inclValue);
    }

    public static SimpleBeanPropertyDefinition construct(MapperConfig<?> config, AnnotatedMember member, PropertyName name, PropertyMetadata metadata, JsonInclude.Value inclusion) {
        return new SimpleBeanPropertyDefinition(config, member, name, metadata, inclusion);
    }

    @Override
    public BeanPropertyDefinition withSimpleName(String newName) {
        if (this._fullName.hasSimpleName(newName) && !this._fullName.hasNamespace()) {
            return this;
        }
        return new SimpleBeanPropertyDefinition(this._config, this._member, new PropertyName(newName), this._metadata, this._inclusion);
    }

    @Override
    public BeanPropertyDefinition withName(PropertyName newName) {
        if (this._fullName.equals(newName)) {
            return this;
        }
        return new SimpleBeanPropertyDefinition(this._config, this._member, newName, this._metadata, this._inclusion);
    }

    public BeanPropertyDefinition withMetadata(PropertyMetadata metadata) {
        if (metadata.equals(this._metadata)) {
            return this;
        }
        return new SimpleBeanPropertyDefinition(this._config, this._member, this._fullName, metadata, this._inclusion);
    }

    public BeanPropertyDefinition withInclusion(JsonInclude.Value inclusion) {
        if (this._inclusion == inclusion) {
            return this;
        }
        return new SimpleBeanPropertyDefinition(this._config, this._member, this._fullName, this._metadata, inclusion);
    }

    public String getName() {
        return this._fullName.getSimpleName();
    }

    @Override
    public PropertyName getFullName() {
        return this._fullName;
    }

    @Override
    public boolean hasName(PropertyName name) {
        return this._fullName.equals(name);
    }

    @Override
    public String getInternalName() {
        return this.getName();
    }

    @Override
    public PropertyName getWrapperName() {
        AnnotationIntrospector intr;
        if (this._member != null && (intr = this._config.getAnnotationIntrospector()) != null) {
            return intr.findWrapperName(this._config, this._member);
        }
        return null;
    }

    @Override
    public boolean isExplicitlyIncluded() {
        return false;
    }

    @Override
    public boolean isExplicitlyNamed() {
        return false;
    }

    @Override
    public PropertyMetadata getMetadata() {
        return this._metadata;
    }

    @Override
    public JavaType getPrimaryType() {
        if (this._member == null) {
            return TypeFactory.unknownType();
        }
        return this._member.getType();
    }

    @Override
    public Class<?> getRawPrimaryType() {
        if (this._member == null) {
            return Object.class;
        }
        return this._member.getRawType();
    }

    @Override
    public JsonInclude.Value findInclusion() {
        return this._inclusion;
    }

    @Override
    public List<PropertyName> findAliases() {
        List<PropertyName> propertyNames;
        AnnotationIntrospector intr;
        if (this._member != null && (intr = this._config.getAnnotationIntrospector()) != null && (propertyNames = intr.findPropertyAliases(this._config, this._member)) != null) {
            return propertyNames;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean hasGetter() {
        return this.getGetter() != null;
    }

    @Override
    public boolean hasSetter() {
        return this.getSetter() != null;
    }

    @Override
    public boolean hasField() {
        return this._member instanceof AnnotatedField;
    }

    @Override
    public boolean hasConstructorParameter() {
        return this._member instanceof AnnotatedParameter;
    }

    @Override
    public AnnotatedMethod getGetter() {
        AnnotatedMethod am;
        AnnotatedMember annotatedMember = this._member;
        if (annotatedMember instanceof AnnotatedMethod && (am = (AnnotatedMethod)annotatedMember).getParameterCount() == 0) {
            return am;
        }
        return null;
    }

    @Override
    public AnnotatedMethod getSetter() {
        AnnotatedMethod method;
        AnnotatedMember annotatedMember = this._member;
        if (annotatedMember instanceof AnnotatedMethod && (method = (AnnotatedMethod)annotatedMember).getParameterCount() == 1) {
            return method;
        }
        return null;
    }

    @Override
    public AnnotatedField getField() {
        AnnotatedField field;
        AnnotatedMember annotatedMember = this._member;
        return annotatedMember instanceof AnnotatedField ? (field = (AnnotatedField)annotatedMember) : null;
    }

    @Override
    public AnnotatedParameter getConstructorParameter() {
        AnnotatedParameter ap;
        AnnotatedMember annotatedMember = this._member;
        return annotatedMember instanceof AnnotatedParameter ? (ap = (AnnotatedParameter)annotatedMember) : null;
    }

    @Override
    public Iterator<AnnotatedParameter> getConstructorParameters() {
        AnnotatedParameter param = this.getConstructorParameter();
        if (param == null) {
            return ClassUtil.emptyIterator();
        }
        return Collections.singleton(param).iterator();
    }

    @Override
    public AnnotatedMember getPrimaryMember() {
        return this._member;
    }
}

