/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.util;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import tools.jackson.core.SerializableString;
import tools.jackson.databind.EnumNamingStrategy;
import tools.jackson.databind.cfg.EnumFeature;
import tools.jackson.databind.cfg.MapperConfig;
import tools.jackson.databind.introspect.AnnotatedClass;

public class EnumValuesToWrite {
    private final AnnotatedClass _annotatedClass;
    private final EnumNamingStrategy _enumNamingStrategy;
    private final Enum<?>[] _enumConstants;
    private final SerializableString[] _explicitNames;
    private volatile SerializableString[] _enumNames;
    private volatile SerializableString[] _enumNamesLC;
    private volatile SerializableString[] _enumToStrings;
    private volatile SerializableString[] _enumToStringsLC;

    private EnumValuesToWrite(AnnotatedClass annotatedClass, EnumNamingStrategy enumNamingStrategy, Enum<?>[] enumConstants, SerializableString[] explicitNames) {
        this._annotatedClass = annotatedClass;
        this._enumNamingStrategy = enumNamingStrategy;
        this._enumConstants = enumConstants;
        this._explicitNames = explicitNames;
    }

    public static EnumValuesToWrite construct(MapperConfig<?> config, AnnotatedClass annotatedClass, EnumNamingStrategy enumNamingStrategy, Enum<?>[] enumConstants, String[] explicitNames0) {
        int len = explicitNames0.length;
        SerializableString[] explicitNames = new SerializableString[len];
        for (int i = 0; i < len; ++i) {
            explicitNames[i] = config.compileString(explicitNames0[i]);
        }
        return new EnumValuesToWrite(annotatedClass, enumNamingStrategy, enumConstants, explicitNames);
    }

    public Class<Enum<?>> enumClass() {
        Class<Enum<?>> cls = this._annotatedClass.getRawType();
        return cls;
    }

    public List<Enum<?>> enums() {
        return Arrays.asList(this._enumConstants);
    }

    public SerializableString enumValueFromName(MapperConfig<?> config, Enum<?> en) {
        return this.allEnumValuesFromName(config)[en.ordinal()];
    }

    public SerializableString[] allEnumValuesFromName(MapperConfig<?> config) {
        SerializableString[] strs;
        if (config.isEnabled(EnumFeature.WRITE_ENUMS_TO_LOWERCASE)) {
            strs = this._enumNamesLC;
            if (this._enumNamesLC == null) {
                this._enumNamesLC = strs = this._fetch(config, e -> this._nameWithStrategy(config, (Enum<?>)e), true);
            }
        } else {
            strs = this._enumNames;
            if (this._enumNames == null) {
                strs = this._fetch(config, e -> this._nameWithStrategy(config, (Enum<?>)e), false);
                this._enumNames = strs;
            }
        }
        return strs;
    }

    public SerializableString enumValueFromToString(MapperConfig<?> config, Enum<?> en) {
        return this.allEnumValuesFromToString(config)[en.ordinal()];
    }

    public SerializableString[] allEnumValuesFromToString(MapperConfig<?> config) {
        SerializableString[] strs;
        if (config.isEnabled(EnumFeature.WRITE_ENUMS_TO_LOWERCASE)) {
            strs = this._enumToStringsLC;
            if (this._enumToStringsLC == null) {
                this._enumToStringsLC = strs = this._fetch(config, e -> this._toStringWithStrategy(config, (Enum<?>)e), true);
            }
        } else {
            strs = this._enumToStrings;
            if (this._enumToStrings == null) {
                strs = this._fetch(config, e -> this._toStringWithStrategy(config, (Enum<?>)e), false);
                this._enumToStrings = strs;
            }
        }
        return strs;
    }

    private String _nameWithStrategy(MapperConfig<?> config, Enum<?> en) {
        String str = en.name();
        if (this._enumNamingStrategy != null) {
            str = this._enumNamingStrategy.convertEnumToExternalName(config, this._annotatedClass, str);
        }
        return str;
    }

    private String _toStringWithStrategy(MapperConfig<?> config, Enum<?> en) {
        String str = en.toString();
        if (this._enumNamingStrategy != null) {
            str = this._enumNamingStrategy.convertEnumToExternalName(config, this._annotatedClass, str);
        }
        return str;
    }

    private SerializableString[] _fetch(MapperConfig<?> config, Function<Enum<?>, String> accessor, boolean lowerCase) {
        int len = this._enumConstants.length;
        SerializableString[] serStrs = new SerializableString[this._enumConstants.length];
        for (int i = 0; i < len; ++i) {
            SerializableString ser = this._explicitNames[i];
            if (ser == null) {
                String str = accessor.apply(this._enumConstants[i]);
                if (lowerCase) {
                    str = str.toLowerCase();
                }
                ser = config.compileString(str);
            }
            serStrs[i] = ser;
        }
        return serStrs;
    }
}

