/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.IdentityHashMap;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.exc.JacksonIOException;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DatabindException;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import tools.jackson.databind.jsonFormatVisitors.JsonNumberFormatVisitor;
import tools.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import tools.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import tools.jackson.databind.node.JsonNodeFactory;
import tools.jackson.databind.node.ObjectNode;
import tools.jackson.databind.ser.FilterProvider;
import tools.jackson.databind.ser.PropertyFilter;
import tools.jackson.databind.ser.std.StdDelegatingSerializer;
import tools.jackson.databind.util.ClassUtil;
import tools.jackson.databind.util.Converter;

public abstract class StdSerializer<T>
extends ValueSerializer<T>
implements JsonFormatVisitable {
    private static final Object KEY_CONTENT_CONVERTER_LOCK = new Object();
    protected final Class<?> _handledType;

    protected StdSerializer(Class<?> t) {
        this._handledType = t;
    }

    protected StdSerializer(JavaType type) {
        this._handledType = type.getRawClass();
    }

    @Deprecated
    protected StdSerializer(Class<?> t, boolean dummy) {
        this._handledType = t;
    }

    protected StdSerializer(StdSerializer<?> src) {
        this._handledType = src._handledType;
    }

    @Override
    public Class<?> handledType() {
        return this._handledType;
    }

    @Override
    public abstract void serialize(T var1, JsonGenerator var2, SerializationContext var3) throws JacksonException;

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
        visitor.expectAnyFormat(typeHint);
    }

    protected void acceptJsonFormatVisitorForBinary(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }

    protected ObjectNode createSchemaNode(String type) {
        ObjectNode schema = JsonNodeFactory.instance.objectNode();
        schema.put("type", type);
        return schema;
    }

    protected ObjectNode createSchemaNode(String type, boolean isOptional) {
        ObjectNode schema = this.createSchemaNode(type);
        if (!isOptional) {
            schema.put("required", true);
        }
        return schema;
    }

    protected void visitStringFormat(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
        visitor.expectStringFormat(typeHint);
    }

    protected void visitStringFormat(JsonFormatVisitorWrapper visitor, JavaType typeHint, JsonValueFormat format) {
        JsonStringFormatVisitor v2 = visitor.expectStringFormat(typeHint);
        if (v2 != null) {
            v2.format(format);
        }
    }

    protected void visitIntFormat(JsonFormatVisitorWrapper visitor, JavaType typeHint, JsonParser.NumberType numberType) {
        JsonIntegerFormatVisitor v2 = visitor.expectIntegerFormat(typeHint);
        if (StdSerializer._neitherNull(v2, numberType)) {
            v2.numberType(numberType);
        }
    }

    protected void visitIntFormat(JsonFormatVisitorWrapper visitor, JavaType typeHint, JsonParser.NumberType numberType, JsonValueFormat format) {
        JsonIntegerFormatVisitor v2 = visitor.expectIntegerFormat(typeHint);
        if (v2 != null) {
            if (numberType != null) {
                v2.numberType(numberType);
            }
            if (format != null) {
                v2.format(format);
            }
        }
    }

    protected void visitFloatFormat(JsonFormatVisitorWrapper visitor, JavaType typeHint, JsonParser.NumberType numberType) {
        JsonNumberFormatVisitor v2 = visitor.expectNumberFormat(typeHint);
        if (v2 != null) {
            v2.numberType(numberType);
        }
    }

    protected void visitArrayFormat(JsonFormatVisitorWrapper visitor, JavaType typeHint, ValueSerializer<?> itemSerializer, JavaType itemType) {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (StdSerializer._neitherNull(v2, itemSerializer)) {
            v2.itemsFormat(itemSerializer, itemType);
        }
    }

    protected void visitArrayFormat(JsonFormatVisitorWrapper visitor, JavaType typeHint, JsonFormatTypes itemType) {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(itemType);
        }
    }

    public void wrapAndThrow(SerializationContext ctxt, Throwable t, Object bean, String fieldName) throws JacksonException {
        while (t instanceof InvocationTargetException && t.getCause() != null) {
            t = t.getCause();
        }
        while (t instanceof JacksonIOException && t.getCause() != null) {
            t = t.getCause();
        }
        ClassUtil.throwIfError(t);
        if (!(t instanceof JacksonException)) {
            boolean wrap;
            boolean bl = wrap = ctxt == null || ctxt.isEnabled(SerializationFeature.WRAP_EXCEPTIONS);
            if (!wrap) {
                ClassUtil.throwIfRTE(t);
            }
        }
        throw DatabindException.wrapWithPath(ctxt, t, new JacksonException.Reference(bean, fieldName));
    }

    public void wrapAndThrow(SerializationContext ctxt, Throwable t, Object bean, int index) throws JacksonException {
        while (t instanceof InvocationTargetException && t.getCause() != null) {
            t = t.getCause();
        }
        while (t instanceof JacksonIOException && t.getCause() != null) {
            t = t.getCause();
        }
        ClassUtil.throwIfError(t);
        if (!(t instanceof JacksonException)) {
            boolean wrap;
            boolean bl = wrap = ctxt == null || ctxt.isEnabled(SerializationFeature.WRAP_EXCEPTIONS);
            if (!wrap) {
                ClassUtil.throwIfRTE(t);
            }
        }
        throw DatabindException.wrapWithPath(ctxt, t, new JacksonException.Reference(bean, index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ValueSerializer<?> findContextualConvertingSerializer(SerializationContext ctxt, BeanProperty prop, ValueSerializer<?> existingSerializer) {
        IdentityHashMap<BeanProperty, Boolean> conversions = (IdentityHashMap<BeanProperty, Boolean>)ctxt.getAttribute(KEY_CONTENT_CONVERTER_LOCK);
        if (conversions != null) {
            Object lock = conversions.get(prop);
            if (lock != null) {
                return existingSerializer;
            }
        } else {
            conversions = new IdentityHashMap<BeanProperty, Boolean>();
            ctxt.setAttribute(KEY_CONTENT_CONVERTER_LOCK, conversions);
        }
        AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
        if (StdSerializer._neitherNull(intr, prop)) {
            conversions.put(prop, Boolean.TRUE);
            try {
                ValueSerializer<?> ser = this._findConvertingContentSerializer(ctxt, intr, prop, existingSerializer);
                if (ser != null) {
                    ValueSerializer<Object> valueSerializer = ctxt.handleSecondaryContextualization(ser, prop);
                    return valueSerializer;
                }
            }
            finally {
                conversions.remove(prop);
            }
        }
        return existingSerializer;
    }

    private ValueSerializer<?> _findConvertingContentSerializer(SerializationContext ctxt, AnnotationIntrospector intr, BeanProperty prop, ValueSerializer<?> existingSerializer) {
        Object convDef;
        AnnotatedMember m = prop.getMember();
        if (m != null && (convDef = intr.findSerializationContentConverter(ctxt.getConfig(), m)) != null) {
            Converter<Object, Object> conv = ctxt.converterInstance(prop.getMember(), convDef);
            JavaType delegateType = conv.getOutputType(ctxt.getTypeFactory());
            if (existingSerializer == null && !delegateType.isJavaLangObject()) {
                existingSerializer = ctxt.findValueSerializer(delegateType);
            }
            return new StdDelegatingSerializer(conv, delegateType, existingSerializer, prop);
        }
        return existingSerializer;
    }

    protected PropertyFilter findPropertyFilter(SerializationContext ctxt, Object filterId, Object valueToFilter) {
        FilterProvider filters = ctxt.getFilterProvider();
        if (filters == null) {
            return (PropertyFilter)ctxt.reportBadDefinition(this.handledType(), "Cannot resolve PropertyFilter with id '" + String.valueOf(filterId) + "'; no FilterProvider configured");
        }
        return filters.findPropertyFilter(ctxt, filterId, valueToFilter);
    }

    protected JsonFormat.Value findFormatOverrides(SerializationContext ctxt, BeanProperty prop, Class<?> typeForDefaults) {
        if (prop != null) {
            return prop.findPropertyFormat(ctxt.getConfig(), typeForDefaults);
        }
        return ctxt.getDefaultPropertyFormat(typeForDefaults);
    }

    protected Boolean findFormatFeature(SerializationContext ctxt, BeanProperty prop, Class<?> typeForDefaults, JsonFormat.Feature feat) {
        JsonFormat.Value format = this.findFormatOverrides(ctxt, prop, typeForDefaults);
        if (format != null) {
            return format.getFeature(feat);
        }
        return null;
    }

    protected JsonInclude.Value findIncludeOverrides(SerializationContext ctxt, BeanProperty prop, Class<?> typeForDefaults) {
        if (prop != null) {
            return prop.findPropertyInclusion(ctxt.getConfig(), typeForDefaults);
        }
        return ctxt.getDefaultPropertyInclusion(typeForDefaults);
    }

    protected ValueSerializer<?> findAnnotatedContentSerializer(SerializationContext ctxt, BeanProperty property) {
        if (property != null) {
            AnnotatedMember m = property.getMember();
            AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
            if (m != null) {
                return ctxt.serializerInstance(m, intr.findContentSerializer(ctxt.getConfig(), m));
            }
        }
        return null;
    }

    protected boolean isDefaultSerializer(ValueSerializer<?> serializer) {
        return ClassUtil.isJacksonStdImpl(serializer);
    }

    protected static final boolean _neitherNull(Object a, Object b) {
        return a != null && b != null;
    }

    protected static final boolean _nonEmpty(Collection<?> c) {
        return c != null && !c.isEmpty();
    }

    protected JacksonException _wrapIOFailure(SerializationContext ctxt, IOException e) {
        return JacksonIOException.construct((IOException)e, (Closeable)ctxt.getGenerator());
    }
}

