/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.std;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import tools.jackson.databind.ser.AnyGetterWriter;
import tools.jackson.databind.ser.BeanPropertyWriter;
import tools.jackson.databind.ser.PropertyFilter;
import tools.jackson.databind.ser.PropertyWriter;

public class SimpleBeanPropertyFilter
implements PropertyFilter {
    protected SimpleBeanPropertyFilter() {
    }

    public PropertyFilter snapshot() {
        return this;
    }

    public static SimpleBeanPropertyFilter serializeAll() {
        return SerializeExceptFilter.INCLUDE_ALL;
    }

    public static SimpleBeanPropertyFilter filterOutAll() {
        return FilterExceptFilter.EXCLUDE_ALL;
    }

    public static SimpleBeanPropertyFilter filterOutAllExcept(Set<String> properties) {
        return new FilterExceptFilter(properties);
    }

    public static SimpleBeanPropertyFilter filterOutAllExcept(String ... propertyArray) {
        HashSet<String> properties = new HashSet<String>(propertyArray.length);
        Collections.addAll(properties, propertyArray);
        return new FilterExceptFilter(properties);
    }

    public static SimpleBeanPropertyFilter serializeAllExcept(Set<String> properties) {
        return new SerializeExceptFilter(properties);
    }

    public static SimpleBeanPropertyFilter serializeAllExcept(String ... propertyArray) {
        HashSet<String> properties = new HashSet<String>(propertyArray.length);
        Collections.addAll(properties, propertyArray);
        return new SerializeExceptFilter(properties);
    }

    protected boolean include(BeanPropertyWriter writer) {
        return true;
    }

    protected boolean include(PropertyWriter writer) {
        return true;
    }

    protected boolean includeElement(Object elementValue) {
        return true;
    }

    @Override
    public void serializeAsProperty(Object pojo, JsonGenerator g, SerializationContext provider, PropertyWriter writer) throws Exception {
        if (this.include(writer)) {
            writer.serializeAsProperty(pojo, g, provider);
        } else if (!g.canOmitProperties()) {
            writer.serializeAsOmittedProperty(pojo, g, provider);
        } else if (writer instanceof AnyGetterWriter) {
            AnyGetterWriter anyGetterWriter = (AnyGetterWriter)writer;
            anyGetterWriter.getAndFilter(pojo, g, provider, this);
        }
    }

    @Override
    public void serializeAsElement(Object elementValue, JsonGenerator g, SerializationContext provider, PropertyWriter writer) throws Exception {
        if (this.includeElement(elementValue)) {
            writer.serializeAsElement(elementValue, g, provider);
        }
    }

    @Override
    public void depositSchemaProperty(PropertyWriter writer, JsonObjectFormatVisitor objectVisitor, SerializationContext provider) {
        if (this.include(writer)) {
            writer.depositSchemaProperty(objectVisitor, provider);
        }
    }

    public static class SerializeExceptFilter
    extends SimpleBeanPropertyFilter
    implements Serializable {
        private static final long serialVersionUID = 1L;
        static final SerializeExceptFilter INCLUDE_ALL = new SerializeExceptFilter(Collections.emptySet());
        protected final Set<String> _propertiesToExclude;

        public SerializeExceptFilter(Set<String> properties) {
            this._propertiesToExclude = properties;
        }

        @Override
        protected boolean include(BeanPropertyWriter writer) {
            return !this._propertiesToExclude.contains(writer.getName());
        }

        @Override
        protected boolean include(PropertyWriter writer) {
            return !this._propertiesToExclude.contains(writer.getName());
        }
    }

    public static class FilterExceptFilter
    extends SimpleBeanPropertyFilter
    implements Serializable {
        private static final long serialVersionUID = 1L;
        static final FilterExceptFilter EXCLUDE_ALL = new FilterExceptFilter(Collections.emptySet());
        protected final Set<String> _propertiesToInclude;

        public FilterExceptFilter(Set<String> properties) {
            this._propertiesToInclude = properties;
        }

        @Override
        protected boolean include(BeanPropertyWriter writer) {
            return this._propertiesToInclude.contains(writer.getName());
        }

        @Override
        protected boolean include(PropertyWriter writer) {
            return this._propertiesToInclude.contains(writer.getName());
        }
    }
}

