/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonToken;
import tools.jackson.core.type.WritableTypeId;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.std.StdContainerSerializer;
import tools.jackson.databind.util.ArrayBuilders;
import tools.jackson.databind.util.BeanUtil;

public abstract class AsArraySerializerBase<T>
extends StdContainerSerializer<T> {
    protected final JavaType _elementType;
    protected final boolean _staticTyping;
    protected static final Object MARKER_FOR_EMPTY = JsonInclude.Include.NON_EMPTY;
    protected final Object _suppressableValue;
    protected final boolean _suppressNulls;
    protected final Boolean _unwrapSingle;
    protected final TypeSerializer _valueTypeSerializer;
    protected final ValueSerializer<Object> _elementSerializer;

    protected AsArraySerializerBase(Class<?> cls, JavaType elementType, boolean staticTyping, TypeSerializer vts, ValueSerializer<?> elementSerializer) {
        this(cls, elementType, staticTyping, vts, elementSerializer, null, null, null, false);
    }

    protected AsArraySerializerBase(Class<?> cls, JavaType elementType, boolean staticTyping, TypeSerializer vts, ValueSerializer<?> elementSerializer, Boolean unwrapSingle) {
        super(cls);
        this._elementType = elementType;
        this._staticTyping = staticTyping || elementType != null && elementType.isFinal();
        this._valueTypeSerializer = vts;
        this._elementSerializer = elementSerializer;
        this._unwrapSingle = unwrapSingle;
        this._suppressableValue = null;
        this._suppressNulls = false;
    }

    @Deprecated
    protected AsArraySerializerBase(Class<?> cls, JavaType elementType, boolean staticTyping, TypeSerializer vts, ValueSerializer<?> elementSerializer, Boolean unwrapSingle, BeanProperty property) {
        this(cls, elementType, staticTyping, vts, elementSerializer, unwrapSingle, property, null, false);
    }

    protected AsArraySerializerBase(Class<?> cls, JavaType elementType, boolean staticTyping, TypeSerializer vts, ValueSerializer<?> elementSerializer, Boolean unwrapSingle, BeanProperty property, Object suppressableValue, boolean suppressNulls) {
        super(cls, property);
        this._elementType = elementType;
        this._staticTyping = staticTyping || elementType != null && elementType.isFinal();
        this._valueTypeSerializer = vts;
        this._elementSerializer = elementSerializer;
        this._unwrapSingle = unwrapSingle;
        this._suppressableValue = suppressableValue;
        this._suppressNulls = suppressNulls;
    }

    @Deprecated
    protected AsArraySerializerBase(AsArraySerializerBase<?> src, TypeSerializer vts, ValueSerializer<?> elementSerializer, Boolean unwrapSingle, BeanProperty property) {
        super(src, property);
        this._elementType = src._elementType;
        this._staticTyping = src._staticTyping;
        this._valueTypeSerializer = vts;
        this._elementSerializer = elementSerializer;
        this._unwrapSingle = unwrapSingle;
        this._suppressableValue = src._suppressableValue;
        this._suppressNulls = src._suppressNulls;
    }

    protected AsArraySerializerBase(AsArraySerializerBase<?> src, TypeSerializer vts, ValueSerializer<?> elementSerializer, Boolean unwrapSingle, BeanProperty property, Object suppressableValue, boolean suppressNulls) {
        super(src, property);
        this._elementType = src._elementType;
        this._staticTyping = src._staticTyping;
        this._valueTypeSerializer = vts;
        this._elementSerializer = elementSerializer;
        this._unwrapSingle = unwrapSingle;
        this._suppressableValue = suppressableValue;
        this._suppressNulls = suppressNulls;
    }

    @Deprecated
    protected AsArraySerializerBase<T> withResolved(BeanProperty property, TypeSerializer vts, ValueSerializer<?> elementSerializer, Boolean unwrapSingle) {
        return this.withResolved(property, vts, elementSerializer, unwrapSingle, null, false);
    }

    protected AsArraySerializerBase<T> withResolved(BeanProperty property, TypeSerializer vts, ValueSerializer<?> elementSerializer, Boolean unwrapSingle, Object suppressableValue, boolean suppressNulls) {
        return this.withResolved(property, vts, elementSerializer, unwrapSingle);
    }

    @Override
    public ValueSerializer<?> createContextual(SerializationContext ctxt, BeanProperty property) {
        JsonInclude.Include incl;
        JsonFormat.Value format;
        TypeSerializer typeSer = this._valueTypeSerializer;
        if (typeSer != null) {
            typeSer = typeSer.forProperty(ctxt, property);
        }
        ValueSerializer<Object> ser = null;
        Boolean unwrapSingle = null;
        if (property != null) {
            AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
            AnnotatedMember m = property.getMember();
            if (m != null) {
                ser = ctxt.serializerInstance(m, intr.findContentSerializer(ctxt.getConfig(), m));
            }
        }
        if ((format = this.findFormatOverrides(ctxt, property, this.handledType())) != null) {
            unwrapSingle = format.getFeature(JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED);
        }
        if (ser == null) {
            ser = this._elementSerializer;
        }
        if ((ser = this.findContextualConvertingSerializer(ctxt, property, ser)) == null && this._elementType != null && this._staticTyping && !this._elementType.isJavaLangObject()) {
            ser = ctxt.findContentValueSerializer(this._elementType, property);
        }
        JsonInclude.Value inclV = this.findIncludeOverrides(ctxt, property, this.handledType());
        Object valueToSuppress = this._suppressableValue;
        boolean suppressNulls = this._suppressNulls;
        if (inclV != null && (incl = inclV.getContentInclusion()) != JsonInclude.Include.USE_DEFAULTS) {
            switch (incl) {
                case NON_DEFAULT: {
                    valueToSuppress = BeanUtil.propertyDefaultValue(ctxt, this._elementType);
                    suppressNulls = true;
                    if (valueToSuppress == null || !valueToSuppress.getClass().isArray()) break;
                    valueToSuppress = ArrayBuilders.getArrayComparator(valueToSuppress);
                    break;
                }
                case NON_ABSENT: {
                    suppressNulls = true;
                    valueToSuppress = MARKER_FOR_EMPTY;
                    break;
                }
                case NON_EMPTY: {
                    suppressNulls = true;
                    valueToSuppress = MARKER_FOR_EMPTY;
                    break;
                }
                case CUSTOM: {
                    valueToSuppress = ctxt.includeFilterInstance(null, inclV.getContentFilter());
                    if (valueToSuppress == null) {
                        suppressNulls = true;
                        break;
                    }
                    suppressNulls = ctxt.includeFilterSuppressNulls(valueToSuppress);
                    break;
                }
                case NON_NULL: {
                    valueToSuppress = null;
                    suppressNulls = true;
                    break;
                }
                default: {
                    valueToSuppress = null;
                    suppressNulls = false;
                }
            }
        }
        if (ser != this._elementSerializer || property != this._property || this._valueTypeSerializer != typeSer || !Objects.equals(this._unwrapSingle, unwrapSingle) || !Objects.equals(valueToSuppress, this._suppressableValue) || suppressNulls != this._suppressNulls) {
            return this.withResolved(property, typeSer, ser, unwrapSingle, valueToSuppress, suppressNulls);
        }
        return this;
    }

    @Override
    public JavaType getContentType() {
        return this._elementType;
    }

    @Override
    public ValueSerializer<?> getContentSerializer() {
        return this._elementSerializer;
    }

    @Override
    public void serializeWithType(T value, JsonGenerator g, SerializationContext ctxt, TypeSerializer typeSer) throws JacksonException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, ctxt, typeSer.typeId(value, JsonToken.START_ARRAY));
        g.assignCurrentValue(value);
        this.serializeContents(value, g, ctxt);
        typeSer.writeTypeSuffix(g, ctxt, typeIdDef);
    }

    protected abstract void serializeContents(T var1, JsonGenerator var2, SerializationContext var3) throws JacksonException;

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JacksonException {
        ValueSerializer<Object> valueSer = this._elementSerializer;
        if (valueSer == null && this._elementType != null) {
            valueSer = visitor.getContext().findContentValueSerializer(this._elementType, this._property);
        }
        this.visitArrayFormat(visitor, typeHint, valueSer, this._elementType);
    }

    protected boolean _needToCheckFiltering(SerializationContext ctxt) {
        return (this._suppressableValue != null || this._suppressNulls) && ctxt.isEnabled(SerializationFeature.APPLY_JSON_INCLUDE_FOR_CONTAINERS);
    }

    protected boolean _shouldSerializeElement(SerializationContext ctxt, Object elem, ValueSerializer<Object> serializer) {
        if (this._suppressableValue == null) {
            return true;
        }
        if (this._suppressableValue == MARKER_FOR_EMPTY) {
            if (serializer != null) {
                return !serializer.isEmpty(ctxt, elem);
            }
            if (elem instanceof String) {
                String str = (String)elem;
                return !str.isEmpty();
            }
            return true;
        }
        return !this._suppressableValue.equals(elem);
    }
}

