/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonToken;
import tools.jackson.core.type.WritableTypeId;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.std.StdContainerSerializer;
import tools.jackson.databind.util.ArrayBuilders;
import tools.jackson.databind.util.BeanUtil;

public abstract class ArraySerializerBase<T>
extends StdContainerSerializer<T> {
    protected static final Object MARKER_FOR_EMPTY = JsonInclude.Include.NON_EMPTY;
    protected final Boolean _unwrapSingle;
    protected final Object _suppressableValue;
    protected final boolean _suppressNulls;

    protected ArraySerializerBase(Class<T> cls) {
        super(cls);
        this._unwrapSingle = null;
        this._suppressableValue = null;
        this._suppressNulls = false;
    }

    protected ArraySerializerBase(ArraySerializerBase<?> src) {
        super((StdContainerSerializer<?>)src);
        this._unwrapSingle = src._unwrapSingle;
        this._suppressableValue = src._suppressableValue;
        this._suppressNulls = src._suppressNulls;
    }

    protected ArraySerializerBase(ArraySerializerBase<?> src, BeanProperty property, Boolean unwrapSingle, Object suppressableValue, boolean suppressNulls) {
        super(src, property);
        this._unwrapSingle = unwrapSingle;
        this._suppressableValue = suppressableValue;
        this._suppressNulls = suppressNulls;
    }

    protected abstract ArraySerializerBase<T> _withResolved(BeanProperty var1, Boolean var2, Object var3, boolean var4);

    @Override
    public ValueSerializer<?> createContextual(SerializationContext ctxt, BeanProperty property) {
        JsonInclude.Include incl;
        JsonFormat.Value format;
        Boolean unwrapSingle = null;
        if (property != null && (format = this.findFormatOverrides(ctxt, property, this.handledType())) != null) {
            unwrapSingle = format.getFeature(JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED);
        }
        JsonInclude.Value inclV = this.findIncludeOverrides(ctxt, property, this.handledType());
        Object valueToSuppress = this._suppressableValue;
        boolean suppressNulls = this._suppressNulls;
        if (inclV != null && (incl = inclV.getContentInclusion()) != JsonInclude.Include.USE_DEFAULTS) {
            switch (incl) {
                case NON_DEFAULT: {
                    valueToSuppress = BeanUtil.propertyDefaultValue(ctxt, this.getContentType());
                    suppressNulls = true;
                    if (valueToSuppress == null || !valueToSuppress.getClass().isArray()) break;
                    valueToSuppress = ArrayBuilders.getArrayComparator(valueToSuppress);
                    break;
                }
                case NON_ABSENT: {
                    suppressNulls = true;
                    valueToSuppress = MARKER_FOR_EMPTY;
                    break;
                }
                case NON_EMPTY: {
                    suppressNulls = true;
                    valueToSuppress = MARKER_FOR_EMPTY;
                    break;
                }
                case CUSTOM: {
                    valueToSuppress = ctxt.includeFilterInstance(null, inclV.getContentFilter());
                    if (valueToSuppress == null) {
                        suppressNulls = true;
                        break;
                    }
                    suppressNulls = ctxt.includeFilterSuppressNulls(valueToSuppress);
                    break;
                }
                case NON_NULL: {
                    valueToSuppress = null;
                    suppressNulls = true;
                    break;
                }
                default: {
                    valueToSuppress = null;
                    suppressNulls = false;
                }
            }
        }
        if (!Objects.equals(unwrapSingle, this._unwrapSingle) || !Objects.equals(valueToSuppress, this._suppressableValue) || suppressNulls != this._suppressNulls) {
            return this._withResolved(property, unwrapSingle, valueToSuppress, suppressNulls);
        }
        return this;
    }

    @Override
    public final void serializeWithType(T value, JsonGenerator g, SerializationContext ctxt, TypeSerializer typeSer) throws JacksonException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, ctxt, typeSer.typeId(value, JsonToken.START_ARRAY));
        g.assignCurrentValue(value);
        this.serializeContents(value, g, ctxt);
        typeSer.writeTypeSuffix(g, ctxt, typeIdDef);
    }

    protected abstract void serializeContents(T var1, JsonGenerator var2, SerializationContext var3) throws JacksonException;

    protected final boolean _shouldUnwrapSingle(SerializationContext ctxt) {
        if (this._unwrapSingle == null) {
            return ctxt.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED);
        }
        return this._unwrapSingle;
    }

    protected boolean _needToCheckFiltering(SerializationContext ctxt) {
        return (this._suppressableValue != null || this._suppressNulls) && ctxt.isEnabled(SerializationFeature.APPLY_JSON_INCLUDE_FOR_CONTAINERS);
    }

    protected boolean _shouldSerializeElement(SerializationContext ctxt, Object elem) {
        if (this._suppressableValue == null) {
            return true;
        }
        if (this._suppressableValue == MARKER_FOR_EMPTY) {
            return true;
        }
        return !this._suppressableValue.equals(elem);
    }
}

