/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.jdk;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Objects;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.jdk.CollectionSerializer;
import tools.jackson.databind.ser.std.StdSerializer;
import tools.jackson.databind.util.ArrayBuilders;
import tools.jackson.databind.util.BeanUtil;

public abstract class StaticListSerializerBase<T extends Collection<?>>
extends StdSerializer<T> {
    protected static final Object MARKER_FOR_EMPTY = JsonInclude.Include.NON_EMPTY;
    protected final Boolean _unwrapSingle;
    protected final Class<?> _rawElementType;
    protected final Object _suppressableValue;
    protected final boolean _suppressNulls;

    @Deprecated
    protected StaticListSerializerBase(Class<?> cls) {
        this(cls, String.class);
    }

    protected StaticListSerializerBase(Class<?> rawCollectionType, Class<?> rawElementType) {
        super(rawCollectionType);
        this._rawElementType = rawElementType;
        this._unwrapSingle = null;
        this._suppressableValue = null;
        this._suppressNulls = false;
    }

    @Deprecated
    protected StaticListSerializerBase(StaticListSerializerBase<?> src, Boolean unwrapSingle) {
        this(src, unwrapSingle, src._suppressableValue, src._suppressNulls);
    }

    protected StaticListSerializerBase(StaticListSerializerBase<?> src, Boolean unwrapSingle, Object suppressableValue, boolean suppressNulls) {
        super(src);
        this._rawElementType = src._rawElementType;
        this._unwrapSingle = unwrapSingle;
        this._suppressableValue = suppressableValue;
        this._suppressNulls = suppressNulls;
    }

    @Deprecated
    public abstract ValueSerializer<?> _withResolved(BeanProperty var1, Boolean var2);

    public ValueSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle, Object suppressableValue, boolean suppressNulls) {
        return this._withResolved(prop, unwrapSingle);
    }

    @Override
    public ValueSerializer<?> createContextual(SerializationContext ctxt, BeanProperty property) {
        JsonInclude.Include incl;
        ValueSerializer<Object> ser = null;
        if (property != null) {
            AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
            AnnotatedMember m = property.getMember();
            if (m != null) {
                ser = ctxt.serializerInstance(m, intr.findContentSerializer(ctxt.getConfig(), m));
            }
        }
        Boolean unwrapSingle = null;
        JsonFormat.Value format = this.findFormatOverrides(ctxt, property, this.handledType());
        if (format != null) {
            unwrapSingle = format.getFeature(JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED);
        }
        if ((ser = this.findContextualConvertingSerializer(ctxt, property, ser)) == null) {
            ser = ctxt.findContentValueSerializer(this._rawElementType, property);
        }
        JsonInclude.Value inclV = this.findIncludeOverrides(ctxt, property, this.handledType());
        Object valueToSuppress = this._suppressableValue;
        boolean suppressNulls = this._suppressNulls;
        if (inclV != null && (incl = inclV.getContentInclusion()) != JsonInclude.Include.USE_DEFAULTS) {
            switch (incl) {
                case NON_DEFAULT: {
                    valueToSuppress = BeanUtil.propertyDefaultValue(ctxt, ctxt.constructType(this._rawElementType));
                    suppressNulls = true;
                    if (valueToSuppress == null || !valueToSuppress.getClass().isArray()) break;
                    valueToSuppress = ArrayBuilders.getArrayComparator(valueToSuppress);
                    break;
                }
                case NON_ABSENT: {
                    suppressNulls = true;
                    valueToSuppress = MARKER_FOR_EMPTY;
                    break;
                }
                case NON_EMPTY: {
                    suppressNulls = true;
                    valueToSuppress = MARKER_FOR_EMPTY;
                    break;
                }
                case CUSTOM: {
                    valueToSuppress = ctxt.includeFilterInstance(null, inclV.getContentFilter());
                    if (valueToSuppress == null) {
                        suppressNulls = true;
                        break;
                    }
                    suppressNulls = ctxt.includeFilterSuppressNulls(valueToSuppress);
                    break;
                }
                case NON_NULL: {
                    valueToSuppress = null;
                    suppressNulls = true;
                    break;
                }
                default: {
                    valueToSuppress = null;
                    suppressNulls = false;
                }
            }
        }
        if (this.isDefaultSerializer(ser)) {
            if (Objects.equals(unwrapSingle, this._unwrapSingle) && Objects.equals(valueToSuppress, this._suppressableValue) && suppressNulls == this._suppressNulls) {
                return this;
            }
            return this._withResolved(property, unwrapSingle, valueToSuppress, suppressNulls);
        }
        return new CollectionSerializer(ctxt.constructType((Type)((Object)String.class)), true, null, ser);
    }

    @Override
    public boolean isEmpty(SerializationContext provider, T value) {
        return value == null || value.isEmpty();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            this.acceptContentVisitor(v2);
        }
    }

    protected abstract JsonNode contentSchema();

    protected abstract void acceptContentVisitor(JsonArrayFormatVisitor var1);

    @Override
    public abstract void serializeWithType(T var1, JsonGenerator var2, SerializationContext var3, TypeSerializer var4) throws JacksonException;

    protected final boolean _shouldSerializeElement(Object elem, ValueSerializer<Object> serializer, SerializationContext ctxt) throws JacksonException {
        if (this._suppressableValue == null) {
            return true;
        }
        if (this._suppressableValue == MARKER_FOR_EMPTY) {
            if (serializer != null) {
                return !serializer.isEmpty(ctxt, elem);
            }
            if (elem instanceof String) {
                String str = (String)elem;
                return !str.isEmpty();
            }
            return true;
        }
        return !this._suppressableValue.equals(elem);
    }
}

