/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.jdk;

import java.math.BigInteger;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.annotation.JacksonStdImpl;
import tools.jackson.databind.ser.std.ToStringSerializerBase;

@JacksonStdImpl
public class NumberToStringWithRadixSerializer
extends ToStringSerializerBase {
    private final int radix;

    public NumberToStringWithRadixSerializer(int radix) {
        super(Object.class);
        this.radix = radix;
    }

    public NumberToStringWithRadixSerializer(Class<?> handledType, int radix) {
        super(handledType);
        this.radix = radix;
    }

    @Override
    public boolean isEmpty(SerializationContext ctxt, Object value) {
        return false;
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializationContext provider) throws JacksonException {
        if (this.radix < 2 || this.radix > 36) {
            String errorMsg = String.format("To use a custom radix for string serialization, use radix within [%d, %d]", 2, 36);
            provider.reportBadDefinition(this.handledType(), errorMsg);
        }
        String text = "";
        if (value instanceof BigInteger) {
            BigInteger bigIntegerValue = (BigInteger)value;
            text = bigIntegerValue.toString(this.radix);
        } else if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            long longValue = ((Number)value).longValue();
            text = Long.toString(longValue, this.radix);
        } else {
            provider.reportBadDefinition(this.handledType(), "Trying to serialize a non-whole number with NumberToStringWithRadixSerializer");
        }
        gen.writeString(text);
    }

    @Override
    public String valueToString(Object value) {
        throw new IllegalStateException();
    }
}

