/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.jdk;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.lang.annotation.Annotation;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.PropertyMetadata;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.cfg.MapperConfig;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.PropertyWriter;

public class MapProperty
extends PropertyWriter {
    private static final BeanProperty BOGUS_PROP = new BeanProperty.Bogus();
    protected final TypeSerializer _typeSerializer;
    protected final BeanProperty _property;
    protected Object _key;
    protected Object _value;
    protected ValueSerializer<Object> _keySerializer;
    protected ValueSerializer<Object> _valueSerializer;

    public MapProperty(TypeSerializer typeSer, BeanProperty prop) {
        super(prop == null ? PropertyMetadata.STD_REQUIRED_OR_OPTIONAL : prop.getMetadata());
        this._typeSerializer = typeSer;
        this._property = prop == null ? BOGUS_PROP : prop;
    }

    public void reset(Object key, Object value, ValueSerializer<Object> keySer, ValueSerializer<Object> valueSer) {
        this._key = key;
        this._value = value;
        this._keySerializer = keySer;
        this._valueSerializer = valueSer;
    }

    @Override
    public String getName() {
        Object object = this._key;
        if (object instanceof String) {
            String string = (String)object;
            return string;
        }
        return String.valueOf(this._key);
    }

    public Object getValue() {
        return this._value;
    }

    public void setValue(Object v) {
        this._value = v;
    }

    @Override
    public PropertyName getFullName() {
        return new PropertyName(this.getName());
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        return this._property.getAnnotation(acls);
    }

    @Override
    public <A extends Annotation> A getContextAnnotation(Class<A> acls) {
        return this._property.getContextAnnotation(acls);
    }

    @Override
    public JsonInclude.Value findPropertyInclusion(MapperConfig<?> config, Class<?> baseType) {
        return JsonInclude.Value.empty();
    }

    @Override
    public void serializeAsProperty(Object map, JsonGenerator gen, SerializationContext ctxt) {
        this._keySerializer.serialize(this._key, gen, ctxt);
        if (this._typeSerializer == null) {
            this._valueSerializer.serialize(this._value, gen, ctxt);
        } else {
            this._valueSerializer.serializeWithType(this._value, gen, ctxt, this._typeSerializer);
        }
    }

    @Override
    public void serializeAsOmittedProperty(Object map, JsonGenerator gen, SerializationContext ctxt) {
        if (!gen.canOmitProperties()) {
            gen.writeOmittedProperty(this.getName());
        }
    }

    @Override
    public void serializeAsElement(Object map, JsonGenerator gen, SerializationContext ctxt) {
        if (this._typeSerializer == null) {
            this._valueSerializer.serialize(this._value, gen, ctxt);
        } else {
            this._valueSerializer.serializeWithType(this._value, gen, ctxt, this._typeSerializer);
        }
    }

    @Override
    public void serializeAsOmittedElement(Object value, JsonGenerator gen, SerializationContext ctxt) {
        gen.writeNull();
    }

    @Override
    public void depositSchemaProperty(JsonObjectFormatVisitor objectVisitor, SerializationContext ctxt) {
        this._property.depositSchemaProperty(objectVisitor, ctxt);
    }

    @Override
    public JavaType getType() {
        return this._property.getType();
    }

    @Override
    public PropertyName getWrapperName() {
        return this._property.getWrapperName();
    }

    @Override
    public AnnotatedMember getMember() {
        return this._property.getMember();
    }
}

