/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.jdk;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.HashMap;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonToken;
import tools.jackson.core.type.WritableTypeId;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.annotation.JacksonStdImpl;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.jdk.ByteArraySerializer;
import tools.jackson.databind.ser.std.ArraySerializerBase;
import tools.jackson.databind.ser.std.StdContainerSerializer;
import tools.jackson.databind.ser.std.StdSerializer;
import tools.jackson.databind.type.TypeFactory;

public class JDKArraySerializers {
    protected static final HashMap<String, ValueSerializer<?>> _arraySerializers = new HashMap();

    protected JDKArraySerializers() {
    }

    public static ValueSerializer<?> findStandardImpl(SerializationContext ctxt, Class<?> cls, JsonFormat.Value formatOverrides) {
        if (formatOverrides != null && formatOverrides.getShape() == JsonFormat.Shape.BINARY) {
            if (cls == float[].class) {
                return BinaryFloatArraySerializer.instance;
            }
            if (cls == double[].class) {
                return BinaryDoubleArraySerializer.instance;
            }
        }
        return _arraySerializers.get(cls.getName());
    }

    static JavaType simpleElementType(Class<?> elemClass) {
        return TypeFactory.unsafeSimpleType(elemClass);
    }

    static {
        _arraySerializers.put(boolean[].class.getName(), new BooleanArraySerializer());
        _arraySerializers.put(byte[].class.getName(), new ByteArraySerializer());
        _arraySerializers.put(char[].class.getName(), new CharArraySerializer());
        _arraySerializers.put(short[].class.getName(), new ShortArraySerializer());
        _arraySerializers.put(int[].class.getName(), new IntArraySerializer());
        _arraySerializers.put(long[].class.getName(), new LongArraySerializer());
        _arraySerializers.put(float[].class.getName(), new FloatArraySerializer());
        _arraySerializers.put(double[].class.getName(), new DoubleArraySerializer());
    }

    @JacksonStdImpl
    public static class BinaryFloatArraySerializer
    extends StdSerializer<float[]> {
        static final BinaryFloatArraySerializer instance = new BinaryFloatArraySerializer();

        public BinaryFloatArraySerializer() {
            super(float[].class);
        }

        @Override
        public boolean isEmpty(SerializationContext ctxt, float[] value) {
            return value.length == 0;
        }

        @Override
        public ValueSerializer<?> createContextual(SerializationContext ctxt, BeanProperty property) {
            JsonFormat.Value format = this.findFormatOverrides(ctxt, property, this.handledType());
            if (format != null) {
                switch (format.getShape()) {
                    case ARRAY: 
                    case NATURAL: {
                        return FloatArraySerializer.instance;
                    }
                }
            }
            return this;
        }

        @Override
        public void serialize(float[] value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
            int vectorLen = value.length;
            byte[] b = new byte[vectorLen * 4];
            int out = 0;
            for (int i = 0; i < vectorLen; ++i) {
                int floatBits = Float.floatToIntBits(value[i]);
                b[out++] = (byte)(floatBits >> 24);
                b[out++] = (byte)(floatBits >> 16);
                b[out++] = (byte)(floatBits >> 8);
                b[out++] = (byte)floatBits;
            }
            g.writeBinary(ctxt.getConfig().getBase64Variant(), b, 0, b.length);
        }

        @Override
        public void serializeWithType(float[] value, JsonGenerator g, SerializationContext ctxt, TypeSerializer typeSer) throws JacksonException {
            WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, ctxt, typeSer.typeId(value, JsonToken.VALUE_EMBEDDED_OBJECT));
            this.serialize(value, g, ctxt);
            typeSer.writeTypeSuffix(g, ctxt, typeIdDef);
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
            this.visitArrayFormat(visitor, typeHint, JsonFormatTypes.NUMBER);
        }
    }

    @JacksonStdImpl
    public static class BinaryDoubleArraySerializer
    extends StdSerializer<double[]> {
        static final BinaryDoubleArraySerializer instance = new BinaryDoubleArraySerializer();

        public BinaryDoubleArraySerializer() {
            super(double[].class);
        }

        @Override
        public boolean isEmpty(SerializationContext ctxt, double[] value) {
            return value.length == 0;
        }

        @Override
        public ValueSerializer<?> createContextual(SerializationContext ctxt, BeanProperty property) {
            JsonFormat.Value format = this.findFormatOverrides(ctxt, property, this.handledType());
            if (format != null) {
                switch (format.getShape()) {
                    case ARRAY: 
                    case NATURAL: {
                        return DoubleArraySerializer.instance;
                    }
                }
            }
            return this;
        }

        @Override
        public void serialize(double[] value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
            int vectorLen = value.length;
            byte[] b = new byte[vectorLen * 8];
            int out = 0;
            for (int i = 0; i < vectorLen; ++i) {
                long bits = Double.doubleToLongBits(value[i]);
                int hi = (int)(bits >> 32);
                b[out] = (byte)(hi >> 24);
                b[out + 1] = (byte)(hi >> 16);
                b[out + 2] = (byte)(hi >> 8);
                b[out + 3] = (byte)hi;
                int lo = (int)bits;
                b[out + 4] = (byte)(lo >> 24);
                b[out + 5] = (byte)(lo >> 16);
                b[out + 6] = (byte)(lo >> 8);
                b[out + 7] = (byte)lo;
                out += 8;
            }
            g.writeBinary(ctxt.getConfig().getBase64Variant(), b, 0, b.length);
        }

        @Override
        public void serializeWithType(double[] value, JsonGenerator g, SerializationContext ctxt, TypeSerializer typeSer) throws JacksonException {
            WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, ctxt, typeSer.typeId(value, JsonToken.VALUE_EMBEDDED_OBJECT));
            this.serialize(value, g, ctxt);
            typeSer.writeTypeSuffix(g, ctxt, typeIdDef);
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JacksonException {
            this.visitArrayFormat(visitor, typeHint, JsonFormatTypes.NUMBER);
        }
    }

    @JacksonStdImpl
    public static class BooleanArraySerializer
    extends ArraySerializerBase<boolean[]> {
        private static final JavaType VALUE_TYPE = JDKArraySerializers.simpleElementType(Boolean.TYPE);

        public BooleanArraySerializer() {
            super(boolean[].class);
        }

        protected BooleanArraySerializer(BooleanArraySerializer src, BeanProperty prop, Boolean unwrapSingle, Object suppressableValue, boolean suppressNulls) {
            super(src, prop, unwrapSingle, suppressableValue, suppressNulls);
        }

        protected BooleanArraySerializer _withResolved(BeanProperty prop, Boolean unwrapSingle, Object suppressableValue, boolean suppressNulls) {
            return new BooleanArraySerializer(this, prop, unwrapSingle, suppressableValue, suppressNulls);
        }

        @Override
        public StdContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return this;
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public ValueSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializationContext prov, boolean[] value) {
            return value.length == 0;
        }

        @Override
        public boolean hasSingleElement(boolean[] value) {
            return value.length == 1;
        }

        @Override
        public final void serialize(boolean[] value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
            int len = value.length;
            if (len == 1 && this._shouldUnwrapSingle(ctxt)) {
                this.serializeContents(value, g, ctxt);
                return;
            }
            g.writeStartArray((Object)value, len);
            this.serializeContents(value, g, ctxt);
            g.writeEndArray();
        }

        @Override
        public void serializeContents(boolean[] value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
            boolean filtered = this._needToCheckFiltering(ctxt);
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                if (filtered && !this._shouldSerializeElement(ctxt, value[i])) continue;
                g.writeBoolean(value[i]);
            }
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
            this.visitArrayFormat(visitor, typeHint, JsonFormatTypes.BOOLEAN);
        }
    }

    @JacksonStdImpl
    public static class CharArraySerializer
    extends StdSerializer<char[]> {
        public CharArraySerializer() {
            super(char[].class);
        }

        @Override
        public boolean isEmpty(SerializationContext prov, char[] value) {
            return value.length == 0;
        }

        @Override
        public void serialize(char[] value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
            if (ctxt.isEnabled(SerializationFeature.WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS)) {
                g.writeStartArray((Object)value, value.length);
                this._writeArrayContents(g, value);
                g.writeEndArray();
            } else {
                g.writeString(value, 0, value.length);
            }
        }

        @Override
        public void serializeWithType(char[] value, JsonGenerator g, SerializationContext ctxt, TypeSerializer typeSer) throws JacksonException {
            WritableTypeId typeIdDef;
            boolean asArray = ctxt.isEnabled(SerializationFeature.WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS);
            if (asArray) {
                typeIdDef = typeSer.writeTypePrefix(g, ctxt, typeSer.typeId(value, JsonToken.START_ARRAY));
                this._writeArrayContents(g, value);
            } else {
                typeIdDef = typeSer.writeTypePrefix(g, ctxt, typeSer.typeId(value, JsonToken.VALUE_STRING));
                g.writeString(value, 0, value.length);
            }
            typeSer.writeTypeSuffix(g, ctxt, typeIdDef);
        }

        private final void _writeArrayContents(JsonGenerator g, char[] value) throws JacksonException {
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                g.writeString(value, i, 1);
            }
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
            this.visitArrayFormat(visitor, typeHint, JsonFormatTypes.STRING);
        }
    }

    @JacksonStdImpl
    public static class ShortArraySerializer
    extends TypedPrimitiveArraySerializer<short[]> {
        private static final JavaType VALUE_TYPE = JDKArraySerializers.simpleElementType(Short.TYPE);

        public ShortArraySerializer() {
            super(short[].class);
        }

        protected ShortArraySerializer(ShortArraySerializer src, BeanProperty prop, Boolean unwrapSingle, Object suppressableValue, boolean suppressNulls) {
            super(src, prop, unwrapSingle, suppressableValue, suppressNulls);
        }

        protected ShortArraySerializer _withResolved(BeanProperty prop, Boolean unwrapSingle, Object suppressableValue, boolean suppressNulls) {
            return new ShortArraySerializer(this, prop, unwrapSingle, suppressableValue, suppressNulls);
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public ValueSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializationContext prov, short[] value) {
            return value.length == 0;
        }

        @Override
        public boolean hasSingleElement(short[] value) {
            return value.length == 1;
        }

        @Override
        public final void serialize(short[] value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
            int len = value.length;
            if (len == 1 && this._shouldUnwrapSingle(ctxt)) {
                this.serializeContents(value, g, ctxt);
                return;
            }
            g.writeStartArray((Object)value, len);
            this.serializeContents(value, g, ctxt);
            g.writeEndArray();
        }

        @Override
        public void serializeContents(short[] value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
            boolean filtered = this._needToCheckFiltering(ctxt);
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                if (filtered && !this._shouldSerializeElement(ctxt, value[i])) continue;
                g.writeNumber((int)value[i]);
            }
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
            this.visitArrayFormat(visitor, typeHint, JsonFormatTypes.INTEGER);
        }
    }

    @JacksonStdImpl
    public static class IntArraySerializer
    extends ArraySerializerBase<int[]> {
        private static final JavaType VALUE_TYPE = JDKArraySerializers.simpleElementType(Integer.TYPE);

        public IntArraySerializer() {
            super(int[].class);
        }

        protected IntArraySerializer(IntArraySerializer src, BeanProperty prop, Boolean unwrapSingle, Object suppressableValue, boolean suppressNulls) {
            super(src, prop, unwrapSingle, suppressableValue, suppressNulls);
        }

        protected IntArraySerializer _withResolved(BeanProperty prop, Boolean unwrapSingle, Object suppressableValue, boolean suppressNulls) {
            return new IntArraySerializer(this, prop, unwrapSingle, suppressableValue, suppressNulls);
        }

        @Override
        public StdContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return this;
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public ValueSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializationContext prov, int[] value) {
            return value.length == 0;
        }

        @Override
        public boolean hasSingleElement(int[] value) {
            return value.length == 1;
        }

        @Override
        public final void serialize(int[] value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
            int len = value.length;
            if (len == 1 && this._shouldUnwrapSingle(ctxt)) {
                this.serializeContents(value, g, ctxt);
                return;
            }
            if (this._needToCheckFiltering(ctxt)) {
                g.writeStartArray((Object)value, len);
                this.serializeContents(value, g, ctxt);
                g.writeEndArray();
                return;
            }
            g.writeArray(value, 0, value.length);
        }

        @Override
        public void serializeContents(int[] value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
            boolean filtered = this._needToCheckFiltering(ctxt);
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                if (filtered && !this._shouldSerializeElement(ctxt, value[i])) continue;
                g.writeNumber(value[i]);
            }
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
            this.visitArrayFormat(visitor, typeHint, JsonFormatTypes.INTEGER);
        }
    }

    @JacksonStdImpl
    public static class LongArraySerializer
    extends TypedPrimitiveArraySerializer<long[]> {
        private static final JavaType VALUE_TYPE = JDKArraySerializers.simpleElementType(Long.TYPE);

        public LongArraySerializer() {
            super(long[].class);
        }

        protected LongArraySerializer(LongArraySerializer src, BeanProperty prop, Boolean unwrapSingle, Object suppressableValue, boolean suppressNulls) {
            super(src, prop, unwrapSingle, suppressableValue, suppressNulls);
        }

        protected LongArraySerializer _withResolved(BeanProperty prop, Boolean unwrapSingle, Object suppressableValue, boolean suppressNulls) {
            return new LongArraySerializer(this, prop, unwrapSingle, suppressableValue, suppressNulls);
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public ValueSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializationContext prov, long[] value) {
            return value.length == 0;
        }

        @Override
        public boolean hasSingleElement(long[] value) {
            return value.length == 1;
        }

        @Override
        public final void serialize(long[] value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
            int len = value.length;
            if (len == 1 && this._shouldUnwrapSingle(ctxt)) {
                this.serializeContents(value, g, ctxt);
                return;
            }
            if (this._needToCheckFiltering(ctxt)) {
                g.writeStartArray((Object)value, len);
                this.serializeContents(value, g, ctxt);
                g.writeEndArray();
                return;
            }
            g.writeArray(value, 0, value.length);
        }

        @Override
        public void serializeContents(long[] value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
            boolean filtered = this._needToCheckFiltering(ctxt);
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                if (filtered && !this._shouldSerializeElement(ctxt, value[i])) continue;
                g.writeNumber(value[i]);
            }
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
            this.visitArrayFormat(visitor, typeHint, JsonFormatTypes.NUMBER);
        }
    }

    @JacksonStdImpl
    public static class FloatArraySerializer
    extends TypedPrimitiveArraySerializer<float[]> {
        private static final JavaType VALUE_TYPE = JDKArraySerializers.simpleElementType(Float.TYPE);
        static final FloatArraySerializer instance = new FloatArraySerializer();

        public FloatArraySerializer() {
            super(float[].class);
        }

        protected FloatArraySerializer(FloatArraySerializer src, BeanProperty prop, Boolean unwrapSingle, Object suppressableValue, boolean suppressNulls) {
            super(src, prop, unwrapSingle, suppressableValue, suppressNulls);
        }

        protected FloatArraySerializer _withResolved(BeanProperty prop, Boolean unwrapSingle, Object suppressableValue, boolean suppressNulls) {
            return new FloatArraySerializer(this, prop, unwrapSingle, suppressableValue, suppressNulls);
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public ValueSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializationContext prov, float[] value) {
            return value.length == 0;
        }

        @Override
        public boolean hasSingleElement(float[] value) {
            return value.length == 1;
        }

        @Override
        public ValueSerializer<?> createContextual(SerializationContext ctxt, BeanProperty property) {
            JsonFormat.Value format = this.findFormatOverrides(ctxt, property, this.handledType());
            if (format != null && format.getShape() == JsonFormat.Shape.BINARY) {
                return BinaryFloatArraySerializer.instance;
            }
            return super.createContextual(ctxt, property);
        }

        @Override
        public final void serialize(float[] value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
            int len = value.length;
            if (len == 1 && this._shouldUnwrapSingle(ctxt)) {
                this.serializeContents(value, g, ctxt);
                return;
            }
            g.writeStartArray((Object)value, len);
            this.serializeContents(value, g, ctxt);
            g.writeEndArray();
        }

        @Override
        public void serializeContents(float[] value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
            boolean filtered = this._needToCheckFiltering(ctxt);
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                if (filtered && !this._shouldSerializeElement(ctxt, Float.valueOf(value[i]))) continue;
                g.writeNumber(value[i]);
            }
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
            this.visitArrayFormat(visitor, typeHint, JsonFormatTypes.NUMBER);
        }
    }

    @JacksonStdImpl
    public static class DoubleArraySerializer
    extends ArraySerializerBase<double[]> {
        private static final JavaType VALUE_TYPE = JDKArraySerializers.simpleElementType(Double.TYPE);
        static final DoubleArraySerializer instance = new DoubleArraySerializer();

        public DoubleArraySerializer() {
            super(double[].class);
        }

        protected DoubleArraySerializer(DoubleArraySerializer src, BeanProperty prop, Boolean unwrapSingle, Object suppressableValue, boolean suppressNulls) {
            super(src, prop, unwrapSingle, suppressableValue, suppressNulls);
        }

        protected DoubleArraySerializer _withResolved(BeanProperty prop, Boolean unwrapSingle, Object suppressableValue, boolean suppressNulls) {
            return new DoubleArraySerializer(this, prop, unwrapSingle, suppressableValue, suppressNulls);
        }

        @Override
        public StdContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return this;
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public ValueSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializationContext prov, double[] value) {
            return value.length == 0;
        }

        @Override
        public boolean hasSingleElement(double[] value) {
            return value.length == 1;
        }

        @Override
        public ValueSerializer<?> createContextual(SerializationContext ctxt, BeanProperty property) {
            JsonFormat.Value format = this.findFormatOverrides(ctxt, property, this.handledType());
            if (format != null && format.getShape() == JsonFormat.Shape.BINARY) {
                return BinaryDoubleArraySerializer.instance;
            }
            return super.createContextual(ctxt, property);
        }

        @Override
        public void serialize(double[] value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
            int len = value.length;
            if (len == 1 && this._shouldUnwrapSingle(ctxt)) {
                this.serializeContents(value, g, ctxt);
                return;
            }
            if (this._needToCheckFiltering(ctxt)) {
                g.writeStartArray((Object)value, len);
                this.serializeContents(value, g, ctxt);
                g.writeEndArray();
                return;
            }
            g.writeArray(value, 0, value.length);
        }

        @Override
        public void serializeContents(double[] value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
            boolean filtered = this._needToCheckFiltering(ctxt);
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                if (filtered && !this._shouldSerializeElement(ctxt, value[i])) continue;
                g.writeNumber(value[i]);
            }
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
            this.visitArrayFormat(visitor, typeHint, JsonFormatTypes.NUMBER);
        }
    }

    protected static abstract class TypedPrimitiveArraySerializer<T>
    extends ArraySerializerBase<T> {
        protected TypedPrimitiveArraySerializer(Class<T> cls) {
            super(cls);
        }

        protected TypedPrimitiveArraySerializer(TypedPrimitiveArraySerializer<T> src, BeanProperty prop, Boolean unwrapSingle, Object suppressableValue, boolean suppressNulls) {
            super(src, prop, unwrapSingle, suppressableValue, suppressNulls);
        }

        @Override
        public final StdContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return this;
        }
    }
}

