/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.node;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import tools.jackson.core.Base64Variant;
import tools.jackson.core.Base64Variants;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonToken;
import tools.jackson.core.io.NumberInput;
import tools.jackson.core.util.ByteArrayBuilder;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.node.JsonNodeType;
import tools.jackson.databind.node.ValueNode;

public class StringNode
extends ValueNode {
    private static final long serialVersionUID = 3L;
    static final StringNode EMPTY_STRING_NODE = new StringNode("");
    protected final String _value;

    public StringNode(String v) {
        this._value = Objects.requireNonNull(v);
    }

    public static StringNode valueOf(String v) {
        if (v == null) {
            return null;
        }
        if (v.isEmpty()) {
            return EMPTY_STRING_NODE;
        }
        return new StringNode(v);
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.STRING;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.VALUE_STRING;
    }

    @Override
    protected String _valueDesc() {
        String s = this._value;
        if (s.length() > 100) {
            return "\"" + s.substring(0, 100) + "\"[...]";
        }
        return "\"" + this._value + "\"";
    }

    @Override
    public StringNode deepCopy() {
        return this;
    }

    @Override
    public Boolean _asBoolean() {
        if ("true".equals(this._value)) {
            return Boolean.TRUE;
        }
        if ("false".equals(this._value)) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public String stringValue() {
        return this._value;
    }

    @Override
    public String stringValue(String defaultValue) {
        return this._value;
    }

    @Override
    public Optional<String> stringValueOpt() {
        return Optional.of(this._value);
    }

    @Override
    protected String _asString() {
        return this._value;
    }

    @Override
    public String asString() {
        return this._value;
    }

    @Override
    public String asString(String defaultValue) {
        return this._value;
    }

    @Override
    public Optional<String> asStringOpt() {
        return Optional.of(this._value);
    }

    public byte[] getBinaryValue(Base64Variant b64variant) throws JacksonException {
        String str = this._value.trim();
        int initBlockSize = 4 + (str.length() >> 2) * 3;
        ByteArrayBuilder builder = new ByteArrayBuilder(Math.max(16, Math.min(65536, initBlockSize)));
        try {
            b64variant.decode(str, builder);
        }
        catch (IllegalArgumentException e) {
            return (byte[])this._reportCoercionFail("binaryValue()", byte[].class, "value type not binary and Base64-decoding failed with: " + e.getMessage());
        }
        return builder.toByteArray();
    }

    @Override
    public byte[] binaryValue() throws JacksonException {
        return this.getBinaryValue(Base64Variants.getDefaultVariant());
    }

    @Override
    public short asShort() {
        Short S = this._tryParseAsShort();
        if (S == null) {
            return (Short)this._reportCoercionFail("asShort()", Short.TYPE, "value not a valid String representation of `short`");
        }
        return S;
    }

    @Override
    public short asShort(short defaultValue) {
        Short S = this._tryParseAsShort();
        return S == null ? defaultValue : S;
    }

    @Override
    public Optional<Short> asShortOpt() {
        Short S = this._tryParseAsShort();
        return S == null ? Optional.empty() : Optional.of(S);
    }

    @Override
    public int asInt() {
        Integer I = this._tryParseAsInteger();
        if (I == null) {
            return (Integer)this._reportCoercionFail("asInt()", Integer.TYPE, "value not a valid String representation of `int`");
        }
        return I;
    }

    @Override
    public int asInt(int defaultValue) {
        Integer I = this._tryParseAsInteger();
        return I == null ? defaultValue : I;
    }

    @Override
    public OptionalInt asIntOpt() {
        Integer I = this._tryParseAsInteger();
        return I == null ? OptionalInt.empty() : OptionalInt.of(I);
    }

    @Override
    public long asLong() {
        Long L = this._tryParseAsLong();
        if (L == null) {
            return (Long)this._reportCoercionFail("asLong()", Long.TYPE, "value not a valid String representation of `long`");
        }
        return L;
    }

    @Override
    public long asLong(long defaultValue) {
        Long L = this._tryParseAsLong();
        return L == null ? defaultValue : L;
    }

    @Override
    public OptionalLong asLongOpt() {
        Long L = this._tryParseAsLong();
        return L == null ? OptionalLong.empty() : OptionalLong.of(L);
    }

    @Override
    public BigInteger asBigInteger() {
        BigInteger big = this._tryParseAsBigInteger();
        if (big == null) {
            return (BigInteger)this._reportCoercionFail("asBigInteger()", BigInteger.class, "value not a valid String representation of `BigInteger`");
        }
        return big;
    }

    @Override
    public BigInteger asBigInteger(BigInteger defaultValue) {
        BigInteger big = this._tryParseAsBigInteger();
        return big == null ? defaultValue : big;
    }

    @Override
    public Optional<BigInteger> asBigIntegerOpt() {
        BigInteger big = this._tryParseAsBigInteger();
        return big == null ? Optional.empty() : Optional.of(big);
    }

    @Override
    public float asFloat() {
        Float F = this._tryParseAsFloat();
        if (F == null) {
            return ((Float)this._reportCoercionFail("asFloat()", Float.TYPE, "value not a valid String representation of `float`")).floatValue();
        }
        return F.floatValue();
    }

    @Override
    public float asFloat(float defaultValue) {
        Float F = this._tryParseAsFloat();
        return F == null ? defaultValue : F.floatValue();
    }

    @Override
    public Optional<Float> asFloatOpt() {
        Float F = this._tryParseAsFloat();
        return F == null ? Optional.empty() : Optional.of(F);
    }

    @Override
    public double asDouble() {
        Double d = this._tryParseAsDouble();
        if (d == null) {
            return (Double)this._reportCoercionFail("asDouble()", Double.TYPE, "value not a valid String representation of `double`");
        }
        return d;
    }

    @Override
    public double asDouble(double defaultValue) {
        Double d = this._tryParseAsDouble();
        return d == null ? defaultValue : d;
    }

    @Override
    public OptionalDouble asDoubleOpt() {
        Double d = this._tryParseAsDouble();
        return d == null ? OptionalDouble.empty() : OptionalDouble.of(d);
    }

    @Override
    public BigDecimal asDecimal() {
        BigDecimal dec = this._tryParseAsBigDecimal();
        if (dec == null) {
            return (BigDecimal)this._reportCoercionFail("asDecimal()", BigDecimal.class, "value not a valid String representation of `BigDecimal`");
        }
        return dec;
    }

    @Override
    public BigDecimal asDecimal(BigDecimal defaultValue) {
        BigDecimal dec = this._tryParseAsBigDecimal();
        return dec == null ? defaultValue : dec;
    }

    @Override
    public Optional<BigDecimal> asDecimalOpt() {
        BigDecimal dec = this._tryParseAsBigDecimal();
        return dec == null ? Optional.empty() : Optional.of(dec);
    }

    protected Short _tryParseAsShort() {
        Integer I = this._tryParseAsInteger();
        if (I != null && I >= Short.MIN_VALUE && I <= Short.MAX_VALUE) {
            return I.shortValue();
        }
        return null;
    }

    protected Integer _tryParseAsInteger() {
        if (NumberInput.looksLikeValidNumber((String)this._value)) {
            try {
                return Integer.parseInt(this._value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    protected Long _tryParseAsLong() {
        if (NumberInput.looksLikeValidNumber((String)this._value)) {
            try {
                return NumberInput.parseLong((String)this._value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    protected BigInteger _tryParseAsBigInteger() {
        if (NumberInput.looksLikeValidNumber((String)this._value)) {
            try {
                return NumberInput.parseBigInteger((String)this._value, (boolean)true);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    protected Float _tryParseAsFloat() {
        if (NumberInput.looksLikeValidNumber((String)this._value)) {
            try {
                return Float.valueOf(NumberInput.parseFloat((String)this._value, (boolean)true));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    protected Double _tryParseAsDouble() {
        if (NumberInput.looksLikeValidNumber((String)this._value)) {
            try {
                return NumberInput.parseDouble((String)this._value, (boolean)true);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    protected BigDecimal _tryParseAsBigDecimal() {
        if (NumberInput.looksLikeValidNumber((String)this._value)) {
            try {
                return NumberInput.parseBigDecimal((String)this._value, (boolean)true);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public final void serialize(JsonGenerator g, SerializationContext provider) throws JacksonException {
        g.writeString(this._value);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof StringNode) {
            StringNode other = (StringNode)o;
            return Objects.equals(other._value, this._value);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this._value.hashCode();
    }
}

