/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.node;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.node.NumericIntNode;

public class IntNode
extends NumericIntNode {
    private static final long serialVersionUID = 3L;
    static final int MIN_CANONICAL = -1;
    static final int MAX_CANONICAL = 10;
    private static final IntNode[] CANONICALS;
    protected final int _value;

    public IntNode(int v) {
        this._value = v;
    }

    public static IntNode valueOf(int i) {
        if (i > 10 || i < -1) {
            return new IntNode(i);
        }
        return CANONICALS[i - -1];
    }

    @Override
    public JsonParser.NumberType numberType() {
        return JsonParser.NumberType.INT;
    }

    @Override
    public boolean isInt() {
        return true;
    }

    @Override
    protected Boolean _asBoolean() {
        return this._value != 0;
    }

    @Override
    protected String _asString() {
        return String.valueOf(this._value);
    }

    @Override
    public Number numberValue() {
        return this._value;
    }

    @Override
    public short shortValue() {
        if (this.inShortRange()) {
            return (short)this._value;
        }
        return this._reportShortConversionRangeFail("shortValue()");
    }

    @Override
    public short shortValue(short defaultValue) {
        return this.inShortRange() ? (short)this._value : defaultValue;
    }

    @Override
    public Optional<Short> shortValueOpt() {
        return this.inShortRange() ? Optional.of((short)this._value) : Optional.empty();
    }

    @Override
    public short asShort() {
        if (this.inShortRange()) {
            return (short)this._value;
        }
        return this._reportShortConversionRangeFail("asShort()");
    }

    @Override
    public short asShort(short defaultValue) {
        return this.inShortRange() ? (short)this._value : defaultValue;
    }

    @Override
    public Optional<Short> asShortOpt() {
        return this.inShortRange() ? Optional.of((short)this._value) : Optional.empty();
    }

    @Override
    public int intValue() {
        return this._value;
    }

    @Override
    public int intValue(int defaultValue) {
        return this._value;
    }

    @Override
    public OptionalInt intValueOpt() {
        return OptionalInt.of(this._value);
    }

    @Override
    public int asInt() {
        return this._value;
    }

    @Override
    public int asInt(int defaultValue) {
        return this._value;
    }

    @Override
    public OptionalInt asIntOpt() {
        return OptionalInt.of(this._value);
    }

    @Override
    public long longValue() {
        return this._value;
    }

    @Override
    public long longValue(long defaultValue) {
        return this._value;
    }

    @Override
    public OptionalLong longValueOpt() {
        return OptionalLong.of(this._value);
    }

    @Override
    public long asLong() {
        return this._value;
    }

    @Override
    public long asLong(long defaultValue) {
        return this._value;
    }

    @Override
    public OptionalLong asLongOpt() {
        return OptionalLong.of(this._value);
    }

    @Override
    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf(this._value);
    }

    @Override
    public BigInteger bigIntegerValue(BigInteger defaultValue) {
        return BigInteger.valueOf(this._value);
    }

    @Override
    public Optional<BigInteger> bigIntegerValueOpt() {
        return Optional.of(BigInteger.valueOf(this._value));
    }

    @Override
    public BigDecimal decimalValue() {
        return BigDecimal.valueOf(this._value);
    }

    @Override
    public BigDecimal decimalValue(BigDecimal defaultValue) {
        return this.decimalValue();
    }

    @Override
    public Optional<BigDecimal> decimalValueOpt() {
        return Optional.of(this.decimalValue());
    }

    @Override
    public short _asShortValueUnchecked() {
        return (short)this._value;
    }

    @Override
    public long _asLongValueUnchecked() {
        return this._value;
    }

    @Override
    public int _asIntValueUnchecked() {
        return this._value;
    }

    @Override
    protected float _asFloatValueUnchecked() {
        return this._value;
    }

    @Override
    protected double _asDoubleValueUnchecked() {
        return this._value;
    }

    @Override
    public boolean inShortRange() {
        return this._value >= Short.MIN_VALUE && this._value <= Short.MAX_VALUE;
    }

    @Override
    public boolean inIntRange() {
        return true;
    }

    @Override
    public boolean inLongRange() {
        return true;
    }

    @Override
    public final void serialize(JsonGenerator g, SerializationContext provider) throws JacksonException {
        g.writeNumber(this._value);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof IntNode) {
            IntNode otherNode = (IntNode)o;
            return otherNode._value == this._value;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this._value;
    }

    static {
        int count = 12;
        CANONICALS = new IntNode[count];
        for (int i = 0; i < count; ++i) {
            IntNode.CANONICALS[i] = new IntNode(-1 + i);
        }
    }
}

