/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.node;

import java.util.Optional;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.node.JsonNodeType;
import tools.jackson.databind.node.ValueNode;

public class BooleanNode
extends ValueNode {
    private static final long serialVersionUID = 3L;
    public static final BooleanNode TRUE = new BooleanNode(true);
    public static final BooleanNode FALSE = new BooleanNode(false);
    private final boolean _value;

    protected BooleanNode(boolean v) {
        this._value = v;
    }

    protected Object readResolve() {
        return this._value ? TRUE : FALSE;
    }

    public static BooleanNode getTrue() {
        return TRUE;
    }

    public static BooleanNode getFalse() {
        return FALSE;
    }

    public static BooleanNode valueOf(boolean b) {
        return b ? TRUE : FALSE;
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.BOOLEAN;
    }

    @Override
    public JsonToken asToken() {
        return this._value ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
    }

    @Override
    protected String _valueDesc() {
        return this.asString();
    }

    @Override
    public BooleanNode deepCopy() {
        return this;
    }

    @Override
    public final boolean asBoolean() {
        return this._value;
    }

    @Override
    public final boolean asBoolean(boolean defaultValue) {
        return this._value;
    }

    @Override
    public Optional<Boolean> asBooleanOpt() {
        return this._value ? OPT_TRUE : OPT_FALSE;
    }

    @Override
    protected Boolean _asBoolean() {
        return this._value;
    }

    @Override
    public boolean booleanValue() {
        return this._value;
    }

    @Override
    public boolean booleanValue(boolean defaultValue) {
        return this._value;
    }

    @Override
    public Optional<Boolean> booleanValueOpt() {
        return this._value ? OPT_TRUE : OPT_FALSE;
    }

    @Override
    protected String _asString() {
        return this._value ? "true" : "false";
    }

    @Override
    public final void serialize(JsonGenerator g, SerializationContext provider) throws JacksonException {
        g.writeBoolean(this._value);
    }

    @Override
    public int hashCode() {
        return this._value ? 3 : 1;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof BooleanNode) {
            BooleanNode otherNode = (BooleanNode)o;
            return this._value == otherNode._value;
        }
        return false;
    }
}

