/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.node;

import java.util.Arrays;
import java.util.Objects;
import tools.jackson.core.Base64Variants;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.node.JsonNodeType;
import tools.jackson.databind.node.ValueNode;

public class BinaryNode
extends ValueNode {
    private static final long serialVersionUID = 3L;
    static final BinaryNode EMPTY_BINARY_NODE = new BinaryNode(new byte[0]);
    protected final byte[] _data;

    public BinaryNode(byte[] data) {
        this._data = Objects.requireNonNull(data);
    }

    public BinaryNode(byte[] data, int offset, int length) {
        this._data = offset == 0 && length == data.length ? data : Arrays.copyOfRange(data, offset, offset + length);
    }

    public static BinaryNode valueOf(byte[] data) {
        if (data == null) {
            return null;
        }
        if (data.length == 0) {
            return EMPTY_BINARY_NODE;
        }
        return new BinaryNode(data);
    }

    public static BinaryNode valueOf(byte[] data, int offset, int length) {
        if (data == null) {
            return null;
        }
        if (length == 0) {
            return EMPTY_BINARY_NODE;
        }
        return new BinaryNode(data, offset, length);
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.BINARY;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.VALUE_EMBEDDED_OBJECT;
    }

    @Override
    protected String _valueDesc() {
        return "[...(" + this._data.length + " bytes)]";
    }

    @Override
    public byte[] binaryValue() {
        return this._data;
    }

    @Override
    protected String _asString() {
        return Base64Variants.getDefaultVariant().encode(this._data, false);
    }

    @Override
    public final void serialize(JsonGenerator g, SerializationContext provider) throws JacksonException {
        g.writeBinary(provider.getConfig().getBase64Variant(), this._data, 0, this._data.length);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof BinaryNode) {
            BinaryNode binaryNode = (BinaryNode)o;
            byte[] otherData = binaryNode._data;
            return Arrays.equals(this._data, otherData);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this._data.length;
    }
}

