/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonToken;
import tools.jackson.core.type.WritableTypeId;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.jsontype.TypeIdResolver;
import tools.jackson.databind.jsontype.TypeSerializer;

public class NoOpTypeSerializer
extends TypeSerializer {
    private static final NoOpTypeSerializer INSTANCE = new NoOpTypeSerializer();

    private NoOpTypeSerializer() {
    }

    public static NoOpTypeSerializer instance() {
        return INSTANCE;
    }

    @Override
    public TypeSerializer forProperty(SerializationContext ctxt, BeanProperty prop) {
        return this;
    }

    @Override
    public JsonTypeInfo.As getTypeInclusion() {
        return JsonTypeInfo.As.NOTHING;
    }

    @Override
    public String getPropertyName() {
        return null;
    }

    @Override
    public TypeIdResolver getTypeIdResolver() {
        return null;
    }

    @Override
    public WritableTypeId writeTypePrefix(JsonGenerator g, SerializationContext ctxt, WritableTypeId typeId) throws JacksonException {
        if (typeId.valueShape == JsonToken.START_OBJECT) {
            g.writeStartObject(typeId.forValue);
        } else if (typeId.valueShape == JsonToken.START_ARRAY) {
            g.writeStartArray();
        }
        typeId.wrapperWritten = false;
        return typeId;
    }

    @Override
    public WritableTypeId writeTypeSuffix(JsonGenerator g, SerializationContext ctxt, WritableTypeId typeId) throws JacksonException {
        if (typeId.valueShape == JsonToken.START_OBJECT) {
            g.writeEndObject();
        } else if (typeId.valueShape == JsonToken.START_ARRAY) {
            g.writeEndArray();
        }
        return typeId;
    }
}

