/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.introspect;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.Collections;
import java.util.List;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.PropertyMetadata;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.cfg.MapperConfig;
import tools.jackson.databind.introspect.AnnotatedMember;

public abstract class ConcreteBeanPropertyBase
implements BeanProperty {
    protected final PropertyMetadata _metadata;
    protected transient List<PropertyName> _aliases;

    protected ConcreteBeanPropertyBase(PropertyMetadata md) {
        this._metadata = md == null ? PropertyMetadata.STD_REQUIRED_OR_OPTIONAL : md;
    }

    protected ConcreteBeanPropertyBase(ConcreteBeanPropertyBase src) {
        this._metadata = src._metadata;
    }

    @Override
    public boolean isRequired() {
        return this._metadata.isRequired();
    }

    @Override
    public PropertyMetadata getMetadata() {
        return this._metadata;
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public JsonFormat.Value findFormatOverrides(MapperConfig<?> config) {
        AnnotatedMember member;
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        if (intr != null && (member = this.getMember()) != null) {
            return intr.findFormat(config, member);
        }
        return null;
    }

    @Override
    public JsonFormat.Value findPropertyFormat(MapperConfig<?> config, Class<?> baseType) {
        JsonFormat.Value format = config.getDefaultPropertyFormat(baseType);
        JsonFormat.Value overrides = this.findFormatOverrides(config);
        return overrides == null ? format : format.withOverrides(overrides);
    }

    @Override
    public List<PropertyName> findAliases(MapperConfig<?> config) {
        List<PropertyName> aliases = this._aliases;
        if (aliases == null) {
            AnnotatedMember member;
            AnnotationIntrospector intr = config.getAnnotationIntrospector();
            if (intr != null && (member = this.getMember()) != null) {
                aliases = intr.findPropertyAliases(config, member);
            }
            if (aliases == null) {
                aliases = Collections.emptyList();
            }
            this._aliases = aliases;
        }
        return aliases;
    }
}

