/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ext.javatime.deser;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.cfg.DateTimeFeature;
import tools.jackson.databind.ext.javatime.deser.JSR310DateTimeDeserializerBase;

public class MonthDeserializer
extends JSR310DateTimeDeserializerBase<Month> {
    public static final MonthDeserializer INSTANCE = new MonthDeserializer();
    private final Map<String, Month> _byNameLookup = Arrays.stream(Month.values()).collect(Collectors.toUnmodifiableMap(Enum::name, Function.identity()));

    public MonthDeserializer() {
        this((DateTimeFormatter)null);
    }

    public MonthDeserializer(DateTimeFormatter formatter) {
        super(Month.class, formatter);
    }

    protected MonthDeserializer(MonthDeserializer base, Boolean leniency) {
        super(base, leniency);
    }

    protected MonthDeserializer(MonthDeserializer base, Boolean leniency, DateTimeFormatter formatter, JsonFormat.Shape shape) {
        super(base, leniency, formatter, shape);
    }

    @Override
    protected MonthDeserializer withLeniency(Boolean leniency) {
        return new MonthDeserializer(this, leniency);
    }

    protected MonthDeserializer withDateFormat(DateTimeFormatter dtf) {
        return new MonthDeserializer(this, (Boolean)this._isLenient, dtf, this._shape);
    }

    @Override
    public Month deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        if (p.hasToken(JsonToken.VALUE_STRING)) {
            return this._fromString(p, ctxt, p.getString());
        }
        if (p.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            int monthIndex = p.getIntValue();
            if (ctxt.isEnabled(DateTimeFeature.ONE_BASED_MONTHS)) {
                return this._decode1BasedMonth(monthIndex, ctxt);
            }
            return this._decode0BasedMonth(monthIndex, ctxt);
        }
        if (p.isExpectedStartObjectToken()) {
            String str = ctxt.extractScalarFromObject(p, this, this.handledType());
            if (str != null) {
                return this._fromString(p, ctxt, str);
            }
        } else {
            if (p.isExpectedStartArrayToken()) {
                JsonToken t = p.nextToken();
                if (t == JsonToken.END_ARRAY) {
                    return null;
                }
                if ((t == JsonToken.VALUE_STRING || t == JsonToken.VALUE_EMBEDDED_OBJECT) && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                    Month parsed = this.deserialize(p, ctxt);
                    if (p.nextToken() != JsonToken.END_ARRAY) {
                        this.handleMissingEndArrayForSingle(p, ctxt);
                    }
                    return parsed;
                }
                if (t != JsonToken.VALUE_NUMBER_INT) {
                    return (Month)this._reportWrongToken(ctxt, JsonToken.VALUE_NUMBER_INT, Integer.class.getName());
                }
                int month = p.getIntValue();
                if (p.nextToken() != JsonToken.END_ARRAY) {
                    throw ctxt.wrongTokenException(p, this.handledType(), JsonToken.END_ARRAY, "Expected array to end");
                }
                return Month.of(month);
            }
            if (p.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT)) {
                return (Month)p.getEmbeddedObject();
            }
        }
        return (Month)this._handleUnexpectedToken(ctxt, p, JsonToken.VALUE_STRING, JsonToken.START_ARRAY);
    }

    /*
     * Exception decompiling
     */
    protected Month _fromString(JsonParser p, DeserializationContext ctxt, String string0) throws JacksonException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK], 1[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Month _decode1BasedMonth(int monthIndex, DeserializationContext ctxt) throws JacksonException {
        if (Month.JANUARY.getValue() <= monthIndex && monthIndex <= Month.DECEMBER.getValue()) {
            return Month.of(monthIndex);
        }
        return (Month)ctxt.handleWeirdNumberValue(this.handledType(), monthIndex, "month number outside 1-12 range for 1-based `Month`s", new Object[0]);
    }

    private Month _decode0BasedMonth(int monthIndex, DeserializationContext ctxt) throws JacksonException {
        if (monthIndex < 0 || monthIndex >= 12) {
            return (Month)ctxt.handleWeirdNumberValue(this.handledType(), monthIndex, "month number outside 0-11 range for 0-based `Month`s", new Object[0]);
        }
        return Month.values()[monthIndex];
    }
}

