/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.exc;

import java.io.Closeable;
import java.util.Collections;
import java.util.List;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DatabindException;
import tools.jackson.databind.exc.CollectedProblem;

public class DeferredBindingException
extends DatabindException {
    private static final long serialVersionUID = 1L;
    private final List<CollectedProblem> problems;
    private final boolean limitReached;

    public DeferredBindingException(JsonParser p, List<CollectedProblem> problems, boolean limitReached) {
        super((Closeable)p, DeferredBindingException.formatMessage(problems, limitReached));
        this.problems = Collections.unmodifiableList(problems);
        this.limitReached = limitReached;
    }

    public List<CollectedProblem> getProblems() {
        return this.problems;
    }

    public int getProblemCount() {
        return this.problems.size();
    }

    public boolean isLimitReached() {
        return this.limitReached;
    }

    private static String formatMessage(List<CollectedProblem> problems, boolean limitReached) {
        int count = problems.size();
        if (count == 1) {
            return "1 deserialization problem: " + problems.get(0).getMessage();
        }
        String limitNote = limitReached ? " (limit reached; more errors may exist)" : "";
        return String.format("%d deserialization problems%s (showing first 5):%n%s", count, limitNote, DeferredBindingException.formatProblems(problems));
    }

    private static String formatProblems(List<CollectedProblem> problems) {
        StringBuilder sb = new StringBuilder();
        int limit = Math.min(5, problems.size());
        for (int i = 0; i < limit; ++i) {
            CollectedProblem p = problems.get(i);
            sb.append(String.format("  [%d] at %s: %s%n", i + 1, p.getPath(), p.getMessage()));
        }
        if (problems.size() > 5) {
            sb.append(String.format("  ... and %d more", problems.size() - 5));
        }
        return sb.toString();
    }
}

