/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.exc;

import java.util.Objects;
import tools.jackson.core.JsonPointer;
import tools.jackson.core.JsonToken;
import tools.jackson.core.TokenStreamLocation;
import tools.jackson.databind.JavaType;

public final class CollectedProblem {
    private static final int MAX_RAW_VALUE_LENGTH = 200;
    private final JsonPointer path;
    private final String message;
    private final JavaType targetType;
    private final TokenStreamLocation location;
    private final Object rawValue;
    private final JsonToken token;

    public CollectedProblem(JsonPointer path, String message, JavaType targetType, TokenStreamLocation location, Object rawValue, JsonToken token) {
        this.path = Objects.requireNonNull(path, "path");
        this.message = Objects.requireNonNull(message, "message");
        this.targetType = targetType;
        this.location = location;
        this.rawValue = CollectedProblem.truncateIfNeeded(rawValue);
        this.token = token;
    }

    public JsonPointer getPath() {
        return this.path;
    }

    public String getMessage() {
        return this.message;
    }

    public JavaType getTargetType() {
        return this.targetType;
    }

    public TokenStreamLocation getLocation() {
        return this.location;
    }

    public Object getRawValue() {
        return this.rawValue;
    }

    public JsonToken getToken() {
        return this.token;
    }

    private static Object truncateIfNeeded(Object value) {
        String s;
        if (value instanceof String && (s = (String)value).length() > 200) {
            return s.substring(0, 197) + "...";
        }
        return value;
    }

    public String toString() {
        return String.format("CollectedProblem[path=%s, message=%s, targetType=%s]", this.path, this.message, this.targetType);
    }
}

