/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.deser.std;

import java.util.function.BiFunction;
import java.util.function.Function;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.cfg.CoercionAction;
import tools.jackson.databind.cfg.CoercionInputShape;
import tools.jackson.databind.deser.std.StdScalarDeserializer;
import tools.jackson.databind.type.LogicalType;
import tools.jackson.databind.util.ExceptionUtil;

public class FunctionalScalarDeserializer<T>
extends StdScalarDeserializer<T> {
    protected final BiFunction<JsonParser, DeserializationContext, T> _biFunction;
    protected final Function<String, T> _stringFunction;

    public FunctionalScalarDeserializer(Class<T> type, BiFunction<JsonParser, DeserializationContext, T> function) {
        super(type);
        this._biFunction = function;
        this._stringFunction = null;
    }

    public FunctionalScalarDeserializer(JavaType type, BiFunction<JsonParser, DeserializationContext, T> function) {
        super(type);
        this._biFunction = function;
        this._stringFunction = null;
    }

    public FunctionalScalarDeserializer(Class<T> type, Function<String, T> function) {
        super(type);
        this._biFunction = null;
        this._stringFunction = function;
    }

    public FunctionalScalarDeserializer(JavaType type, Function<String, T> function) {
        super(type);
        this._biFunction = null;
        this._stringFunction = function;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.OtherScalar;
    }

    @Override
    public T deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        if (this._biFunction != null) {
            try {
                return this._biFunction.apply(p, ctxt);
            }
            catch (Exception e) {
                return this._handleException(p, ctxt, e);
            }
        }
        String text = p.getValueAsString();
        if (text == null) {
            JsonToken t = p.currentToken();
            if (t == JsonToken.START_OBJECT) {
                text = ctxt.extractScalarFromObject(p, this, this._valueClass);
                if (text == null) {
                    return (T)ctxt.handleUnexpectedToken(this.getValueType(ctxt), p);
                }
            } else {
                return (T)ctxt.handleUnexpectedToken(this.getValueType(ctxt), p);
            }
        }
        if (text.isEmpty()) {
            return (T)this._deserializeFromEmptyString(ctxt);
        }
        try {
            return this._stringFunction.apply(text);
        }
        catch (Exception e) {
            return this._handleException(text, ctxt, e);
        }
    }

    private T _handleException(JsonParser p, DeserializationContext ctxt, Exception e) throws JacksonException {
        if (e instanceof JacksonException) {
            JacksonException je = (JacksonException)((Object)e);
            throw je;
        }
        return this._handleException(p.getValueAsString(), ctxt, e);
    }

    private T _handleException(String text, DeserializationContext ctxt, Exception e) throws JacksonException {
        e = ExceptionUtil.rethrowIfNoWrap(ctxt, e);
        Object msg = "not a valid textual representation";
        String m2 = e.getMessage();
        if (m2 != null) {
            msg = (String)msg + ", problem: " + m2;
        }
        throw ctxt.weirdStringException(text, this._valueClass, (String)msg).withCause(e);
    }

    private Object _deserializeFromEmptyString(DeserializationContext ctxt) throws JacksonException {
        CoercionAction act = ctxt.findCoercionAction(this.logicalType(), this._valueClass, CoercionInputShape.EmptyString);
        if (act == CoercionAction.Fail) {
            ctxt.reportInputMismatch(this, "Cannot coerce empty String (\"\") to %s (but could if enabling coercion using `CoercionConfig`)", this._coercedTypeDesc());
        }
        if (act == CoercionAction.AsEmpty) {
            return this.getEmptyValue(ctxt);
        }
        return this.getNullValue(ctxt);
    }
}

