/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.deser.jdk;

import com.fasterxml.jackson.annotation.JsonFormat;
import tools.jackson.databind.deser.std.FromStringWithRadixToNumberDeserializer;
import tools.jackson.databind.deser.std.StdDeserializer;
import tools.jackson.databind.deser.std.StdScalarDeserializer;

public class RadixDeserializerFactory {
    public static StdDeserializer<? extends Number> createRadixStringDeserializer(StdScalarDeserializer<? extends Number> initialDeser, JsonFormat.Value formatOverrides) {
        if (formatOverrides != null && formatOverrides.getShape() == JsonFormat.Shape.STRING && RadixDeserializerFactory.isSerializeWithRadixOverride(formatOverrides)) {
            int radix = formatOverrides.getRadix();
            return new FromStringWithRadixToNumberDeserializer(initialDeser, radix);
        }
        return initialDeser;
    }

    private static boolean isSerializeWithRadixOverride(JsonFormat.Value format) {
        return format.hasNonDefaultRadix();
    }
}

