/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.deser.jdk;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractMap;
import java.util.Map;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DatabindException;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.KeyDeserializer;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.annotation.JacksonStdImpl;
import tools.jackson.databind.deser.ContextualKeyDeserializer;
import tools.jackson.databind.deser.std.ContainerDeserializerBase;
import tools.jackson.databind.deser.std.StdDeserializer;
import tools.jackson.databind.jsontype.TypeDeserializer;
import tools.jackson.databind.type.LogicalType;
import tools.jackson.databind.util.ClassUtil;

@JacksonStdImpl
public class MapEntryDeserializer
extends ContainerDeserializerBase<Map.Entry<Object, Object>> {
    protected final KeyDeserializer _keyDeserializer;
    protected final ValueDeserializer<Object> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;

    public MapEntryDeserializer(JavaType type, KeyDeserializer keyDeser, ValueDeserializer<Object> valueDeser, TypeDeserializer valueTypeDeser) {
        super(type);
        if (type.containedTypeCount() != 2) {
            throw new IllegalArgumentException("Missing generic type information for " + String.valueOf(type));
        }
        this._keyDeserializer = keyDeser;
        this._valueDeserializer = valueDeser;
        this._valueTypeDeserializer = valueTypeDeser;
    }

    protected MapEntryDeserializer(MapEntryDeserializer src, KeyDeserializer keyDeser, ValueDeserializer<Object> valueDeser, TypeDeserializer valueTypeDeser) {
        super(src);
        this._keyDeserializer = keyDeser;
        this._valueDeserializer = valueDeser;
        this._valueTypeDeserializer = valueTypeDeser;
    }

    public static ValueDeserializer<Object> construct(DeserializationContext ctxt, JavaType entryType, boolean pojoWrappedFormat) {
        StdDeserializer deser = pojoWrappedFormat ? MapEntryDeserializer.constructAsPOJO(ctxt, entryType) : MapEntryDeserializer.constructDefault(ctxt, entryType);
        return deser;
    }

    protected static MapEntryDeserializer constructDefault(DeserializationContext ctxt, JavaType entryType) {
        JavaType keyType = entryType.containedTypeOrUnknown(0);
        JavaType valueType = entryType.containedTypeOrUnknown(1);
        TypeDeserializer vts = (TypeDeserializer)valueType.getTypeHandler();
        if (vts == null) {
            vts = ctxt.findTypeDeserializer(valueType);
        }
        ValueDeserializer valueDeser = (ValueDeserializer)valueType.getValueHandler();
        KeyDeserializer keyDes = (KeyDeserializer)keyType.getValueHandler();
        return new MapEntryDeserializer(entryType, keyDes, (ValueDeserializer<Object>)valueDeser, vts);
    }

    protected static POJOWrappedDeserializer constructAsPOJO(DeserializationContext ctxt, JavaType entryType) {
        return new POJOWrappedDeserializer(entryType);
    }

    protected MapEntryDeserializer withResolved(KeyDeserializer keyDeser, TypeDeserializer valueTypeDeser, ValueDeserializer<?> valueDeser) {
        if (this._keyDeserializer == keyDeser && this._valueDeserializer == valueDeser && this._valueTypeDeserializer == valueTypeDeser) {
            return this;
        }
        return new MapEntryDeserializer(this, keyDeser, valueDeser, valueTypeDeser);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Map;
    }

    @Override
    public ValueDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
        if (Boolean.TRUE.equals(MapEntryDeserializer._shouldDeserializeAsPOJO(ctxt, property))) {
            return MapEntryDeserializer.constructAsPOJO(ctxt, this._containerType)._createContextual2(ctxt, property);
        }
        return this._createContextual2(ctxt, property);
    }

    protected ValueDeserializer<?> _createContextual2(DeserializationContext ctxt, BeanProperty property) {
        KeyDeserializer kd = this._keyDeserializer;
        if (kd == null) {
            kd = ctxt.findKeyDeserializer(this._containerType.containedType(0), property);
        } else if (kd instanceof ContextualKeyDeserializer) {
            ContextualKeyDeserializer ckd = (ContextualKeyDeserializer)((Object)kd);
            kd = ckd.createContextual(ctxt, property);
        }
        ValueDeserializer<Object> vd = this._valueDeserializer;
        vd = this.findConvertingContentDeserializer(ctxt, property, vd);
        JavaType contentType = this._containerType.containedType(1);
        vd = vd == null ? ctxt.findContextualValueDeserializer(contentType, property) : ctxt.handleSecondaryContextualization(vd, property, contentType);
        TypeDeserializer vtd = this._valueTypeDeserializer;
        if (vtd != null) {
            vtd = vtd.forProperty(property);
        }
        return this.withResolved(kd, vtd, vd);
    }

    protected static Boolean _shouldDeserializeAsPOJO(DeserializationContext ctxt, BeanProperty property) {
        if (property != null) {
            JsonFormat.Value format = property.findPropertyFormat(ctxt.getConfig(), Map.Entry.class);
            switch (format.getShape()) {
                case NATURAL: {
                    return false;
                }
                case POJO: {
                    return true;
                }
            }
        }
        return null;
    }

    @Override
    public JavaType getContentType() {
        return this._containerType.containedType(1);
    }

    @Override
    public ValueDeserializer<Object> getContentDeserializer() {
        return this._valueDeserializer;
    }

    @Override
    public Map.Entry<Object, Object> deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        JsonToken t = p.currentToken();
        if (t == JsonToken.START_OBJECT) {
            t = p.nextToken();
        } else if (t != JsonToken.PROPERTY_NAME && t != JsonToken.END_OBJECT) {
            if (t == JsonToken.START_ARRAY) {
                return (Map.Entry)this._deserializeFromArray(p, ctxt);
            }
            return (Map.Entry)ctxt.handleUnexpectedToken(this.getValueType(ctxt), p);
        }
        if (t != JsonToken.PROPERTY_NAME) {
            if (t == JsonToken.END_OBJECT) {
                return (Map.Entry)ctxt.reportInputMismatch(this, "Cannot deserialize a `Map.Entry` out of empty Object", new Object[0]);
            }
            return (Map.Entry)ctxt.handleUnexpectedToken(this.getValueType(ctxt), p);
        }
        KeyDeserializer keyDes = this._keyDeserializer;
        ValueDeserializer<Object> valueDes = this._valueDeserializer;
        TypeDeserializer typeDeser = this._valueTypeDeserializer;
        String keyStr = p.currentName();
        Object key = keyDes.deserializeKey(keyStr, ctxt);
        Object value = null;
        t = p.nextToken();
        try {
            value = t == JsonToken.VALUE_NULL ? valueDes.getNullValue(ctxt) : (typeDeser == null ? valueDes.deserialize(p, ctxt) : valueDes.deserializeWithType(p, ctxt, typeDeser));
        }
        catch (Exception e) {
            this.wrapAndThrow(ctxt, e, Map.Entry.class, keyStr);
        }
        t = p.nextToken();
        if (t != JsonToken.END_OBJECT) {
            if (t == JsonToken.PROPERTY_NAME) {
                ctxt.reportInputMismatch(this, "Problem binding JSON into Map.Entry: more than one entry in JSON (second field: '%s')", p.currentName());
            } else {
                ctxt.reportInputMismatch(this, "Problem binding JSON into Map.Entry: unexpected content after JSON Object entry: " + String.valueOf(t), new Object[0]);
            }
            return null;
        }
        return new AbstractMap.SimpleEntry<Object, Object>(key, value);
    }

    @Override
    public Map.Entry<Object, Object> deserialize(JsonParser p, DeserializationContext ctxt, Map.Entry<Object, Object> result) throws JacksonException {
        throw new IllegalStateException("Cannot update Map.Entry values");
    }

    @Override
    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws JacksonException {
        return typeDeserializer.deserializeTypedFromObject(p, ctxt);
    }

    protected static class POJOWrappedDeserializer
    extends StdDeserializer<Map.Entry<Object, Object>> {
        protected final ValueDeserializer<Object> _keyDeserializer;
        protected final TypeDeserializer _keyTypeDeserializer;
        protected final ValueDeserializer<Object> _valueDeserializer;
        protected final TypeDeserializer _valueTypeDeserializer;

        public POJOWrappedDeserializer(JavaType type) {
            super(type);
            this._keyDeserializer = null;
            this._keyTypeDeserializer = null;
            this._valueDeserializer = null;
            this._valueTypeDeserializer = null;
        }

        protected POJOWrappedDeserializer(POJOWrappedDeserializer src, ValueDeserializer<Object> keyDeser, TypeDeserializer valueTypeDeser, ValueDeserializer<Object> valueDeser, TypeDeserializer keyTypeDeser) {
            super(src);
            this._keyDeserializer = keyDeser;
            this._keyTypeDeserializer = keyTypeDeser;
            this._valueDeserializer = valueDeser;
            this._valueTypeDeserializer = valueTypeDeser;
        }

        protected POJOWrappedDeserializer withResolved(ValueDeserializer<?> keyDeser, TypeDeserializer keyTypeDeser, ValueDeserializer<?> valueDeser, TypeDeserializer valueTypeDeser) {
            if (this._keyDeserializer == keyDeser && this._keyTypeDeserializer == keyTypeDeser && this._valueDeserializer == valueDeser && this._valueTypeDeserializer == valueTypeDeser) {
                return this;
            }
            return new POJOWrappedDeserializer(this, keyDeser, keyTypeDeser, valueDeser, valueTypeDeser);
        }

        @Override
        public LogicalType logicalType() {
            return LogicalType.POJO;
        }

        @Override
        public ValueDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
            if (Boolean.FALSE.equals(MapEntryDeserializer._shouldDeserializeAsPOJO(ctxt, property))) {
                return MapEntryDeserializer.constructAsPOJO(ctxt, this._valueType)._createContextual2(ctxt, property);
            }
            return this._createContextual2(ctxt, property);
        }

        protected ValueDeserializer<?> _createContextual2(DeserializationContext ctxt, BeanProperty property) {
            ValueDeserializer<Object> kd = this._keyDeserializer;
            kd = this.findConvertingContentDeserializer(ctxt, property, kd);
            JavaType keyType = this._valueType.containedTypeOrUnknown(0);
            kd = kd == null ? ctxt.findContextualValueDeserializer(keyType, property) : ctxt.handleSecondaryContextualization(kd, property, keyType);
            TypeDeserializer ktd = this._keyTypeDeserializer;
            if (ktd != null) {
                ktd = ktd.forProperty(property);
            }
            ValueDeserializer<Object> vd = this._valueDeserializer;
            vd = this.findConvertingContentDeserializer(ctxt, property, vd);
            JavaType valueType = this._valueType.containedType(1);
            vd = vd == null ? ctxt.findContextualValueDeserializer(valueType, property) : ctxt.handleSecondaryContextualization(vd, property, valueType);
            TypeDeserializer vtd = this._valueTypeDeserializer;
            if (vtd != null) {
                vtd = vtd.forProperty(property);
            }
            return this.withResolved(kd, ktd, vd, vtd);
        }

        @Override
        public Map.Entry<Object, Object> deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
            JsonToken t = p.currentToken();
            if (t == JsonToken.START_OBJECT) {
                t = p.nextToken();
            } else if (t != JsonToken.PROPERTY_NAME && t != JsonToken.END_OBJECT) {
                if (t == JsonToken.START_ARRAY) {
                    return (Map.Entry)this._deserializeFromArray(p, ctxt);
                }
                return (Map.Entry)ctxt.handleUnexpectedToken(this._valueType, p);
            }
            Object key = null;
            Object value = null;
            while (t == JsonToken.PROPERTY_NAME) {
                block18: {
                    String propName = p.currentName();
                    t = p.nextToken();
                    if ("key".equals(propName)) {
                        try {
                            if (t == JsonToken.VALUE_NULL) {
                                key = this._keyDeserializer.getNullValue(ctxt);
                                break block18;
                            }
                            if (this._keyTypeDeserializer != null) {
                                key = this._keyDeserializer.deserializeWithType(p, ctxt, this._keyTypeDeserializer);
                                break block18;
                            }
                            key = this._keyDeserializer.deserialize(p, ctxt);
                        }
                        catch (Exception e) {
                            this.wrapAndThrow(ctxt, e, Map.Entry.class, propName);
                        }
                    } else if ("value".equals(propName)) {
                        try {
                            if (t == JsonToken.VALUE_NULL) {
                                value = this._valueDeserializer.getNullValue(ctxt);
                                break block18;
                            }
                            if (this._valueTypeDeserializer != null) {
                                value = this._valueDeserializer.deserializeWithType(p, ctxt, this._valueTypeDeserializer);
                                break block18;
                            }
                            value = this._valueDeserializer.deserialize(p, ctxt);
                        }
                        catch (Exception e) {
                            this.wrapAndThrow(ctxt, e, Map.Entry.class, propName);
                        }
                    } else {
                        this.handleUnknownProperty(p, ctxt, this._valueType, propName);
                    }
                }
                t = p.nextToken();
            }
            if (t != JsonToken.END_OBJECT) {
                ctxt.reportInputMismatch(this, "Problem deserializing `Map.Entry`; unexpected content after Object value: " + JsonToken.valueDescFor((JsonToken)t), new Object[0]);
            }
            return new AbstractMap.SimpleEntry<Object, Object>(key, value);
        }

        @Override
        public Map.Entry<Object, Object> deserialize(JsonParser p, DeserializationContext ctxt, Map.Entry<Object, Object> result) throws JacksonException {
            throw new IllegalStateException("Cannot update `Map.Entry` values");
        }

        @Override
        public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws JacksonException {
            return typeDeserializer.deserializeTypedFromObject(p, ctxt);
        }

        protected <BOGUS> BOGUS wrapAndThrow(DeserializationContext ctxt, Throwable t, Object ref, String key) throws JacksonException {
            while (t instanceof InvocationTargetException && t.getCause() != null) {
                t = t.getCause();
            }
            ClassUtil.throwIfError(t);
            if (!ctxt.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS)) {
                ClassUtil.throwIfRTE(t);
            }
            throw DatabindException.wrapWithPath(ctxt, t, new JacksonException.Reference(ref, ClassUtil.nonNull(key, "N/A")));
        }
    }
}

