/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.deser;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import tools.jackson.core.JsonParser;
import tools.jackson.core.TokenStreamLocation;
import tools.jackson.databind.DatabindException;
import tools.jackson.databind.deser.ReadableObjectId;
import tools.jackson.databind.deser.UnresolvedId;

public class UnresolvedForwardReference
extends DatabindException {
    private static final long serialVersionUID = 1L;
    private ReadableObjectId _roid;
    private List<UnresolvedId> _unresolvedIds;

    public UnresolvedForwardReference(JsonParser p, String msg, TokenStreamLocation loc, ReadableObjectId roid) {
        super((Closeable)p, msg, loc);
        this._roid = roid;
    }

    public UnresolvedForwardReference(JsonParser p, String msg) {
        super((Closeable)p, msg);
        this._unresolvedIds = new ArrayList<UnresolvedId>();
    }

    public ReadableObjectId getRoid() {
        return this._roid;
    }

    public Object getUnresolvedId() {
        return this._roid.getKey().key;
    }

    public void addUnresolvedId(Object id, Class<?> type, TokenStreamLocation where) {
        this._unresolvedIds.add(new UnresolvedId(id, type, where));
    }

    public List<UnresolvedId> getUnresolvedIds() {
        return this._unresolvedIds;
    }

    public String getMessage() {
        String msg = super.getOriginalMessage();
        if (this._unresolvedIds == null) {
            return msg;
        }
        StringBuilder sb = new StringBuilder(msg);
        if (!msg.endsWith(" ")) {
            sb.append(' ');
        }
        sb.append('[');
        Iterator<UnresolvedId> iterator = this._unresolvedIds.iterator();
        while (iterator.hasNext()) {
            UnresolvedId unresolvedId = iterator.next();
            sb.append(unresolvedId.descForException());
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }

    public synchronized UnresolvedForwardReference fillInStackTrace() {
        return this;
    }

    public UnresolvedForwardReference withStackTrace() {
        super.fillInStackTrace();
        return this;
    }
}

