/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.deser;

import java.util.List;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonPointer;
import tools.jackson.core.JsonToken;
import tools.jackson.core.TokenStreamLocation;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.deser.DeserializationProblemHandler;
import tools.jackson.databind.exc.CollectedProblem;
import tools.jackson.databind.util.ClassUtil;

public class CollectingProblemHandler
extends DeserializationProblemHandler {
    public static final int DEFAULT_MAX_PROBLEMS = 100;
    private static final Object ATTR_KEY = CollectingProblemHandler.class;
    private final int _maxProblems;

    public CollectingProblemHandler() {
        this(100);
    }

    public CollectingProblemHandler(int maxProblems) {
        if (maxProblems <= 0) {
            throw new IllegalArgumentException("maxProblems must be positive, was: " + maxProblems);
        }
        this._maxProblems = maxProblems;
    }

    public int getMaxProblems() {
        return this._maxProblems;
    }

    public static List<CollectedProblem> getBucket(DeserializationContext ctxt) {
        Object attr = ctxt.getAttribute(ATTR_KEY);
        return attr instanceof List ? (List)attr : null;
    }

    private boolean recordProblem(DeserializationContext ctxt, String message, JavaType targetType, Object rawValue) {
        List<CollectedProblem> bucket = CollectingProblemHandler.getBucket(ctxt);
        if (bucket == null) {
            return false;
        }
        if (bucket.size() >= this._maxProblems) {
            return false;
        }
        JsonParser p = ctxt.getParser();
        JsonPointer path = this.buildJsonPointer(p);
        TokenStreamLocation location = this.safeGetLocation(p);
        JsonToken token = this.safeGetToken(p);
        bucket.add(new CollectedProblem(path, message, targetType, location, rawValue, token));
        return true;
    }

    private TokenStreamLocation safeGetLocation(JsonParser p) {
        return p != null ? p.currentTokenLocation() : null;
    }

    private JsonToken safeGetToken(JsonParser p) {
        return p != null ? p.currentToken() : null;
    }

    private JsonPointer buildJsonPointer(JsonParser p) {
        if (p == null) {
            return JsonPointer.empty();
        }
        return p.streamReadContext().pathAsPointer();
    }

    @Override
    public boolean handleUnknownProperty(DeserializationContext ctxt, JsonParser p, ValueDeserializer<?> deserializer, Object beanOrClass, String propertyName) throws JacksonException {
        String message = String.format("Unknown property '%s' for type %s", propertyName, ClassUtil.getClassDescription(beanOrClass));
        if (this.recordProblem(ctxt, message, null, null)) {
            p.skipChildren();
            return true;
        }
        return false;
    }

    @Override
    public Object handleWeirdKey(DeserializationContext ctxt, Class<?> rawKeyType, String keyValue, String failureMsg) throws JacksonException {
        String message = String.format("Cannot deserialize Map key '%s' to %s: %s", keyValue, ClassUtil.getClassDescription(rawKeyType), failureMsg);
        if (this.recordProblem(ctxt, message, ctxt.constructType(rawKeyType), keyValue)) {
            return NOT_HANDLED;
        }
        return NOT_HANDLED;
    }

    @Override
    public Object handleWeirdStringValue(DeserializationContext ctxt, Class<?> targetType, String valueToConvert, String failureMsg) throws JacksonException {
        String message = String.format("Cannot deserialize value '%s' to %s: %s", valueToConvert, ClassUtil.getClassDescription(targetType), failureMsg);
        if (this.recordProblem(ctxt, message, ctxt.constructType(targetType), valueToConvert)) {
            return this.getDefaultValue(targetType);
        }
        return NOT_HANDLED;
    }

    @Override
    public Object handleWeirdNumberValue(DeserializationContext ctxt, Class<?> targetType, Number valueToConvert, String failureMsg) throws JacksonException {
        String message = String.format("Cannot deserialize number %s to %s: %s", valueToConvert, ClassUtil.getClassDescription(targetType), failureMsg);
        if (this.recordProblem(ctxt, message, ctxt.constructType(targetType), valueToConvert)) {
            return this.getDefaultValue(targetType);
        }
        return NOT_HANDLED;
    }

    @Override
    public Object handleInstantiationProblem(DeserializationContext ctxt, Class<?> instClass, Object argument, Throwable t) throws JacksonException {
        String message = String.format("Cannot instantiate %s: %s", ClassUtil.getClassDescription(instClass), t.getMessage());
        if (this.recordProblem(ctxt, message, ctxt.constructType(instClass), argument) && !instClass.isPrimitive()) {
            return null;
        }
        return NOT_HANDLED;
    }

    private Object getDefaultValue(Class<?> type) {
        if (type.isPrimitive()) {
            return ClassUtil.defaultValue(type);
        }
        return null;
    }
}

