/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.cfg;

import java.io.Serializable;
import tools.jackson.core.FormatSchema;
import tools.jackson.core.PrettyPrinter;
import tools.jackson.core.SerializableString;
import tools.jackson.core.io.CharacterEscapes;
import tools.jackson.core.io.SerializedString;
import tools.jackson.core.util.Instantiatable;

public final class GeneratorSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final GeneratorSettings EMPTY = new GeneratorSettings(null, null, null, null);
    protected static final SerializedString NULL_ROOT_VALUE_SEPARATOR = new SerializedString("");
    public static final GeneratorSettings empty = new GeneratorSettings(null, null, null, null);
    public final PrettyPrinter prettyPrinter;
    public final FormatSchema schema;
    public final CharacterEscapes characterEscapes;
    public final SerializableString rootValueSeparator;

    public GeneratorSettings(PrettyPrinter pp, FormatSchema sch, CharacterEscapes esc, SerializableString rootSep) {
        this.prettyPrinter = pp;
        this.schema = sch;
        this.characterEscapes = esc;
        this.rootValueSeparator = rootSep;
    }

    public static GeneratorSettings empty() {
        return EMPTY;
    }

    public GeneratorSettings with(PrettyPrinter pp) {
        return pp == this.prettyPrinter ? this : new GeneratorSettings(pp, this.schema, this.characterEscapes, this.rootValueSeparator);
    }

    public GeneratorSettings with(FormatSchema sch) {
        return this.schema == sch ? this : new GeneratorSettings(this.prettyPrinter, sch, this.characterEscapes, this.rootValueSeparator);
    }

    public GeneratorSettings with(CharacterEscapes esc) {
        return this.characterEscapes == esc ? this : new GeneratorSettings(this.prettyPrinter, this.schema, esc, this.rootValueSeparator);
    }

    public GeneratorSettings withRootValueSeparator(String sep) {
        if (sep == null) {
            if (this.rootValueSeparator == NULL_ROOT_VALUE_SEPARATOR) {
                return this;
            }
            return new GeneratorSettings(this.prettyPrinter, this.schema, this.characterEscapes, (SerializableString)NULL_ROOT_VALUE_SEPARATOR);
        }
        if (sep.equals(this._rootValueSeparatorAsString())) {
            return this;
        }
        return new GeneratorSettings(this.prettyPrinter, this.schema, this.characterEscapes, (SerializableString)new SerializedString(sep));
    }

    public GeneratorSettings withRootValueSeparator(SerializableString sep) {
        if (sep == null) {
            if (this.rootValueSeparator == null) {
                return this;
            }
            return new GeneratorSettings(this.prettyPrinter, this.schema, this.characterEscapes, null);
        }
        if (sep.equals(this.rootValueSeparator)) {
            return this;
        }
        return new GeneratorSettings(this.prettyPrinter, this.schema, this.characterEscapes, sep);
    }

    private final String _rootValueSeparatorAsString() {
        return this.rootValueSeparator == null ? null : this.rootValueSeparator.getValue();
    }

    public FormatSchema getSchema() {
        return this.schema;
    }

    public CharacterEscapes getCharacterEscapes() {
        return this.characterEscapes;
    }

    public PrettyPrinter getPrettyPrinter() {
        PrettyPrinter pp = this.prettyPrinter;
        if (pp != null) {
            if (pp instanceof Instantiatable) {
                Instantiatable pInstantiatable = (Instantiatable)pp;
                pp = (PrettyPrinter)pInstantiatable.createInstance();
            }
            return pp;
        }
        return null;
    }

    public boolean hasPrettyPrinter() {
        return this.prettyPrinter != null;
    }

    public SerializableString getRootValueSeparator(SerializableString defaultSep) {
        if (this.rootValueSeparator == null) {
            return defaultSep;
        }
        if (this.rootValueSeparator == NULL_ROOT_VALUE_SEPARATOR) {
            return null;
        }
        return this.rootValueSeparator;
    }
}

