/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.cfg;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Locale;
import java.util.TimeZone;
import tools.jackson.core.Base64Variant;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.EnumNamingStrategy;
import tools.jackson.databind.PropertyNamingStrategy;
import tools.jackson.databind.cfg.CacheProvider;
import tools.jackson.databind.cfg.ConstructorDetector;
import tools.jackson.databind.cfg.HandlerInstantiator;
import tools.jackson.databind.introspect.AccessorNamingStrategy;
import tools.jackson.databind.introspect.AnnotationIntrospectorPair;
import tools.jackson.databind.jsontype.PolymorphicTypeValidator;
import tools.jackson.databind.jsontype.TypeResolverBuilder;
import tools.jackson.databind.node.JsonNodeFactory;
import tools.jackson.databind.util.StdDateFormat;

public final class BaseSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final TimeZone DEFAULT_TIMEZONE = TimeZone.getTimeZone("UTC");
    protected final AnnotationIntrospector _annotationIntrospector;
    protected final PropertyNamingStrategy _propertyNamingStrategy;
    protected final EnumNamingStrategy _enumNamingStrategy;
    protected final AccessorNamingStrategy.Provider _accessorNaming;
    protected final TypeResolverBuilder<?> _defaultTyper;
    protected final PolymorphicTypeValidator _typeValidator;
    protected final DateFormat _dateFormat;
    protected final HandlerInstantiator _handlerInstantiator;
    protected final Locale _locale;
    protected final TimeZone _timeZone;
    protected final Base64Variant _defaultBase64;
    protected final CacheProvider _cacheProvider;
    protected final JsonNodeFactory _nodeFactory;
    protected final ConstructorDetector _ctorDetector;

    public BaseSettings(AnnotationIntrospector ai, PropertyNamingStrategy pns, EnumNamingStrategy ens, AccessorNamingStrategy.Provider accNaming, TypeResolverBuilder<?> defaultTyper, PolymorphicTypeValidator ptv, DateFormat dateFormat, HandlerInstantiator hi, Locale locale, TimeZone tz, Base64Variant defaultBase64, CacheProvider cacheProvider, JsonNodeFactory nodeFactory, ConstructorDetector ctorDetector) {
        this._annotationIntrospector = ai;
        this._propertyNamingStrategy = pns;
        this._enumNamingStrategy = ens;
        this._accessorNaming = accNaming;
        this._defaultTyper = defaultTyper;
        this._typeValidator = ptv;
        this._dateFormat = dateFormat;
        this._handlerInstantiator = hi;
        this._locale = locale;
        this._timeZone = tz;
        this._defaultBase64 = defaultBase64;
        this._cacheProvider = cacheProvider;
        this._nodeFactory = nodeFactory;
        this._ctorDetector = ctorDetector;
    }

    public BaseSettings withAnnotationIntrospector(AnnotationIntrospector ai) {
        if (this._annotationIntrospector == ai) {
            return this;
        }
        return new BaseSettings(ai, this._propertyNamingStrategy, this._enumNamingStrategy, this._accessorNaming, this._defaultTyper, this._typeValidator, this._dateFormat, this._handlerInstantiator, this._locale, this._timeZone, this._defaultBase64, this._cacheProvider, this._nodeFactory, this._ctorDetector);
    }

    public BaseSettings withInsertedAnnotationIntrospector(AnnotationIntrospector ai) {
        return this.withAnnotationIntrospector(AnnotationIntrospectorPair.create(ai, this._annotationIntrospector));
    }

    public BaseSettings withAppendedAnnotationIntrospector(AnnotationIntrospector ai) {
        return this.withAnnotationIntrospector(AnnotationIntrospectorPair.create(this._annotationIntrospector, ai));
    }

    public BaseSettings with(PropertyNamingStrategy pns) {
        if (this._propertyNamingStrategy == pns) {
            return this;
        }
        return new BaseSettings(this._annotationIntrospector, pns, this._enumNamingStrategy, this._accessorNaming, this._defaultTyper, this._typeValidator, this._dateFormat, this._handlerInstantiator, this._locale, this._timeZone, this._defaultBase64, this._cacheProvider, this._nodeFactory, this._ctorDetector);
    }

    public BaseSettings with(EnumNamingStrategy ens) {
        if (this._enumNamingStrategy == ens) {
            return this;
        }
        return new BaseSettings(this._annotationIntrospector, this._propertyNamingStrategy, ens, this._accessorNaming, this._defaultTyper, this._typeValidator, this._dateFormat, this._handlerInstantiator, this._locale, this._timeZone, this._defaultBase64, this._cacheProvider, this._nodeFactory, this._ctorDetector);
    }

    public BaseSettings with(AccessorNamingStrategy.Provider p) {
        if (this._accessorNaming == p) {
            return this;
        }
        return new BaseSettings(this._annotationIntrospector, this._propertyNamingStrategy, this._enumNamingStrategy, p, this._defaultTyper, this._typeValidator, this._dateFormat, this._handlerInstantiator, this._locale, this._timeZone, this._defaultBase64, this._cacheProvider, this._nodeFactory, this._ctorDetector);
    }

    public BaseSettings with(TypeResolverBuilder<?> typer) {
        if (this._defaultTyper == typer) {
            return this;
        }
        return new BaseSettings(this._annotationIntrospector, this._propertyNamingStrategy, this._enumNamingStrategy, this._accessorNaming, typer, this._typeValidator, this._dateFormat, this._handlerInstantiator, this._locale, this._timeZone, this._defaultBase64, this._cacheProvider, this._nodeFactory, this._ctorDetector);
    }

    public BaseSettings with(PolymorphicTypeValidator ptv) {
        if (this._typeValidator == ptv) {
            return this;
        }
        return new BaseSettings(this._annotationIntrospector, this._propertyNamingStrategy, this._enumNamingStrategy, this._accessorNaming, this._defaultTyper, ptv, this._dateFormat, this._handlerInstantiator, this._locale, this._timeZone, this._defaultBase64, this._cacheProvider, this._nodeFactory, this._ctorDetector);
    }

    public BaseSettings with(DateFormat df) {
        if (this._dateFormat == df) {
            return this;
        }
        if (df != null && this.hasExplicitTimeZone()) {
            df = this._force(df, this._timeZone);
        }
        return new BaseSettings(this._annotationIntrospector, this._propertyNamingStrategy, this._enumNamingStrategy, this._accessorNaming, this._defaultTyper, this._typeValidator, df, this._handlerInstantiator, this._locale, this._timeZone, this._defaultBase64, this._cacheProvider, this._nodeFactory, this._ctorDetector);
    }

    public BaseSettings with(HandlerInstantiator hi) {
        if (this._handlerInstantiator == hi) {
            return this;
        }
        return new BaseSettings(this._annotationIntrospector, this._propertyNamingStrategy, this._enumNamingStrategy, this._accessorNaming, this._defaultTyper, this._typeValidator, this._dateFormat, hi, this._locale, this._timeZone, this._defaultBase64, this._cacheProvider, this._nodeFactory, this._ctorDetector);
    }

    public BaseSettings with(Locale l) {
        if (this._locale == l) {
            return this;
        }
        return new BaseSettings(this._annotationIntrospector, this._propertyNamingStrategy, this._enumNamingStrategy, this._accessorNaming, this._defaultTyper, this._typeValidator, this._dateFormat, this._handlerInstantiator, l, this._timeZone, this._defaultBase64, this._cacheProvider, this._nodeFactory, this._ctorDetector);
    }

    public BaseSettings with(TimeZone tz) {
        if (tz == this._timeZone) {
            return this;
        }
        DateFormat df = this._force(this._dateFormat, tz == null ? DEFAULT_TIMEZONE : tz);
        return new BaseSettings(this._annotationIntrospector, this._propertyNamingStrategy, this._enumNamingStrategy, this._accessorNaming, this._defaultTyper, this._typeValidator, df, this._handlerInstantiator, this._locale, tz, this._defaultBase64, this._cacheProvider, this._nodeFactory, this._ctorDetector);
    }

    public BaseSettings with(Base64Variant base64) {
        if (base64 == this._defaultBase64) {
            return this;
        }
        return new BaseSettings(this._annotationIntrospector, this._propertyNamingStrategy, this._enumNamingStrategy, this._accessorNaming, this._defaultTyper, this._typeValidator, this._dateFormat, this._handlerInstantiator, this._locale, this._timeZone, base64, this._cacheProvider, this._nodeFactory, this._ctorDetector);
    }

    public BaseSettings with(CacheProvider cacheProvider) {
        if (cacheProvider == this._cacheProvider) {
            return this;
        }
        return new BaseSettings(this._annotationIntrospector, this._propertyNamingStrategy, this._enumNamingStrategy, this._accessorNaming, this._defaultTyper, this._typeValidator, this._dateFormat, this._handlerInstantiator, this._locale, this._timeZone, this._defaultBase64, cacheProvider, this._nodeFactory, this._ctorDetector);
    }

    public BaseSettings with(JsonNodeFactory nodeFactory) {
        if (nodeFactory == this._nodeFactory) {
            return this;
        }
        return new BaseSettings(this._annotationIntrospector, this._propertyNamingStrategy, this._enumNamingStrategy, this._accessorNaming, this._defaultTyper, this._typeValidator, this._dateFormat, this._handlerInstantiator, this._locale, this._timeZone, this._defaultBase64, this._cacheProvider, nodeFactory, this._ctorDetector);
    }

    public BaseSettings with(ConstructorDetector ctorDetector) {
        if (ctorDetector == this._ctorDetector) {
            return this;
        }
        return new BaseSettings(this._annotationIntrospector, this._propertyNamingStrategy, this._enumNamingStrategy, this._accessorNaming, this._defaultTyper, this._typeValidator, this._dateFormat, this._handlerInstantiator, this._locale, this._timeZone, this._defaultBase64, this._cacheProvider, this._nodeFactory, ctorDetector);
    }

    public AnnotationIntrospector getAnnotationIntrospector() {
        return this._annotationIntrospector;
    }

    public PropertyNamingStrategy getPropertyNamingStrategy() {
        return this._propertyNamingStrategy;
    }

    public EnumNamingStrategy getEnumNamingStrategy() {
        return this._enumNamingStrategy;
    }

    public AccessorNamingStrategy.Provider getAccessorNaming() {
        return this._accessorNaming;
    }

    public TypeResolverBuilder<?> getDefaultTyper() {
        return this._defaultTyper;
    }

    public PolymorphicTypeValidator getPolymorphicTypeValidator() {
        return this._typeValidator;
    }

    public DateFormat getDateFormat() {
        return this._dateFormat;
    }

    public HandlerInstantiator getHandlerInstantiator() {
        return this._handlerInstantiator;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public TimeZone getTimeZone() {
        TimeZone tz = this._timeZone;
        return tz == null ? DEFAULT_TIMEZONE : tz;
    }

    public boolean hasExplicitTimeZone() {
        return this._timeZone != null;
    }

    public Base64Variant getBase64Variant() {
        return this._defaultBase64;
    }

    public CacheProvider getCacheProvider() {
        return this._cacheProvider;
    }

    public JsonNodeFactory getNodeFactory() {
        return this._nodeFactory;
    }

    public ConstructorDetector getConstructorDetector() {
        return this._ctorDetector == null ? ConstructorDetector.DEFAULT : this._ctorDetector;
    }

    private DateFormat _force(DateFormat df, TimeZone tz) {
        if (df instanceof StdDateFormat) {
            StdDateFormat sdf = (StdDateFormat)df;
            return sdf.withTimeZone(tz);
        }
        df = (DateFormat)df.clone();
        df.setTimeZone(tz);
        return df;
    }
}

