/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind;

import java.io.Serializable;
import tools.jackson.core.FormatFeature;
import tools.jackson.core.StreamReadFeature;
import tools.jackson.databind.AbstractTypeResolver;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.cfg.BaseSettings;
import tools.jackson.databind.cfg.CoercionAction;
import tools.jackson.databind.cfg.CoercionConfigs;
import tools.jackson.databind.cfg.CoercionInputShape;
import tools.jackson.databind.cfg.ConfigOverrides;
import tools.jackson.databind.cfg.ContextAttributes;
import tools.jackson.databind.cfg.DatatypeFeatures;
import tools.jackson.databind.cfg.MapperBuilder;
import tools.jackson.databind.cfg.MapperConfigBase;
import tools.jackson.databind.deser.DeserializationProblemHandler;
import tools.jackson.databind.introspect.Annotated;
import tools.jackson.databind.introspect.ClassIntrospector;
import tools.jackson.databind.introspect.MixInHandler;
import tools.jackson.databind.jsontype.SubtypeResolver;
import tools.jackson.databind.type.LogicalType;
import tools.jackson.databind.type.TypeFactory;
import tools.jackson.databind.util.ArrayIterator;
import tools.jackson.databind.util.Converter;
import tools.jackson.databind.util.LinkedNode;
import tools.jackson.databind.util.RootNameLookup;

public final class DeserializationConfig
extends MapperConfigBase<DeserializationFeature, DeserializationConfig>
implements Serializable {
    private static final long serialVersionUID = 3L;
    protected final int _deserFeatures;
    protected final int _streamReadFeatures;
    protected final int _formatReadFeatures;
    protected final LinkedNode<DeserializationProblemHandler> _problemHandlers;
    protected final AbstractTypeResolver[] _abstractTypeResolvers;
    protected final CoercionConfigs _coercionConfigs;

    public DeserializationConfig(MapperBuilder<?, ?> b, long mapperFeatures, int deserFeatures, int streamReadFeatures, int formatReadFeatures, ConfigOverrides configOverrides, CoercionConfigs coercionConfigs, TypeFactory tf, ClassIntrospector classIntr, MixInHandler mixins, SubtypeResolver str, ContextAttributes defaultAttrs, RootNameLookup rootNames, AbstractTypeResolver[] atrs) {
        super(b, mapperFeatures, tf, classIntr, mixins, str, configOverrides, defaultAttrs, rootNames, b.defaultDeserializationView());
        this._deserFeatures = deserFeatures;
        this._streamReadFeatures = streamReadFeatures;
        this._formatReadFeatures = formatReadFeatures;
        this._problemHandlers = b.deserializationProblemHandlers();
        this._coercionConfigs = coercionConfigs;
        this._abstractTypeResolvers = atrs;
    }

    private DeserializationConfig(DeserializationConfig src, int deserFeatures, int streamReadFeatures, int formatReadFeatures) {
        super(src);
        this._deserFeatures = deserFeatures;
        this._streamReadFeatures = streamReadFeatures;
        this._formatReadFeatures = formatReadFeatures;
        this._coercionConfigs = src._coercionConfigs;
        this._problemHandlers = src._problemHandlers;
        this._abstractTypeResolvers = src._abstractTypeResolvers;
    }

    private DeserializationConfig(DeserializationConfig src, BaseSettings base) {
        super(src, base);
        this._deserFeatures = src._deserFeatures;
        this._streamReadFeatures = src._streamReadFeatures;
        this._formatReadFeatures = src._formatReadFeatures;
        this._coercionConfigs = src._coercionConfigs;
        this._problemHandlers = src._problemHandlers;
        this._abstractTypeResolvers = src._abstractTypeResolvers;
    }

    private DeserializationConfig(DeserializationConfig src, LinkedNode<DeserializationProblemHandler> problemHandlers, AbstractTypeResolver[] atr) {
        super(src);
        this._deserFeatures = src._deserFeatures;
        this._streamReadFeatures = src._streamReadFeatures;
        this._formatReadFeatures = src._formatReadFeatures;
        this._coercionConfigs = src._coercionConfigs;
        this._problemHandlers = problemHandlers;
        this._abstractTypeResolvers = atr;
    }

    private DeserializationConfig(DeserializationConfig src, PropertyName rootName) {
        super(src, rootName);
        this._deserFeatures = src._deserFeatures;
        this._problemHandlers = src._problemHandlers;
        this._streamReadFeatures = src._streamReadFeatures;
        this._coercionConfigs = src._coercionConfigs;
        this._formatReadFeatures = src._formatReadFeatures;
        this._abstractTypeResolvers = src._abstractTypeResolvers;
    }

    private DeserializationConfig(DeserializationConfig src, Class<?> view) {
        super(src, view);
        this._deserFeatures = src._deserFeatures;
        this._problemHandlers = src._problemHandlers;
        this._streamReadFeatures = src._streamReadFeatures;
        this._coercionConfigs = src._coercionConfigs;
        this._formatReadFeatures = src._formatReadFeatures;
        this._abstractTypeResolvers = src._abstractTypeResolvers;
    }

    protected DeserializationConfig(DeserializationConfig src, ContextAttributes attrs) {
        super(src, attrs);
        this._deserFeatures = src._deserFeatures;
        this._problemHandlers = src._problemHandlers;
        this._coercionConfigs = src._coercionConfigs;
        this._streamReadFeatures = src._streamReadFeatures;
        this._formatReadFeatures = src._formatReadFeatures;
        this._abstractTypeResolvers = src._abstractTypeResolvers;
    }

    protected DeserializationConfig(DeserializationConfig src, DatatypeFeatures dtFeatures) {
        super(src, dtFeatures);
        this._deserFeatures = src._deserFeatures;
        this._problemHandlers = src._problemHandlers;
        this._coercionConfigs = src._coercionConfigs;
        this._streamReadFeatures = src._streamReadFeatures;
        this._formatReadFeatures = src._formatReadFeatures;
        this._abstractTypeResolvers = src._abstractTypeResolvers;
    }

    protected BaseSettings getBaseSettings() {
        return this._base;
    }

    @Override
    protected final DeserializationConfig _withBase(BaseSettings newBase) {
        return this._base == newBase ? this : new DeserializationConfig(this, newBase);
    }

    @Override
    protected final DeserializationConfig _with(DatatypeFeatures dtFeatures) {
        return new DeserializationConfig(this, dtFeatures);
    }

    @Override
    public DeserializationConfig withRootName(PropertyName rootName) {
        if (rootName == null ? this._rootName == null : rootName.equals(this._rootName)) {
            return this;
        }
        return new DeserializationConfig(this, rootName);
    }

    @Override
    public DeserializationConfig withView(Class<?> view) {
        return this._view == view ? this : new DeserializationConfig(this, view);
    }

    @Override
    public DeserializationConfig with(ContextAttributes attrs) {
        return attrs == this._attributes ? this : new DeserializationConfig(this, attrs);
    }

    public DeserializationConfig with(DeserializationFeature feature) {
        int newDeserFeatures = this._deserFeatures | feature.getMask();
        return newDeserFeatures == this._deserFeatures ? this : new DeserializationConfig(this, newDeserFeatures, this._streamReadFeatures, this._formatReadFeatures);
    }

    public DeserializationConfig with(DeserializationFeature first, DeserializationFeature ... features) {
        int newDeserFeatures = this._deserFeatures | first.getMask();
        for (DeserializationFeature f : features) {
            newDeserFeatures |= f.getMask();
        }
        return newDeserFeatures == this._deserFeatures ? this : new DeserializationConfig(this, newDeserFeatures, this._streamReadFeatures, this._formatReadFeatures);
    }

    public DeserializationConfig withFeatures(DeserializationFeature ... features) {
        int newDeserFeatures = this._deserFeatures;
        for (DeserializationFeature f : features) {
            newDeserFeatures |= f.getMask();
        }
        return newDeserFeatures == this._deserFeatures ? this : new DeserializationConfig(this, newDeserFeatures, this._streamReadFeatures, this._formatReadFeatures);
    }

    public DeserializationConfig without(DeserializationFeature feature) {
        int newDeserFeatures = this._deserFeatures & ~feature.getMask();
        return newDeserFeatures == this._deserFeatures ? this : new DeserializationConfig(this, newDeserFeatures, this._streamReadFeatures, this._formatReadFeatures);
    }

    public DeserializationConfig without(DeserializationFeature first, DeserializationFeature ... features) {
        int newDeserFeatures = this._deserFeatures & ~first.getMask();
        for (DeserializationFeature f : features) {
            newDeserFeatures &= ~f.getMask();
        }
        return newDeserFeatures == this._deserFeatures ? this : new DeserializationConfig(this, newDeserFeatures, this._streamReadFeatures, this._formatReadFeatures);
    }

    public DeserializationConfig withoutFeatures(DeserializationFeature ... features) {
        int newDeserFeatures = this._deserFeatures;
        for (DeserializationFeature f : features) {
            newDeserFeatures &= ~f.getMask();
        }
        return newDeserFeatures == this._deserFeatures ? this : new DeserializationConfig(this, newDeserFeatures, this._streamReadFeatures, this._formatReadFeatures);
    }

    public DeserializationConfig with(StreamReadFeature feature) {
        int newSet = this._streamReadFeatures | feature.getMask();
        return this._streamReadFeatures == newSet ? this : new DeserializationConfig(this, this._deserFeatures, newSet, this._formatReadFeatures);
    }

    public DeserializationConfig withFeatures(StreamReadFeature ... features) {
        int newSet = this._streamReadFeatures;
        for (StreamReadFeature f : features) {
            newSet |= f.getMask();
        }
        return this._streamReadFeatures == newSet ? this : new DeserializationConfig(this, this._deserFeatures, newSet, this._formatReadFeatures);
    }

    public DeserializationConfig without(StreamReadFeature feature) {
        int newSet = this._streamReadFeatures & ~feature.getMask();
        return this._streamReadFeatures == newSet ? this : new DeserializationConfig(this, this._deserFeatures, newSet, this._formatReadFeatures);
    }

    public DeserializationConfig withoutFeatures(StreamReadFeature ... features) {
        int newSet = this._streamReadFeatures;
        for (StreamReadFeature f : features) {
            newSet &= ~f.getMask();
        }
        return this._streamReadFeatures == newSet ? this : new DeserializationConfig(this, this._deserFeatures, newSet, this._formatReadFeatures);
    }

    public DeserializationConfig with(FormatFeature feature) {
        int newSet = this._formatReadFeatures | feature.getMask();
        return this._formatReadFeatures == newSet ? this : new DeserializationConfig(this, this._deserFeatures, this._streamReadFeatures, newSet);
    }

    public DeserializationConfig withFeatures(FormatFeature ... features) {
        int newSet = this._formatReadFeatures;
        for (FormatFeature f : features) {
            newSet |= f.getMask();
        }
        return this._formatReadFeatures == newSet ? this : new DeserializationConfig(this, this._deserFeatures, this._streamReadFeatures, newSet);
    }

    public DeserializationConfig without(FormatFeature feature) {
        int newSet = this._formatReadFeatures & ~feature.getMask();
        return this._formatReadFeatures == newSet ? this : new DeserializationConfig(this, this._deserFeatures, this._streamReadFeatures, newSet);
    }

    public DeserializationConfig withoutFeatures(FormatFeature ... features) {
        int newSet = this._formatReadFeatures;
        for (FormatFeature f : features) {
            newSet &= ~f.getMask();
        }
        return this._formatReadFeatures == newSet ? this : new DeserializationConfig(this, this._deserFeatures, this._streamReadFeatures, newSet);
    }

    public DeserializationConfig withHandler(DeserializationProblemHandler h) {
        return LinkedNode.contains(this._problemHandlers, h) ? this : new DeserializationConfig(this, new LinkedNode<DeserializationProblemHandler>(h, this._problemHandlers), this._abstractTypeResolvers);
    }

    public DeserializationConfig withNoProblemHandlers() {
        return this._problemHandlers == null ? this : new DeserializationConfig(this, null, this._abstractTypeResolvers);
    }

    public int getStreamReadFeatures() {
        return this._streamReadFeatures;
    }

    public int getFormatReadFeatures() {
        return this._formatReadFeatures;
    }

    @Override
    public boolean useRootWrapping() {
        if (this._rootName != null) {
            return !this._rootName.isEmpty();
        }
        return this.isEnabled(DeserializationFeature.UNWRAP_ROOT_VALUE);
    }

    public final boolean isEnabled(DeserializationFeature f) {
        return (this._deserFeatures & f.getMask()) != 0;
    }

    public final boolean isEnabled(StreamReadFeature f) {
        return (this._streamReadFeatures & f.getMask()) != 0;
    }

    public final boolean hasFormatFeature(FormatFeature f) {
        return (this._formatReadFeatures & f.getMask()) != 0;
    }

    public final boolean hasDeserializationFeatures(int featureMask) {
        return (this._deserFeatures & featureMask) == featureMask;
    }

    public final boolean hasSomeOfFeatures(int featureMask) {
        return (this._deserFeatures & featureMask) != 0;
    }

    public final int getDeserializationFeatures() {
        return this._deserFeatures;
    }

    public final boolean requiresFullValue() {
        return DeserializationFeature.FAIL_ON_TRAILING_TOKENS.enabledIn(this._deserFeatures);
    }

    public boolean hasAbstractTypeResolvers() {
        return this._abstractTypeResolvers.length > 0;
    }

    public Iterable<AbstractTypeResolver> abstractTypeResolvers() {
        return new ArrayIterator<AbstractTypeResolver>(this._abstractTypeResolvers);
    }

    public JavaType mapAbstractType(JavaType type) {
        if (!this.hasAbstractTypeResolvers()) {
            return type;
        }
        JavaType next;
        while ((next = this._mapAbstractType2(type)) != null) {
            Class<?> nextCls;
            Class<?> prevCls = type.getRawClass();
            if (prevCls == (nextCls = next.getRawClass()) || !prevCls.isAssignableFrom(nextCls)) {
                throw new IllegalArgumentException("Invalid abstract type resolution from " + String.valueOf(type) + " to " + String.valueOf(next) + ": latter is not a subtype of former");
            }
            type = next;
        }
        return type;
    }

    private JavaType _mapAbstractType2(JavaType type) {
        Class<?> currClass = type.getRawClass();
        for (AbstractTypeResolver resolver : this.abstractTypeResolvers()) {
            JavaType concrete = resolver.findTypeMapping(this, type);
            if (concrete == null || concrete.hasRawClass(currClass)) continue;
            return concrete;
        }
        return null;
    }

    public LinkedNode<DeserializationProblemHandler> getProblemHandlers() {
        return this._problemHandlers;
    }

    public CoercionAction findCoercionAction(LogicalType targetType, Class<?> targetClass, CoercionInputShape inputShape) {
        return this._coercionConfigs.findCoercion(this, targetType, targetClass, inputShape);
    }

    public CoercionAction findCoercionFromBlankString(LogicalType targetType, Class<?> targetClass, CoercionAction actionIfBlankNotAllowed) {
        return this._coercionConfigs.findCoercionFromBlankString(this, targetType, targetClass, actionIfBlankNotAllowed);
    }

    public Converter<Object, Object> findDeserializationConverter(Annotated ann) {
        return this._createConverter(ann, this.getAnnotationIntrospector().findDeserializationConverter(this, ann));
    }
}

