/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ext.javatime.ser;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.cfg.DateTimeFeature;
import tools.jackson.databind.ext.javatime.ser.JSR310SerializerBase;
import tools.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import tools.jackson.databind.jsonFormatVisitors.JsonValueFormat;

abstract class JSR310FormattedSerializerBase<T>
extends JSR310SerializerBase<T> {
    protected final Boolean _useTimestamp;
    protected final Boolean _useNanoseconds;
    protected final DateTimeFormatter _formatter;
    protected final JsonFormat.Shape _shape;
    protected volatile transient JavaType _integerListType;

    protected JSR310FormattedSerializerBase(Class<T> supportedType) {
        this(supportedType, null);
    }

    protected JSR310FormattedSerializerBase(Class<T> supportedType, DateTimeFormatter formatter) {
        super(supportedType);
        this._useTimestamp = null;
        this._useNanoseconds = null;
        this._shape = null;
        this._formatter = formatter;
    }

    protected JSR310FormattedSerializerBase(JSR310FormattedSerializerBase<?> base, DateTimeFormatter dtf, Boolean useTimestamp, Boolean useNanoseconds, JsonFormat.Shape shape) {
        super(base.handledType());
        this._useTimestamp = useTimestamp;
        this._useNanoseconds = useNanoseconds;
        this._formatter = dtf;
        this._shape = shape;
    }

    protected abstract JSR310FormattedSerializerBase<?> withFormat(DateTimeFormatter var1, Boolean var2, JsonFormat.Shape var3);

    protected JSR310FormattedSerializerBase<?> withFeatures(Boolean writeZoneId, Boolean writeNanoseconds) {
        return this;
    }

    @Override
    public ValueSerializer<?> createContextual(SerializationContext ctxt, BeanProperty property) {
        JsonFormat.Value format = this.findFormatOverrides(ctxt, property, this.handledType());
        if (format != null) {
            Boolean useTimestamp = null;
            JsonFormat.Shape shape = format.getShape();
            useTimestamp = shape == JsonFormat.Shape.ARRAY || shape.isNumeric() ? Boolean.TRUE : (shape == JsonFormat.Shape.STRING ? Boolean.FALSE : null);
            DateTimeFormatter dtf = this._formatter;
            if (format.hasPattern()) {
                dtf = this._useDateTimeFormatter(ctxt, format);
            }
            JSR310FormattedSerializerBase<?> ser = this;
            if (shape != this._shape || useTimestamp != this._useTimestamp || dtf != this._formatter) {
                ser = ser.withFormat(dtf, useTimestamp, shape);
            }
            Boolean writeZoneId = format.getFeature(JsonFormat.Feature.WRITE_DATES_WITH_ZONE_ID);
            Boolean writeNanoseconds = format.getFeature(JsonFormat.Feature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS);
            if (writeZoneId != null || writeNanoseconds != null) {
                ser = ser.withFeatures(writeZoneId, writeNanoseconds);
            }
            return ser;
        }
        return this;
    }

    @Override
    @Deprecated
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
        if (this.useTimestamp(visitor.getContext())) {
            this._acceptTimestampVisitor(visitor, typeHint);
        } else {
            JsonStringFormatVisitor v2 = visitor.expectStringFormat(typeHint);
            if (v2 != null) {
                v2.format(JsonValueFormat.DATE_TIME);
            }
        }
    }

    protected void _acceptTimestampVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(this._integerListType(visitor.getContext()));
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }

    protected JavaType _integerListType(SerializationContext ctxt) {
        JavaType t = this._integerListType;
        if (t == null) {
            this._integerListType = t = ctxt.getTypeFactory().constructCollectionType(List.class, Integer.class);
        }
        return t;
    }

    protected DateTimeFeature getTimestampsFeature() {
        return DateTimeFeature.WRITE_DATES_AS_TIMESTAMPS;
    }

    protected boolean useTimestamp(SerializationContext ctxt) {
        if (this._useTimestamp != null) {
            return this._useTimestamp;
        }
        if (this._shape != null) {
            if (this._shape == JsonFormat.Shape.STRING) {
                return false;
            }
            if (this._shape == JsonFormat.Shape.NUMBER_INT) {
                return true;
            }
        }
        return this._formatter == null && this.useTimestampFromGlobalDefaults(ctxt);
    }

    protected boolean useTimestampFromGlobalDefaults(SerializationContext ctxt) {
        return ctxt != null && ctxt.isEnabled(this.getTimestampsFeature());
    }

    protected boolean _useTimestampExplicitOnly(SerializationContext ctxt) {
        if (this._useTimestamp != null) {
            return this._useTimestamp;
        }
        return false;
    }

    protected boolean useNanoseconds(SerializationContext ctxt) {
        if (this._useNanoseconds != null) {
            return this._useNanoseconds;
        }
        if (this._shape != null) {
            if (this._shape == JsonFormat.Shape.NUMBER_INT) {
                return false;
            }
            if (this._shape == JsonFormat.Shape.NUMBER_FLOAT) {
                return true;
            }
        }
        return ctxt != null && ctxt.isEnabled(DateTimeFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS);
    }

    protected DateTimeFormatter _useDateTimeFormatter(SerializationContext ctxt, JsonFormat.Value format) {
        String pattern = format.getPattern();
        Locale locale = format.hasLocale() ? format.getLocale() : ctxt.getLocale();
        DateTimeFormatter dtf = locale == null ? DateTimeFormatter.ofPattern(pattern) : DateTimeFormatter.ofPattern(pattern, locale);
        if (format.hasTimeZone()) {
            dtf = dtf.withZone(format.getTimeZone().toZoneId());
        }
        return dtf;
    }
}

