/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.jdk;

import java.util.HashMap;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonToken;
import tools.jackson.core.type.WritableTypeId;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.annotation.JacksonStdImpl;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.jdk.ByteArraySerializer;
import tools.jackson.databind.ser.std.ArraySerializerBase;
import tools.jackson.databind.ser.std.StdContainerSerializer;
import tools.jackson.databind.ser.std.StdSerializer;
import tools.jackson.databind.type.TypeFactory;

public class JDKArraySerializers {
    protected static final HashMap<String, ValueSerializer<?>> _arraySerializers = new HashMap();

    protected JDKArraySerializers() {
    }

    public static ValueSerializer<?> findStandardImpl(Class<?> cls) {
        return _arraySerializers.get(cls.getName());
    }

    static JavaType simpleElementType(Class<?> elemClass) {
        return TypeFactory.unsafeSimpleType(elemClass);
    }

    static {
        _arraySerializers.put(boolean[].class.getName(), new BooleanArraySerializer());
        _arraySerializers.put(byte[].class.getName(), new ByteArraySerializer());
        _arraySerializers.put(char[].class.getName(), new CharArraySerializer());
        _arraySerializers.put(short[].class.getName(), new ShortArraySerializer());
        _arraySerializers.put(int[].class.getName(), new IntArraySerializer());
        _arraySerializers.put(long[].class.getName(), new LongArraySerializer());
        _arraySerializers.put(float[].class.getName(), new FloatArraySerializer());
        _arraySerializers.put(double[].class.getName(), new DoubleArraySerializer());
    }

    @JacksonStdImpl
    public static class BooleanArraySerializer
    extends ArraySerializerBase<boolean[]> {
        private static final JavaType VALUE_TYPE = JDKArraySerializers.simpleElementType(Boolean.TYPE);

        public BooleanArraySerializer() {
            super(boolean[].class);
        }

        protected BooleanArraySerializer(BooleanArraySerializer src, BeanProperty prop, Boolean unwrapSingle) {
            super(src, prop, unwrapSingle);
        }

        @Override
        public ValueSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle) {
            return new BooleanArraySerializer(this, prop, unwrapSingle);
        }

        @Override
        public StdContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return this;
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public ValueSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializationContext prov, boolean[] value) {
            return value.length == 0;
        }

        @Override
        public boolean hasSingleElement(boolean[] value) {
            return value.length == 1;
        }

        @Override
        public final void serialize(boolean[] value, JsonGenerator g, SerializationContext provider) throws JacksonException {
            int len = value.length;
            if (len == 1 && this._shouldUnwrapSingle(provider)) {
                this.serializeContents(value, g, provider);
                return;
            }
            g.writeStartArray((Object)value, len);
            this.serializeContents(value, g, provider);
            g.writeEndArray();
        }

        @Override
        public void serializeContents(boolean[] value, JsonGenerator g, SerializationContext provider) throws JacksonException {
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                g.writeBoolean(value[i]);
            }
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
            this.visitArrayFormat(visitor, typeHint, JsonFormatTypes.BOOLEAN);
        }
    }

    @JacksonStdImpl
    public static class CharArraySerializer
    extends StdSerializer<char[]> {
        public CharArraySerializer() {
            super(char[].class);
        }

        @Override
        public boolean isEmpty(SerializationContext prov, char[] value) {
            return value.length == 0;
        }

        @Override
        public void serialize(char[] value, JsonGenerator g, SerializationContext provider) throws JacksonException {
            if (provider.isEnabled(SerializationFeature.WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS)) {
                g.writeStartArray((Object)value, value.length);
                this._writeArrayContents(g, value);
                g.writeEndArray();
            } else {
                g.writeString(value, 0, value.length);
            }
        }

        @Override
        public void serializeWithType(char[] value, JsonGenerator g, SerializationContext ctxt, TypeSerializer typeSer) throws JacksonException {
            WritableTypeId typeIdDef;
            boolean asArray = ctxt.isEnabled(SerializationFeature.WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS);
            if (asArray) {
                typeIdDef = typeSer.writeTypePrefix(g, ctxt, typeSer.typeId(value, JsonToken.START_ARRAY));
                this._writeArrayContents(g, value);
            } else {
                typeIdDef = typeSer.writeTypePrefix(g, ctxt, typeSer.typeId(value, JsonToken.VALUE_STRING));
                g.writeString(value, 0, value.length);
            }
            typeSer.writeTypeSuffix(g, ctxt, typeIdDef);
        }

        private final void _writeArrayContents(JsonGenerator g, char[] value) throws JacksonException {
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                g.writeString(value, i, 1);
            }
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
            this.visitArrayFormat(visitor, typeHint, JsonFormatTypes.STRING);
        }
    }

    @JacksonStdImpl
    public static class ShortArraySerializer
    extends TypedPrimitiveArraySerializer<short[]> {
        private static final JavaType VALUE_TYPE = JDKArraySerializers.simpleElementType(Short.TYPE);

        public ShortArraySerializer() {
            super(short[].class);
        }

        public ShortArraySerializer(ShortArraySerializer src, BeanProperty prop, Boolean unwrapSingle) {
            super(src, prop, unwrapSingle);
        }

        @Override
        public ValueSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle) {
            return new ShortArraySerializer(this, prop, unwrapSingle);
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public ValueSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializationContext prov, short[] value) {
            return value.length == 0;
        }

        @Override
        public boolean hasSingleElement(short[] value) {
            return value.length == 1;
        }

        @Override
        public final void serialize(short[] value, JsonGenerator g, SerializationContext provider) throws JacksonException {
            int len = value.length;
            if (len == 1 && this._shouldUnwrapSingle(provider)) {
                this.serializeContents(value, g, provider);
                return;
            }
            g.writeStartArray((Object)value, len);
            this.serializeContents(value, g, provider);
            g.writeEndArray();
        }

        @Override
        public void serializeContents(short[] value, JsonGenerator g, SerializationContext provider) throws JacksonException {
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                g.writeNumber((int)value[i]);
            }
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
            this.visitArrayFormat(visitor, typeHint, JsonFormatTypes.INTEGER);
        }
    }

    @JacksonStdImpl
    public static class IntArraySerializer
    extends ArraySerializerBase<int[]> {
        private static final JavaType VALUE_TYPE = JDKArraySerializers.simpleElementType(Integer.TYPE);

        public IntArraySerializer() {
            super(int[].class);
        }

        protected IntArraySerializer(IntArraySerializer src, BeanProperty prop, Boolean unwrapSingle) {
            super(src, prop, unwrapSingle);
        }

        @Override
        public ValueSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle) {
            return new IntArraySerializer(this, prop, unwrapSingle);
        }

        @Override
        public StdContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return this;
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public ValueSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializationContext prov, int[] value) {
            return value.length == 0;
        }

        @Override
        public boolean hasSingleElement(int[] value) {
            return value.length == 1;
        }

        @Override
        public final void serialize(int[] value, JsonGenerator g, SerializationContext provider) throws JacksonException {
            int len = value.length;
            if (len == 1 && this._shouldUnwrapSingle(provider)) {
                this.serializeContents(value, g, provider);
                return;
            }
            g.writeArray(value, 0, value.length);
        }

        @Override
        public void serializeContents(int[] value, JsonGenerator g, SerializationContext provider) throws JacksonException {
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                g.writeNumber(value[i]);
            }
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
            this.visitArrayFormat(visitor, typeHint, JsonFormatTypes.INTEGER);
        }
    }

    @JacksonStdImpl
    public static class LongArraySerializer
    extends TypedPrimitiveArraySerializer<long[]> {
        private static final JavaType VALUE_TYPE = JDKArraySerializers.simpleElementType(Long.TYPE);

        public LongArraySerializer() {
            super(long[].class);
        }

        public LongArraySerializer(LongArraySerializer src, BeanProperty prop, Boolean unwrapSingle) {
            super(src, prop, unwrapSingle);
        }

        @Override
        public ValueSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle) {
            return new LongArraySerializer(this, prop, unwrapSingle);
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public ValueSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializationContext prov, long[] value) {
            return value.length == 0;
        }

        @Override
        public boolean hasSingleElement(long[] value) {
            return value.length == 1;
        }

        @Override
        public final void serialize(long[] value, JsonGenerator g, SerializationContext provider) throws JacksonException {
            int len = value.length;
            if (len == 1 && this._shouldUnwrapSingle(provider)) {
                this.serializeContents(value, g, provider);
                return;
            }
            g.writeArray(value, 0, value.length);
        }

        @Override
        public void serializeContents(long[] value, JsonGenerator g, SerializationContext provider) throws JacksonException {
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                g.writeNumber(value[i]);
            }
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
            this.visitArrayFormat(visitor, typeHint, JsonFormatTypes.NUMBER);
        }
    }

    @JacksonStdImpl
    public static class FloatArraySerializer
    extends TypedPrimitiveArraySerializer<float[]> {
        private static final JavaType VALUE_TYPE = JDKArraySerializers.simpleElementType(Float.TYPE);

        public FloatArraySerializer() {
            super(float[].class);
        }

        public FloatArraySerializer(FloatArraySerializer src, BeanProperty prop, Boolean unwrapSingle) {
            super(src, prop, unwrapSingle);
        }

        @Override
        public ValueSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle) {
            return new FloatArraySerializer(this, prop, unwrapSingle);
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public ValueSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializationContext prov, float[] value) {
            return value.length == 0;
        }

        @Override
        public boolean hasSingleElement(float[] value) {
            return value.length == 1;
        }

        @Override
        public final void serialize(float[] value, JsonGenerator g, SerializationContext provider) throws JacksonException {
            int len = value.length;
            if (len == 1 && this._shouldUnwrapSingle(provider)) {
                this.serializeContents(value, g, provider);
                return;
            }
            g.writeStartArray((Object)value, len);
            this.serializeContents(value, g, provider);
            g.writeEndArray();
        }

        @Override
        public void serializeContents(float[] value, JsonGenerator g, SerializationContext provider) throws JacksonException {
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                g.writeNumber(value[i]);
            }
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
            this.visitArrayFormat(visitor, typeHint, JsonFormatTypes.NUMBER);
        }
    }

    @JacksonStdImpl
    public static class DoubleArraySerializer
    extends ArraySerializerBase<double[]> {
        private static final JavaType VALUE_TYPE = JDKArraySerializers.simpleElementType(Double.TYPE);

        public DoubleArraySerializer() {
            super(double[].class);
        }

        protected DoubleArraySerializer(DoubleArraySerializer src, BeanProperty prop, Boolean unwrapSingle) {
            super(src, prop, unwrapSingle);
        }

        @Override
        public ValueSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle) {
            return new DoubleArraySerializer(this, prop, unwrapSingle);
        }

        @Override
        public StdContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return this;
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public ValueSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializationContext prov, double[] value) {
            return value.length == 0;
        }

        @Override
        public boolean hasSingleElement(double[] value) {
            return value.length == 1;
        }

        @Override
        public final void serialize(double[] value, JsonGenerator g, SerializationContext provider) throws JacksonException {
            int len = value.length;
            if (len == 1 && this._shouldUnwrapSingle(provider)) {
                this.serializeContents(value, g, provider);
                return;
            }
            g.writeArray(value, 0, value.length);
        }

        @Override
        public void serializeContents(double[] value, JsonGenerator g, SerializationContext provider) throws JacksonException {
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                g.writeNumber(value[i]);
            }
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
            this.visitArrayFormat(visitor, typeHint, JsonFormatTypes.NUMBER);
        }
    }

    protected static abstract class TypedPrimitiveArraySerializer<T>
    extends ArraySerializerBase<T> {
        protected TypedPrimitiveArraySerializer(Class<T> cls) {
            super(cls);
        }

        protected TypedPrimitiveArraySerializer(TypedPrimitiveArraySerializer<T> src, BeanProperty prop, Boolean unwrapSingle) {
            super(src, prop, unwrapSingle);
        }

        @Override
        public final StdContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return this;
        }
    }
}

