/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.deser.jdk;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DatabindException;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.annotation.JacksonStdImpl;
import tools.jackson.databind.cfg.CoercionAction;
import tools.jackson.databind.cfg.CoercionInputShape;
import tools.jackson.databind.deser.NullValueProvider;
import tools.jackson.databind.deser.ValueInstantiator;
import tools.jackson.databind.deser.std.ContainerDeserializerBase;
import tools.jackson.databind.introspect.AnnotatedWithParams;
import tools.jackson.databind.jsontype.TypeDeserializer;
import tools.jackson.databind.type.LogicalType;

@JacksonStdImpl
public final class StringCollectionDeserializer
extends ContainerDeserializerBase<Collection<String>> {
    protected final ValueDeserializer<String> _valueDeserializer;
    protected final ValueInstantiator _valueInstantiator;
    protected final ValueDeserializer<Object> _delegateDeserializer;

    public StringCollectionDeserializer(JavaType collectionType, ValueDeserializer<?> valueDeser, ValueInstantiator valueInstantiator) {
        this(collectionType, valueInstantiator, null, valueDeser, valueDeser, null);
    }

    protected StringCollectionDeserializer(JavaType collectionType, ValueInstantiator valueInstantiator, ValueDeserializer<?> delegateDeser, ValueDeserializer<?> valueDeser, NullValueProvider nuller, Boolean unwrapSingle) {
        super(collectionType, nuller, unwrapSingle);
        this._valueDeserializer = valueDeser;
        this._valueInstantiator = valueInstantiator;
        this._delegateDeserializer = delegateDeser;
    }

    protected StringCollectionDeserializer withResolved(ValueDeserializer<?> delegateDeser, ValueDeserializer<?> valueDeser, NullValueProvider nuller, Boolean unwrapSingle) {
        if (Objects.equals(this._unwrapSingle, unwrapSingle) && this._nullProvider == nuller && this._valueDeserializer == valueDeser && this._delegateDeserializer == delegateDeser) {
            return this;
        }
        return new StringCollectionDeserializer(this._containerType, this._valueInstantiator, delegateDeser, valueDeser, nuller, unwrapSingle);
    }

    @Override
    public boolean isCachable() {
        return this._valueDeserializer == null && this._delegateDeserializer == null;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Collection;
    }

    @Override
    public ValueDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
        ValueDeserializer<Object> delegate = null;
        if (this._valueInstantiator != null) {
            AnnotatedWithParams delegateCreator = this._valueInstantiator.getArrayDelegateCreator();
            if (delegateCreator != null) {
                delegateType = this._valueInstantiator.getArrayDelegateType(ctxt.getConfig());
                delegate = this.findDeserializer(ctxt, delegateType, property);
            } else {
                delegateCreator = this._valueInstantiator.getDelegateCreator();
                if (delegateCreator != null) {
                    delegateType = this._valueInstantiator.getDelegateType(ctxt.getConfig());
                    delegate = this.findDeserializer(ctxt, delegateType, property);
                }
            }
        }
        ValueDeserializer<Object> valueDeser = this._valueDeserializer;
        JavaType valueType = this._containerType.getContentType();
        if (valueDeser == null) {
            if ((valueDeser = this.findConvertingContentDeserializer(ctxt, property, valueDeser)) == null) {
                valueDeser = ctxt.findContextualValueDeserializer(valueType, property);
            }
        } else {
            valueDeser = ctxt.handleSecondaryContextualization(valueDeser, property, valueType);
        }
        Boolean unwrapSingle = this.findFormatFeature(ctxt, property, Collection.class, JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        NullValueProvider nuller = this.findContentNullProvider(ctxt, property, valueDeser);
        if (this.isDefaultDeserializer(valueDeser)) {
            valueDeser = null;
        }
        return this.withResolved(delegate, valueDeser, nuller, unwrapSingle);
    }

    @Override
    public ValueDeserializer<Object> getContentDeserializer() {
        ValueDeserializer<Object> deser = this._valueDeserializer;
        return deser;
    }

    @Override
    public ValueInstantiator getValueInstantiator() {
        return this._valueInstantiator;
    }

    @Override
    public Collection<String> deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        if (this._delegateDeserializer != null) {
            return StringCollectionDeserializer.castToCollection(this._valueInstantiator.createUsingDelegate(ctxt, this._delegateDeserializer.deserialize(p, ctxt)));
        }
        Collection<String> result = StringCollectionDeserializer.castToCollection(this._valueInstantiator.createUsingDefault(ctxt));
        return this.deserialize(p, ctxt, result);
    }

    @Override
    public Collection<String> deserialize(JsonParser p, DeserializationContext ctxt, Collection<String> result) throws JacksonException {
        if (!p.isExpectedStartArrayToken()) {
            return this.handleNonArray(p, ctxt, result);
        }
        if (this._valueDeserializer != null) {
            return this.deserializeUsingCustom(p, ctxt, result, this._valueDeserializer);
        }
        try {
            while (true) {
                String value;
                if ((value = p.nextStringValue()) != null) {
                    result.add(value);
                    continue;
                }
                JsonToken t = p.currentToken();
                if (t != JsonToken.END_ARRAY) {
                    if (t == JsonToken.VALUE_NULL) {
                        if (this._skipNullValues) continue;
                        value = (String)this._nullProvider.getNullValue(ctxt);
                    } else {
                        value = this._parseString(p, ctxt, this._nullProvider);
                    }
                    result.add(value);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw DatabindException.wrapWithPath(ctxt, (Throwable)e, new JacksonException.Reference(result, result.size()));
        }
        return result;
    }

    private Collection<String> deserializeUsingCustom(JsonParser p, DeserializationContext ctxt, Collection<String> result, ValueDeserializer<String> deser) throws JacksonException {
        try {
            while (true) {
                String value;
                if (p.nextStringValue() == null) {
                    JsonToken t = p.currentToken();
                    if (t == JsonToken.END_ARRAY) break;
                    if (t == JsonToken.VALUE_NULL) {
                        if (this._skipNullValues) continue;
                        value = (String)this._nullProvider.getNullValue(ctxt);
                    } else {
                        value = deser.deserialize(p, ctxt);
                    }
                } else {
                    value = deser.deserialize(p, ctxt);
                }
                result.add(value);
            }
        }
        catch (Exception e) {
            throw DatabindException.wrapWithPath(ctxt, (Throwable)e, new JacksonException.Reference(result, result.size()));
        }
        return result;
    }

    @Override
    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws JacksonException {
        return typeDeserializer.deserializeTypedFromArray(p, ctxt);
    }

    private final Collection<String> handleNonArray(JsonParser p, DeserializationContext ctxt, Collection<String> result) throws JacksonException {
        String value;
        boolean canWrap;
        boolean bl = canWrap = this._unwrapSingle == Boolean.TRUE || this._unwrapSingle == null && ctxt.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        if (!canWrap) {
            if (p.hasToken(JsonToken.VALUE_STRING)) {
                return (Collection)this._deserializeFromString(p, ctxt);
            }
            return StringCollectionDeserializer.castToCollection(ctxt.handleUnexpectedToken(this._containerType, p));
        }
        ValueDeserializer<String> valueDes = this._valueDeserializer;
        JsonToken t = p.currentToken();
        if (t == JsonToken.VALUE_NULL) {
            if (this._skipNullValues) {
                return result;
            }
            value = (String)this._nullProvider.getNullValue(ctxt);
        } else {
            if (p.hasToken(JsonToken.VALUE_STRING)) {
                CoercionAction act;
                String textValue = p.getString();
                if (textValue.isEmpty()) {
                    CoercionAction act2 = ctxt.findCoercionAction(this.logicalType(), this.handledType(), CoercionInputShape.EmptyString);
                    if (act2 != CoercionAction.Fail) {
                        return StringCollectionDeserializer.castToCollection(this._deserializeFromEmptyString(p, ctxt, act2, this.handledType(), "empty String (\"\")"));
                    }
                } else if (StringCollectionDeserializer._isBlank(textValue) && (act = ctxt.findCoercionFromBlankString(this.logicalType(), this.handledType(), CoercionAction.Fail)) != CoercionAction.Fail) {
                    return StringCollectionDeserializer.castToCollection(this._deserializeFromEmptyString(p, ctxt, act, this.handledType(), "blank String (all whitespace)"));
                }
            }
            value = valueDes == null ? this._parseString(p, ctxt, this._nullProvider) : valueDes.deserialize(p, ctxt);
        }
        result.add(value);
        return result;
    }

    private static Collection<String> castToCollection(Object o) {
        if (o != null) {
            if (o.getClass() == ArrayList.class) {
                return (ArrayList)o;
            }
            if (o.getClass() == HashSet.class) {
                return (HashSet)o;
            }
        }
        return (Collection)o;
    }
}

