/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.node;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.node.NumericIntNode;

public class BigIntegerNode
extends NumericIntNode {
    private static final long serialVersionUID = 3L;
    protected final BigInteger _value;

    public BigIntegerNode(BigInteger v) {
        this._value = Objects.requireNonNull(v);
    }

    public static BigIntegerNode valueOf(BigInteger v) {
        return new BigIntegerNode(v);
    }

    @Override
    public JsonParser.NumberType numberType() {
        return JsonParser.NumberType.BIG_INTEGER;
    }

    @Override
    public boolean isBigInteger() {
        return true;
    }

    @Override
    protected Boolean _asBoolean() {
        return !BigInteger.ZERO.equals(this._value);
    }

    @Override
    public String _asString() {
        return this._value.toString();
    }

    @Override
    public Number numberValue() {
        return this._value;
    }

    @Override
    public short shortValue() {
        if (this._inShortRange()) {
            return (short)this._value.intValue();
        }
        return this._reportShortCoercionRangeFail("shortValue()");
    }

    @Override
    public short shortValue(short defaultValue) {
        return this._inShortRange() ? (short)this._value.intValue() : defaultValue;
    }

    @Override
    public short asShort() {
        if (this._inShortRange()) {
            return (short)this._value.intValue();
        }
        return this._reportShortCoercionRangeFail("asShort()");
    }

    @Override
    public short asShort(short defaultValue) {
        return this._inShortRange() ? (short)this._value.intValue() : defaultValue;
    }

    @Override
    public int intValue() {
        if (this._inIntRange()) {
            return this._value.intValue();
        }
        return this._reportIntCoercionRangeFail("intValue()");
    }

    @Override
    public int intValue(int defaultValue) {
        return this._inIntRange() ? this._value.intValue() : defaultValue;
    }

    @Override
    public OptionalInt intValueOpt() {
        return this._inIntRange() ? OptionalInt.of(this._value.intValue()) : OptionalInt.empty();
    }

    @Override
    public int asInt() {
        if (this._inIntRange()) {
            return this._value.intValue();
        }
        return this._reportIntCoercionRangeFail("asInt()");
    }

    @Override
    public int asInt(int defaultValue) {
        return this._inIntRange() ? this._value.intValue() : defaultValue;
    }

    @Override
    public OptionalInt asIntOpt() {
        return this._inIntRange() ? OptionalInt.of(this._value.intValue()) : OptionalInt.empty();
    }

    @Override
    public long longValue() {
        if (this.canConvertToLong()) {
            return this._value.longValue();
        }
        return this._reportLongCoercionRangeFail("longValue()");
    }

    @Override
    public long longValue(long defaultValue) {
        return this.canConvertToLong() ? this._value.longValue() : defaultValue;
    }

    @Override
    public OptionalLong longValueOpt() {
        return this.canConvertToLong() ? OptionalLong.of(this._value.longValue()) : OptionalLong.empty();
    }

    @Override
    public long asLong() {
        if (this.canConvertToLong()) {
            return this._value.longValue();
        }
        return this._reportLongCoercionRangeFail("asLong()");
    }

    @Override
    public long asLong(long defaultValue) {
        return this.canConvertToLong() ? this._value.longValue() : defaultValue;
    }

    @Override
    public OptionalLong asLongOpt() {
        return this.canConvertToLong() ? OptionalLong.of(this._value.longValue()) : OptionalLong.empty();
    }

    @Override
    public BigInteger bigIntegerValue() {
        return this._value;
    }

    @Override
    public BigInteger bigIntegerValue(BigInteger defaultValue) {
        return this._value;
    }

    @Override
    public Optional<BigInteger> bigIntegerValueOpt() {
        return Optional.of(this._value);
    }

    @Override
    public float floatValue() {
        float f = this._asFloatValueUnchecked();
        if (Float.isFinite(f)) {
            return f;
        }
        return this._reportFloatCoercionRangeFail("floatValue()");
    }

    @Override
    public float floatValue(float defaultValue) {
        float f = this._asFloatValueUnchecked();
        return Float.isFinite(f) ? f : defaultValue;
    }

    @Override
    public float asFloat() {
        float f = this._asFloatValueUnchecked();
        if (Float.isFinite(f)) {
            return f;
        }
        return this._reportFloatCoercionRangeFail("asFloat()");
    }

    @Override
    public float asFloat(float defaultValue) {
        float f = this._asFloatValueUnchecked();
        return Float.isFinite(f) ? f : defaultValue;
    }

    @Override
    public double doubleValue() {
        double d = this._asDoubleValueUnchecked();
        if (Double.isFinite(d)) {
            return d;
        }
        return this._reportDoubleCoercionRangeFail("doubleValue()");
    }

    @Override
    public double doubleValue(double defaultValue) {
        double d = this._asDoubleValueUnchecked();
        return Double.isFinite(d) ? d : defaultValue;
    }

    @Override
    public OptionalDouble doubleValueOpt() {
        double d = this._asDoubleValueUnchecked();
        if (Double.isFinite(d)) {
            return OptionalDouble.of(this._value.doubleValue());
        }
        return OptionalDouble.empty();
    }

    @Override
    public double asDouble() {
        double d = this._asDoubleValueUnchecked();
        if (Double.isFinite(d)) {
            return d;
        }
        return this._reportDoubleCoercionRangeFail("asDouble()");
    }

    @Override
    public double asDouble(double defaultValue) {
        double d = this._asDoubleValueUnchecked();
        return Double.isFinite(d) ? d : defaultValue;
    }

    @Override
    public OptionalDouble asDoubleOpt() {
        double d = this._asDoubleValueUnchecked();
        if (Double.isFinite(d)) {
            return OptionalDouble.of(this._value.doubleValue());
        }
        return OptionalDouble.empty();
    }

    @Override
    public BigDecimal decimalValue() {
        return new BigDecimal(this._value);
    }

    @Override
    public BigDecimal decimalValue(BigDecimal defaultValue) {
        return new BigDecimal(this._value);
    }

    @Override
    public Optional<BigDecimal> decimalValueOpt() {
        return Optional.of(new BigDecimal(this._value));
    }

    @Override
    protected int _asIntValueUnchecked() {
        return this._value.intValue();
    }

    @Override
    protected float _asFloatValueUnchecked() {
        return this._value.floatValue();
    }

    @Override
    protected double _asDoubleValueUnchecked() {
        return this._value.doubleValue();
    }

    @Override
    protected boolean _inShortRange() {
        return this._value.compareTo(BI_MIN_SHORT) >= 0 && this._value.compareTo(BI_MAX_SHORT) <= 0;
    }

    @Override
    public boolean _inIntRange() {
        return this._value.compareTo(BI_MIN_INTEGER) >= 0 && this._value.compareTo(BI_MAX_INTEGER) <= 0;
    }

    @Override
    protected boolean _inLongRange() {
        return this._value.compareTo(BI_MIN_LONG) >= 0 && this._value.compareTo(BI_MAX_LONG) <= 0;
    }

    @Override
    public final void serialize(JsonGenerator g, SerializationContext provider) throws JacksonException {
        g.writeNumber(this._value);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof BigIntegerNode) {
            BigIntegerNode otherNode = (BigIntegerNode)o;
            return Objects.equals(otherNode._value, this._value);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this._value);
    }
}

