/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.deser;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.annotation.ObjectIdResolver;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tools.jackson.databind.AbstractTypeResolver;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.KeyDeserializer;
import tools.jackson.databind.MapperFeature;
import tools.jackson.databind.PropertyMetadata;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.PropertyNamingStrategy;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.annotation.JsonPOJOBuilder;
import tools.jackson.databind.cfg.DeserializerFactoryConfig;
import tools.jackson.databind.deser.BasicDeserializerFactory;
import tools.jackson.databind.deser.BeanDeserializerBuilder;
import tools.jackson.databind.deser.ContextualKeyDeserializer;
import tools.jackson.databind.deser.CreatorProperty;
import tools.jackson.databind.deser.DeserializerFactory;
import tools.jackson.databind.deser.SettableAnyProperty;
import tools.jackson.databind.deser.SettableBeanProperty;
import tools.jackson.databind.deser.ValueDeserializerModifier;
import tools.jackson.databind.deser.ValueInstantiator;
import tools.jackson.databind.deser.bean.BeanDeserializer;
import tools.jackson.databind.deser.impl.ErrorThrowingDeserializer;
import tools.jackson.databind.deser.impl.MethodProperty;
import tools.jackson.databind.deser.impl.ObjectIdReader;
import tools.jackson.databind.deser.impl.SetterlessProperty;
import tools.jackson.databind.deser.impl.UnsupportedTypeDeserializer;
import tools.jackson.databind.deser.jdk.ThrowableDeserializer;
import tools.jackson.databind.exc.InvalidDefinitionException;
import tools.jackson.databind.introspect.AnnotatedClass;
import tools.jackson.databind.introspect.AnnotatedField;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.introspect.AnnotatedMethod;
import tools.jackson.databind.introspect.AnnotatedParameter;
import tools.jackson.databind.introspect.BeanPropertyDefinition;
import tools.jackson.databind.introspect.ObjectIdInfo;
import tools.jackson.databind.jsontype.TypeDeserializer;
import tools.jackson.databind.jsontype.impl.SubTypeValidator;
import tools.jackson.databind.node.ObjectNode;
import tools.jackson.databind.util.BeanUtil;
import tools.jackson.databind.util.ClassUtil;
import tools.jackson.databind.util.IgnorePropertiesUtil;
import tools.jackson.databind.util.SimpleBeanPropertyDefinition;

public class BeanDeserializerFactory
extends BasicDeserializerFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Class<?>[] INIT_CAUSE_PARAMS = new Class[]{Throwable.class};
    public static final BeanDeserializerFactory instance = new BeanDeserializerFactory(new DeserializerFactoryConfig());

    public BeanDeserializerFactory(DeserializerFactoryConfig config) {
        super(config);
    }

    @Override
    public DeserializerFactory withConfig(DeserializerFactoryConfig config) {
        if (this._factoryConfig == config) {
            return this;
        }
        ClassUtil.verifyMustOverride(BeanDeserializerFactory.class, this, "withConfig");
        return new BeanDeserializerFactory(config);
    }

    @Override
    public ValueDeserializer<Object> createBeanDeserializer(DeserializationContext ctxt, JavaType type, BeanDescription.Supplier beanDescRef) {
        JavaType concreteType;
        DeserializationConfig config = ctxt.getConfig();
        ValueDeserializer<Object> deser = this._findCustomBeanDeserializer(type, config, beanDescRef);
        if (deser != null) {
            if (this._factoryConfig.hasDeserializerModifiers()) {
                for (ValueDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                    deser = mod.modifyDeserializer(ctxt.getConfig(), beanDescRef, deser);
                }
            }
            return deser;
        }
        if (type.isThrowable()) {
            return this.buildThrowableDeserializer(ctxt, type, beanDescRef);
        }
        if (type.isAbstract() && !type.isPrimitive() && !type.isEnumType() && (concreteType = this.materializeAbstractType(ctxt, type, beanDescRef)) != null) {
            beanDescRef = ctxt.lazyIntrospectBeanDescription(concreteType);
            return this.buildBeanDeserializer(ctxt, concreteType, beanDescRef);
        }
        deser = this.findStdDeserializer(ctxt, type, beanDescRef);
        if (deser != null) {
            return deser;
        }
        if (!this.isPotentialBeanType(type.getRawClass())) {
            return null;
        }
        this._validateSubType(ctxt, type, beanDescRef);
        deser = this._findUnsupportedTypeDeserializer(ctxt, type, beanDescRef);
        if (deser != null) {
            return deser;
        }
        return this.buildBeanDeserializer(ctxt, type, beanDescRef);
    }

    @Override
    public ValueDeserializer<Object> createBuilderBasedDeserializer(DeserializationContext ctxt, JavaType valueType, BeanDescription.Supplier valueBeanDescRef, Class<?> builderClass) {
        JavaType builderType = ctxt.isEnabled(MapperFeature.INFER_BUILDER_TYPE_BINDINGS) ? ctxt.getTypeFactory().constructParametricType(builderClass, valueType.getBindings()) : ctxt.constructType(builderClass);
        BeanDescription.Supplier builderDescRef = ctxt.lazyIntrospectBeanDescriptionForBuilder(builderType, valueBeanDescRef.get());
        return this.buildBuilderBasedDeserializer(ctxt, valueType, builderDescRef);
    }

    protected ValueDeserializer<?> findStdDeserializer(DeserializationContext ctxt, JavaType type, BeanDescription.Supplier beanDescRef) {
        ValueDeserializer<?> deser = this.findDefaultDeserializer(ctxt, type, beanDescRef);
        if (deser != null && this._factoryConfig.hasDeserializerModifiers()) {
            for (ValueDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                deser = mod.modifyDeserializer(ctxt.getConfig(), beanDescRef, deser);
            }
        }
        return deser;
    }

    protected ValueDeserializer<Object> _findUnsupportedTypeDeserializer(DeserializationContext ctxt, JavaType type, BeanDescription.Supplier beanDescRef) {
        String errorMsg = BeanUtil.checkUnsupportedType(ctxt.getConfig(), type);
        if (errorMsg != null && ctxt.getConfig().findMixInClassFor(type.getRawClass()) == null) {
            return new UnsupportedTypeDeserializer(type, errorMsg);
        }
        return null;
    }

    protected JavaType materializeAbstractType(DeserializationContext ctxt, JavaType type, BeanDescription.Supplier beanDescRef) {
        DeserializationConfig config = ctxt.getConfig();
        for (AbstractTypeResolver r : config.abstractTypeResolvers()) {
            JavaType concrete = r.resolveAbstractType(config, beanDescRef);
            if (concrete == null) continue;
            return concrete;
        }
        return null;
    }

    public ValueDeserializer<Object> buildBeanDeserializer(DeserializationContext ctxt, JavaType type, BeanDescription.Supplier beanDescRef) {
        ValueInstantiator valueInstantiator;
        try {
            valueInstantiator = this.findValueInstantiator(ctxt, beanDescRef);
        }
        catch (NoClassDefFoundError error) {
            return new ErrorThrowingDeserializer(error);
        }
        catch (IllegalArgumentException e0) {
            throw InvalidDefinitionException.from(ctxt.getParser(), ClassUtil.exceptionMessage(e0), beanDescRef, null).withCause(e0);
        }
        BeanDeserializerBuilder builder = this.constructBeanDeserializerBuilder(ctxt, beanDescRef);
        builder.setValueInstantiator(valueInstantiator);
        this.addBeanProps(ctxt, beanDescRef, builder);
        this.addObjectIdReader(ctxt, beanDescRef, builder);
        this.addBackReferenceProperties(ctxt, beanDescRef, builder);
        this.addInjectables(ctxt, beanDescRef, builder);
        DeserializationConfig config = ctxt.getConfig();
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (ValueDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                builder = mod.updateBuilder(config, beanDescRef, builder);
            }
        }
        ValueDeserializer deserializer = type.isAbstract() && !valueInstantiator.canInstantiate() ? builder.buildAbstract() : builder.build();
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (ValueDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                deserializer = mod.modifyDeserializer(config, beanDescRef, deserializer);
            }
        }
        return deserializer;
    }

    protected ValueDeserializer<Object> buildBuilderBasedDeserializer(DeserializationContext ctxt, JavaType valueType, BeanDescription.Supplier builderDescRef) {
        ValueInstantiator valueInstantiator;
        try {
            valueInstantiator = this.findValueInstantiator(ctxt, builderDescRef);
        }
        catch (NoClassDefFoundError error) {
            return new ErrorThrowingDeserializer(error);
        }
        catch (IllegalArgumentException e) {
            throw InvalidDefinitionException.from(ctxt.getParser(), ClassUtil.exceptionMessage(e), builderDescRef, null);
        }
        DeserializationConfig config = ctxt.getConfig();
        BeanDeserializerBuilder builder = this.constructBeanDeserializerBuilder(ctxt, builderDescRef);
        builder.setValueInstantiator(valueInstantiator);
        this.addBeanProps(ctxt, builderDescRef, builder);
        this.addObjectIdReader(ctxt, builderDescRef, builder);
        this.addBackReferenceProperties(ctxt, builderDescRef, builder);
        this.addInjectables(ctxt, builderDescRef, builder);
        JsonPOJOBuilder.Value builderConfig = builderDescRef.get().findPOJOBuilderConfig();
        String buildMethodName = builderConfig == null ? "build" : builderConfig.buildMethodName;
        AnnotatedMethod buildMethod = builderDescRef.get().findMethod(buildMethodName, null);
        if (buildMethod != null && config.canOverrideAccessModifiers()) {
            ClassUtil.checkAndFixAccess(buildMethod.getMember(), config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
        }
        builder.setPOJOBuilder(buildMethod, builderConfig);
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (ValueDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                builder = mod.updateBuilder(config, builderDescRef, builder);
            }
        }
        ValueDeserializer<Object> deserializer = builder.buildBuilderBased(valueType, buildMethodName);
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (ValueDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                deserializer = mod.modifyDeserializer(config, builderDescRef, deserializer);
            }
        }
        return deserializer;
    }

    protected void addObjectIdReader(DeserializationContext ctxt, BeanDescription.Supplier beanDescRef, BeanDeserializerBuilder builder) {
        ObjectIdGenerator gen;
        JavaType idType;
        SettableBeanProperty idProp;
        ObjectIdInfo objectIdInfo = beanDescRef.get().getObjectIdInfo();
        if (objectIdInfo == null) {
            return;
        }
        Class<? extends ObjectIdGenerator<?>> implClass = objectIdInfo.getGeneratorType();
        ObjectIdResolver resolver = ctxt.objectIdResolverInstance(beanDescRef.getClassInfo(), objectIdInfo);
        if (implClass == ObjectIdGenerators.PropertyGenerator.class) {
            PropertyName propName = objectIdInfo.getPropertyName();
            idProp = builder.findProperty(propName);
            if (idProp == null) {
                throw new IllegalArgumentException(String.format("Invalid Object Id definition for %s: cannot find property with name %s", ClassUtil.getTypeDescription(beanDescRef.getType()), ClassUtil.name(propName)));
            }
            idType = idProp.getType();
            gen = new ObjectIdGenerator(objectIdInfo.getScope());
        } else {
            JavaType type = ctxt.constructType(implClass);
            idType = ctxt.getTypeFactory().findTypeParameters(type, ObjectIdGenerator.class)[0];
            idProp = null;
            gen = ctxt.objectIdGeneratorInstance(beanDescRef.getClassInfo(), objectIdInfo);
        }
        ValueDeserializer<Object> deser = ctxt.findRootValueDeserializer(idType);
        builder.setObjectIdReader(ObjectIdReader.construct(idType, objectIdInfo.getPropertyName(), gen, deser, idProp, resolver));
    }

    public ValueDeserializer<Object> buildThrowableDeserializer(DeserializationContext ctxt, JavaType type, BeanDescription.Supplier beanDescRef) {
        ValueDeserializer deserializer;
        AnnotatedMethod am;
        DeserializationConfig config = ctxt.getConfig();
        BeanDeserializerBuilder builder = this.constructBeanDeserializerBuilder(ctxt, beanDescRef);
        builder.setValueInstantiator(this.findValueInstantiator(ctxt, beanDescRef));
        this.addBeanProps(ctxt, beanDescRef, builder);
        Iterator<SettableBeanProperty> it = builder.getProperties();
        while (it.hasNext()) {
            SettableBeanProperty prop = it.next();
            if (!"setCause".equals(prop.getMember().getName())) continue;
            it.remove();
            break;
        }
        if ((am = beanDescRef.get().findMethod("initCause", INIT_CAUSE_PARAMS)) != null) {
            SettableBeanProperty causeCreatorProp = builder.findProperty(PropertyName.construct("cause"));
            if (causeCreatorProp instanceof CreatorProperty) {
                ((CreatorProperty)causeCreatorProp).setFallbackSetter(null);
            } else {
                SimpleBeanPropertyDefinition propDef;
                SettableBeanProperty prop;
                String name = "cause";
                PropertyNamingStrategy pts = config.getPropertyNamingStrategy();
                if (pts != null) {
                    name = pts.nameForSetterMethod(config, am, "cause");
                }
                if ((prop = this.constructSettableProperty(ctxt, beanDescRef, propDef = SimpleBeanPropertyDefinition.construct(ctxt.getConfig(), am, new PropertyName(name)), am.getParameterType(0))) != null) {
                    builder.addOrReplaceProperty(prop, true);
                }
            }
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (ValueDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                builder = mod.updateBuilder(config, beanDescRef, builder);
            }
        }
        if ((deserializer = builder.build()) instanceof BeanDeserializer) {
            deserializer = ThrowableDeserializer.construct(ctxt, deserializer);
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (ValueDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                deserializer = mod.modifyDeserializer(config, beanDescRef, deserializer);
            }
        }
        return deserializer;
    }

    protected BeanDeserializerBuilder constructBeanDeserializerBuilder(DeserializationContext ctxt, BeanDescription.Supplier beanDescRef) {
        return new BeanDeserializerBuilder(beanDescRef, ctxt);
    }

    protected void addBeanProps(DeserializationContext ctxt, BeanDescription.Supplier beanDescRef, BeanDeserializerBuilder builder) {
        SettableAnyProperty anySetter;
        Set ignored;
        BeanDescription beanDesc = beanDescRef.get();
        ValueInstantiator valueInstantiator = builder.getValueInstantiator();
        SettableBeanProperty[] creatorProps = valueInstantiator != null ? valueInstantiator.getFromObjectArguments(ctxt.getConfig()) : null;
        boolean hasCreatorProps = creatorProps != null;
        JsonIgnoreProperties.Value ignorals = ctxt.getConfig().getDefaultPropertyIgnorals(beanDesc.getBeanClass(), beanDesc.getClassInfo());
        if (ignorals != null) {
            boolean ignoreAny = ignorals.getIgnoreUnknown();
            builder.setIgnoreUnknownProperties(ignoreAny);
            ignored = ignorals.findIgnoredForDeserialization();
            for (Object propName : ignored) {
                builder.addIgnorable((String)propName);
            }
        } else {
            ignored = Collections.emptySet();
        }
        JsonIncludeProperties.Value inclusions = ctxt.getConfig().getDefaultPropertyInclusions(beanDesc.getBeanClass(), beanDesc.getClassInfo());
        Set included = null;
        if (inclusions != null && (included = inclusions.getIncluded()) != null) {
            for (String propName : included) {
                builder.addIncludable(propName);
            }
        }
        if ((anySetter = this._resolveAnySetter(ctxt, beanDescRef, creatorProps)) != null) {
            builder.setAnySetter(anySetter);
        } else {
            Set<String> ignored2 = beanDesc.getIgnoredPropertyNames();
            if (ignored2 != null) {
                for (String propName : ignored2) {
                    builder.addIgnorable(propName);
                }
            }
        }
        boolean useGettersAsSetters = ctxt.isEnabled(MapperFeature.USE_GETTERS_AS_SETTERS);
        List<BeanPropertyDefinition> propDefs = this.filterBeanProps(ctxt, beanDescRef, builder, beanDesc.findProperties(), ignored, included);
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (ValueDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                propDefs = mod.updateProperties(ctxt.getConfig(), beanDescRef, propDefs);
            }
        }
        for (BeanPropertyDefinition propDef : propDefs) {
            SettableBeanProperty prop = null;
            if (propDef.hasSetter()) {
                AnnotatedMethod setter = propDef.getSetter();
                propertyType = setter.getParameterType(0);
                prop = this.constructSettableProperty(ctxt, beanDescRef, propDef, propertyType);
            } else if (propDef.hasField()) {
                AnnotatedField field = propDef.getField();
                propertyType = field.getType();
                prop = this.constructSettableProperty(ctxt, beanDescRef, propDef, propertyType);
            } else {
                AnnotatedMethod getter = propDef.getGetter();
                if (getter != null) {
                    PropertyMetadata md;
                    if (useGettersAsSetters && this._isSetterlessType(getter.getRawType())) {
                        if (!builder.hasIgnorable(propDef.getName())) {
                            prop = this.constructSetterlessProperty(ctxt, beanDesc, propDef);
                        }
                    } else if (!propDef.hasConstructorParameter() && (md = propDef.getMetadata()).getMergeInfo() != null) {
                        prop = this.constructSetterlessProperty(ctxt, beanDesc, propDef);
                    }
                }
            }
            if (hasCreatorProps && propDef.hasConstructorParameter()) {
                Class<?>[] views;
                String name = propDef.getName();
                CreatorProperty cprop = null;
                for (SettableBeanProperty cp : creatorProps) {
                    if (!name.equals(cp.getName()) || !(cp instanceof CreatorProperty)) continue;
                    cprop = (CreatorProperty)cp;
                    break;
                }
                if (cprop == null) {
                    ArrayList<String> n = new ArrayList<String>();
                    for (SettableBeanProperty cp : creatorProps) {
                        n.add(cp.getName());
                    }
                    ctxt.reportBadPropertyDefinition(beanDesc, propDef, "Could not find creator property with name %s (known Creator properties: %s)", ClassUtil.name(name), n);
                    continue;
                }
                if (prop != null) {
                    cprop.setFallbackSetter(prop);
                }
                if ((views = propDef.findViews()) == null) {
                    views = beanDesc.findDefaultViews();
                }
                cprop.setViews(views);
                builder.addCreatorProperty(cprop);
                continue;
            }
            if (prop == null) continue;
            Class<?>[] views = propDef.findViews();
            if (views == null) {
                views = beanDesc.findDefaultViews();
            }
            prop.setViews(views);
            builder.addProperty(prop);
        }
    }

    private SettableAnyProperty _resolveAnySetter(DeserializationContext ctxt, BeanDescription.Supplier beanDescRef, SettableBeanProperty[] creatorProps) {
        AnnotatedMember anySetter;
        if (creatorProps != null) {
            for (SettableBeanProperty prop : creatorProps) {
                AnnotatedMember member = prop.getMember();
                if (member == null || !Boolean.TRUE.equals(ctxt.getAnnotationIntrospector().hasAnySetter(ctxt.getConfig(), member))) continue;
                return this.constructAnySetter(ctxt, beanDescRef, member);
            }
        }
        if ((anySetter = beanDescRef.get().findAnySetterAccessor()) != null) {
            return this.constructAnySetter(ctxt, beanDescRef, anySetter);
        }
        return null;
    }

    private boolean _isSetterlessType(Class<?> rawType) {
        return Collection.class.isAssignableFrom(rawType) || Map.class.isAssignableFrom(rawType);
    }

    protected List<BeanPropertyDefinition> filterBeanProps(DeserializationContext ctxt, BeanDescription.Supplier beanDescRef, BeanDeserializerBuilder builder, List<BeanPropertyDefinition> propDefsIn, Set<String> ignored, Set<String> included) {
        ArrayList<BeanPropertyDefinition> result = new ArrayList<BeanPropertyDefinition>(Math.max(4, propDefsIn.size()));
        HashMap ignoredTypes = new HashMap();
        for (BeanPropertyDefinition property : propDefsIn) {
            Class<?> rawPropertyType;
            String name = property.getName();
            if (IgnorePropertiesUtil.shouldIgnore(name, ignored, included)) continue;
            if (!property.hasConstructorParameter() && (rawPropertyType = property.getRawPrimaryType()) != null && this.isIgnorableType(ctxt, property, rawPropertyType, ignoredTypes)) {
                builder.addIgnorable(name);
                continue;
            }
            result.add(property);
        }
        return result;
    }

    protected void addBackReferenceProperties(DeserializationContext ctxt, BeanDescription.Supplier beanDescRef, BeanDeserializerBuilder builder) {
        List<BeanPropertyDefinition> refProps = beanDescRef.get().findBackReferences();
        if (refProps != null) {
            for (BeanPropertyDefinition refProp : refProps) {
                String refName = refProp.findReferenceName();
                builder.addBackReferenceProperty(refName, this.constructSettableProperty(ctxt, beanDescRef, refProp, refProp.getPrimaryType()));
            }
        }
    }

    protected void addInjectables(DeserializationContext ctxt, BeanDescription.Supplier beanDescRef, BeanDeserializerBuilder builder) {
        Map<Object, AnnotatedMember> raw = beanDescRef.get().findInjectables();
        if (raw != null) {
            AnnotationIntrospector introspector = ctxt.getAnnotationIntrospector();
            for (Map.Entry<Object, AnnotatedMember> entry : raw.entrySet()) {
                AnnotatedMember m = entry.getValue();
                JacksonInject.Value injectableValue = introspector.findInjectableValue(ctxt.getConfig(), m);
                Boolean optional = injectableValue == null ? null : injectableValue.getOptional();
                builder.addInjectable(PropertyName.construct(m.getName()), m.getType(), beanDescRef.getClassAnnotations(), m, entry.getKey(), optional);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected SettableAnyProperty constructAnySetter(DeserializationContext ctxt, BeanDescription.Supplier beanDescRef, AnnotatedMember mutator) {
        BeanProperty.Std prop;
        JavaType valueType;
        JavaType keyType;
        int parameterIndex;
        boolean isParameter;
        boolean isField;
        block18: {
            isField = mutator instanceof AnnotatedField;
            isParameter = mutator instanceof AnnotatedParameter;
            parameterIndex = -1;
            if (mutator instanceof AnnotatedMethod) {
                AnnotatedMethod am = (AnnotatedMethod)mutator;
                keyType = am.getParameterType(0);
                valueType = am.getParameterType(1);
                valueType = this.resolveMemberAndTypeAnnotations(ctxt, mutator, valueType);
                prop = new BeanProperty.Std(PropertyName.construct(mutator.getName()), valueType, null, mutator, PropertyMetadata.STD_OPTIONAL);
            } else {
                AnnotatedMember af;
                if (isField) {
                    af = (AnnotatedField)mutator;
                    JavaType fieldType = ((AnnotatedField)af).getType();
                    if (fieldType.isMapLikeType()) {
                        fieldType = this.resolveMemberAndTypeAnnotations(ctxt, mutator, fieldType);
                        keyType = fieldType.getKeyType();
                        valueType = fieldType.getContentType();
                        prop = new BeanProperty.Std(PropertyName.construct(mutator.getName()), fieldType, null, mutator, PropertyMetadata.STD_OPTIONAL);
                        break block18;
                    } else {
                        if (!fieldType.hasRawClass(JsonNode.class) && !fieldType.hasRawClass(ObjectNode.class)) {
                            return (SettableAnyProperty)ctxt.reportBadDefinition(beanDescRef.getType(), String.format("Unsupported type for any-setter: %s -- only support `Map`s, `JsonNode` and `ObjectNode` ", ClassUtil.getTypeDescription(fieldType)));
                        }
                        fieldType = this.resolveMemberAndTypeAnnotations(ctxt, mutator, fieldType);
                        JavaType valueType2 = ctxt.constructType(JsonNode.class);
                        BeanProperty.Std prop2 = new BeanProperty.Std(PropertyName.construct(mutator.getName()), fieldType, null, mutator, PropertyMetadata.STD_OPTIONAL);
                        return SettableAnyProperty.constructForJsonNodeField(ctxt, prop2, mutator, valueType2, ctxt.findRootValueDeserializer(valueType2));
                    }
                }
                if (!isParameter) {
                    return (SettableAnyProperty)ctxt.reportBadDefinition(beanDescRef.getType(), String.format("Unrecognized mutator type for any-setter: %s", ClassUtil.nameOf(mutator.getClass())));
                }
                af = (AnnotatedParameter)mutator;
                JavaType paramType = ((AnnotatedParameter)af).getType();
                parameterIndex = ((AnnotatedParameter)af).getIndex();
                if (paramType.isMapLikeType()) {
                    paramType = this.resolveMemberAndTypeAnnotations(ctxt, mutator, paramType);
                    keyType = paramType.getKeyType();
                    valueType = paramType.getContentType();
                    prop = new BeanProperty.Std(PropertyName.construct(mutator.getName()), paramType, null, mutator, PropertyMetadata.STD_OPTIONAL);
                } else {
                    if (!paramType.hasRawClass(JsonNode.class) && !paramType.hasRawClass(ObjectNode.class)) {
                        return (SettableAnyProperty)ctxt.reportBadDefinition(beanDescRef.getType(), String.format("Unsupported type for any-setter: %s -- only support `Map`s, `JsonNode` and `ObjectNode` ", ClassUtil.getTypeDescription(paramType)));
                    }
                    paramType = this.resolveMemberAndTypeAnnotations(ctxt, mutator, paramType);
                    JavaType valueType3 = ctxt.constructType(JsonNode.class);
                    BeanProperty.Std prop3 = new BeanProperty.Std(PropertyName.construct(mutator.getName()), paramType, null, mutator, PropertyMetadata.STD_OPTIONAL);
                    return SettableAnyProperty.constructForJsonNodeParameter(ctxt, prop3, mutator, valueType3, ctxt.findRootValueDeserializer(valueType3), parameterIndex);
                }
            }
        }
        KeyDeserializer keyDeser = this.findKeyDeserializerFromAnnotation(ctxt, mutator);
        if (keyDeser == null) {
            keyDeser = (KeyDeserializer)keyType.getValueHandler();
        }
        if (keyDeser == null) {
            keyDeser = ctxt.findKeyDeserializer(keyType, prop);
        } else if (keyDeser instanceof ContextualKeyDeserializer) {
            keyDeser = ((ContextualKeyDeserializer)((Object)keyDeser)).createContextual(ctxt, prop);
        }
        ValueDeserializer<Object> deser = this.findContentDeserializerFromAnnotation(ctxt, mutator);
        if (deser == null) {
            deser = (ValueDeserializer<Object>)valueType.getValueHandler();
        }
        if (deser != null) {
            deser = ctxt.handlePrimaryContextualization(deser, prop, valueType);
        }
        TypeDeserializer typeDeser = (TypeDeserializer)valueType.getTypeHandler();
        if (isField) {
            return SettableAnyProperty.constructForMapField(ctxt, prop, mutator, valueType, keyDeser, deser, typeDeser);
        }
        if (isParameter) {
            return SettableAnyProperty.constructForMapParameter(ctxt, prop, mutator, valueType, keyDeser, deser, typeDeser, parameterIndex);
        }
        return SettableAnyProperty.constructForMethod(ctxt, prop, mutator, valueType, keyDeser, deser, typeDeser);
    }

    protected SettableBeanProperty constructSettableProperty(DeserializationContext ctxt, BeanDescription.Supplier beanDescRef, BeanPropertyDefinition propDef, JavaType propType0) {
        ObjectIdInfo objectIdInfo;
        AnnotationIntrospector.ReferenceProperty ref;
        AnnotatedMember mutator = propDef.getNonConstructorMutator();
        if (mutator == null) {
            ctxt.reportBadPropertyDefinition(beanDescRef, propDef, "No non-constructor mutator available", new Object[0]);
        }
        JavaType type = this.resolveMemberAndTypeAnnotations(ctxt, mutator, propType0);
        TypeDeserializer typeDeser = (TypeDeserializer)type.getTypeHandler();
        ValueDeserializer<?> deser = this.findDeserializerFromAnnotation(ctxt, mutator);
        if (deser == null) {
            deser = (ValueDeserializer<?>)type.getValueHandler();
        }
        SettableBeanProperty prop = new MethodProperty(propDef, type, typeDeser, beanDescRef.getClassAnnotations(), mutator);
        if (deser != null) {
            deser = ctxt.handlePrimaryContextualization(deser, prop, type);
            prop = prop.withValueDeserializer(deser);
        }
        if ((ref = propDef.findReferenceType()) != null && ref.isManagedReference()) {
            prop.setManagedReferenceName(ref.getName());
        }
        if ((objectIdInfo = propDef.findObjectIdInfo()) != null) {
            prop.setObjectIdInfo(objectIdInfo);
        }
        return prop;
    }

    protected SettableBeanProperty constructSetterlessProperty(DeserializationContext ctxt, BeanDescription beanDesc, BeanPropertyDefinition propDef) {
        AnnotatedMethod getter = propDef.getGetter();
        JavaType type = this.resolveMemberAndTypeAnnotations(ctxt, getter, getter.getType());
        TypeDeserializer typeDeser = (TypeDeserializer)type.getTypeHandler();
        SettableBeanProperty prop = new SetterlessProperty(propDef, type, typeDeser, beanDesc.getClassAnnotations(), getter);
        ValueDeserializer<?> deser = this.findDeserializerFromAnnotation(ctxt, getter);
        if (deser == null) {
            deser = (ValueDeserializer<?>)type.getValueHandler();
        }
        if (deser != null) {
            deser = ctxt.handlePrimaryContextualization(deser, prop, type);
            prop = ((SettableBeanProperty)prop).withValueDeserializer(deser);
        }
        return prop;
    }

    protected boolean isPotentialBeanType(Class<?> type) {
        String typeStr = ClassUtil.canBeABeanType(type);
        if (typeStr != null) {
            throw new IllegalArgumentException("Cannot deserialize Class " + type.getName() + " (of type " + typeStr + ") as a Bean");
        }
        if (ClassUtil.isProxyType(type)) {
            throw new IllegalArgumentException("Cannot deserialize Proxy class " + type.getName() + " as a Bean");
        }
        typeStr = ClassUtil.isLocalType(type, true);
        if (typeStr != null) {
            throw new IllegalArgumentException("Cannot deserialize Class " + type.getName() + " (of type " + typeStr + ") as a Bean");
        }
        return true;
    }

    protected boolean isIgnorableType(DeserializationContext ctxt, BeanPropertyDefinition propDef, Class<?> type, Map<Class<?>, Boolean> ignoredTypes) {
        Boolean status = ignoredTypes.get(type);
        if (status != null) {
            return status;
        }
        if (type == String.class || type.isPrimitive()) {
            status = Boolean.FALSE;
        } else {
            DeserializationConfig config = ctxt.getConfig();
            status = config.getConfigOverride(type).getIsIgnoredType();
            if (status == null) {
                AnnotatedClass classAnnotations = ctxt.introspectClassAnnotations(type);
                status = ctxt.getAnnotationIntrospector().isIgnorableType(config, classAnnotations);
                if (status == null) {
                    status = Boolean.FALSE;
                }
            }
        }
        ignoredTypes.put(type, status);
        return status;
    }

    protected void _validateSubType(DeserializationContext ctxt, JavaType type, BeanDescription.Supplier beanDescRef) {
        SubTypeValidator.instance().validateSubType(ctxt, type, beanDescRef);
    }
}

